/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.websocket.common.events;

import com.signalfx.shaded.jetty.util.BufferUtil;
import com.signalfx.shaded.jetty.util.Utf8Appendable;
import com.signalfx.shaded.jetty.util.component.AbstractLifeCycle;
import com.signalfx.shaded.jetty.util.log.Log;
import com.signalfx.shaded.jetty.util.log.Logger;
import com.signalfx.shaded.jetty.websocket.api.BadPayloadException;
import com.signalfx.shaded.jetty.websocket.api.BatchMode;
import com.signalfx.shaded.jetty.websocket.api.WebSocketPolicy;
import com.signalfx.shaded.jetty.websocket.api.extensions.Frame;
import com.signalfx.shaded.jetty.websocket.api.extensions.IncomingFrames;
import com.signalfx.shaded.jetty.websocket.common.CloseInfo;
import com.signalfx.shaded.jetty.websocket.common.WebSocketSession;
import com.signalfx.shaded.jetty.websocket.common.events.EventDriver;
import com.signalfx.shaded.jetty.websocket.common.frames.CloseFrame;
import com.signalfx.shaded.jetty.websocket.common.message.MessageAppender;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractEventDriver
extends AbstractLifeCycle
implements IncomingFrames,
EventDriver {
    private static final Logger LOG = Log.getLogger(AbstractEventDriver.class);
    protected final Logger targetLog;
    protected WebSocketPolicy policy;
    protected final Object websocket;
    protected WebSocketSession session;
    protected MessageAppender activeMessage;

    public AbstractEventDriver(WebSocketPolicy policy, Object websocket) {
        this.policy = policy;
        this.websocket = websocket;
        this.targetLog = Log.getLogger(websocket.getClass());
    }

    protected void appendMessage(ByteBuffer buffer, boolean fin) throws IOException {
        this.activeMessage.appendFrame(buffer, fin);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    protected void dispatch(Runnable runnable) {
        this.session.dispatch(runnable);
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public WebSocketSession getSession() {
        return this.session;
    }

    @Override
    public void incomingFrame(Frame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("incomingFrame({})", frame);
        }
        try {
            this.onFrame(frame);
            byte opcode = frame.getOpCode();
            switch (opcode) {
                case 8: {
                    boolean validate = true;
                    CloseFrame closeframe = (CloseFrame)frame;
                    CloseInfo close = new CloseInfo(closeframe, validate);
                    this.session.getConnection().remoteClose(close);
                    return;
                }
                case 9: {
                    ByteBuffer pongBuf;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("PING: {}", BufferUtil.toDetailString(frame.getPayload()));
                    }
                    if (frame.hasPayload()) {
                        pongBuf = ByteBuffer.allocate(frame.getPayload().remaining());
                        BufferUtil.put(frame.getPayload().slice(), pongBuf);
                        BufferUtil.flipToFlush(pongBuf, 0);
                    } else {
                        pongBuf = ByteBuffer.allocate(0);
                    }
                    this.onPing(frame.getPayload());
                    this.session.getRemote().sendPong(pongBuf);
                    break;
                }
                case 10: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("PONG: {}", BufferUtil.toDetailString(frame.getPayload()));
                    }
                    this.onPong(frame.getPayload());
                    break;
                }
                case 2: {
                    this.onBinaryFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                case 1: {
                    this.onTextFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                case 0: {
                    this.onContinuationFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                default: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unhandled OpCode: {}", opcode);
                    }
                    break;
                }
            }
        }
        catch (Utf8Appendable.NotUtf8Exception e) {
            this.session.close(new BadPayloadException(e));
        }
        catch (Throwable t) {
            this.session.close(t);
        }
    }

    @Override
    public void onContinuationFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.activeMessage == null) {
            throw new IOException("Out of order Continuation frame encountered");
        }
        this.appendMessage(buffer, fin);
    }

    @Override
    public void onPong(ByteBuffer buffer) {
    }

    @Override
    public void onPing(ByteBuffer buffer) {
    }

    @Override
    public BatchMode getBatchMode() {
        return null;
    }

    @Override
    public void openSession(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("openSession({})", session);
            LOG.debug("objectFactory={}", session.getContainerScope().getObjectFactory());
        }
        this.session = session;
        this.session.getContainerScope().getObjectFactory().decorate(this.websocket);
        try {
            this.onConnect();
        }
        catch (Throwable t) {
            this.session.close(t);
        }
    }
}

