/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.metrics.connection;

import com.signalfx.shaded.apache.http.config.RegistryBuilder;
import com.signalfx.shaded.apache.http.config.SocketConfig;
import com.signalfx.shaded.apache.http.conn.HttpClientConnectionManager;
import com.signalfx.shaded.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.signalfx.shaded.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.signalfx.shaded.apache.http.impl.conn.BasicHttpClientConnectionManager;
import com.signalfx.shaded.apache.http.ssl.SSLContexts;
import java.io.IOException;
import javax.net.ssl.SSLSocket;

public class HttpClientConnectionManagerFactory {
    private HttpClientConnectionManagerFactory() {
    }

    public static HttpClientConnectionManager withTimeoutMs(int timeoutMs) {
        BasicHttpClientConnectionManager httpClientConnectionManager = new BasicHttpClientConnectionManager(RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)new SSLConnectionSocketFactoryWithTimeout(timeoutMs))).build());
        httpClientConnectionManager.setSocketConfig(SocketConfig.custom().setSoTimeout(timeoutMs).build());
        return httpClientConnectionManager;
    }

    private static class SSLConnectionSocketFactoryWithTimeout
    extends SSLConnectionSocketFactory {
        private final int timeoutMs;

        public SSLConnectionSocketFactoryWithTimeout(int timeoutMs) {
            super(SSLContexts.createDefault(), SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
            this.timeoutMs = timeoutMs;
        }

        @Override
        protected void prepareSocket(SSLSocket socket) throws IOException {
            socket.setSoTimeout(this.timeoutMs);
        }
    }
}

