/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.websocket.common.extensions.identity;

import com.signalfx.shaded.jetty.util.QuotedStringTokenizer;
import com.signalfx.shaded.jetty.util.annotation.ManagedObject;
import com.signalfx.shaded.jetty.websocket.api.BatchMode;
import com.signalfx.shaded.jetty.websocket.api.WriteCallback;
import com.signalfx.shaded.jetty.websocket.api.extensions.ExtensionConfig;
import com.signalfx.shaded.jetty.websocket.api.extensions.Frame;
import com.signalfx.shaded.jetty.websocket.common.extensions.AbstractExtension;

@ManagedObject(value="Identity Extension")
public class IdentityExtension
extends AbstractExtension {
    private String id;

    public String getParam(String key) {
        return this.getConfig().getParameter(key, "?");
    }

    @Override
    public String getName() {
        return "identity";
    }

    @Override
    public void incomingFrame(Frame frame) {
        this.nextIncomingFrame(frame);
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        this.nextOutgoingFrame(frame, callback, batchMode);
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        super.setConfig(config);
        StringBuilder s2 = new StringBuilder();
        s2.append(config.getName());
        s2.append("@").append(Integer.toHexString(this.hashCode()));
        s2.append("[");
        boolean delim = false;
        for (String param : config.getParameterKeys()) {
            if (delim) {
                s2.append(';');
            }
            s2.append(param).append('=').append(QuotedStringTokenizer.quoteIfNeeded(config.getParameter(param, ""), ";="));
            delim = true;
        }
        s2.append("]");
        this.id = s2.toString();
    }

    @Override
    public String toString() {
        return this.id;
    }
}

