/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.metrics.aws;

import com.signalfx.shaded.apache.http.HttpResponse;
import com.signalfx.shaded.apache.http.client.config.RequestConfig;
import com.signalfx.shaded.apache.http.client.methods.HttpGet;
import com.signalfx.shaded.apache.http.impl.client.CloseableHttpClient;
import com.signalfx.shaded.apache.http.impl.client.HttpClientBuilder;
import com.signalfx.shaded.fasterxml.jackson.databind.JsonNode;
import com.signalfx.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSInstanceInfo {
    public static final String DIMENSION_NAME = "AWSUniqueId";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String URL = "http://169.254.169.254/latest/dynamic/instance-identity/document";
    private static final Logger log = LoggerFactory.getLogger(AWSInstanceInfo.class);
    private static final String INSTANCE_ID = "instanceId";
    private static final String REGION = "region";
    private static final String ACCOUNT_ID = "accountId";

    public static String get(int timeoutInMs) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeoutInMs).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        HttpGet request = new HttpGet(URL);
        try {
            HttpResponse response = client.execute(request);
            JsonNode object = MAPPER.readTree(response.getEntity().getContent());
            return object.get(INSTANCE_ID).asText() + "_" + object.get(REGION).asText() + "_" + object.get(ACCOUNT_ID).asText();
        }
        catch (Exception e) {
            log.trace("Exception trying to execute {}, Exception: {} ", (Object)request, (Object)e);
            return null;
        }
    }

    public static String get() {
        return AWSInstanceInfo.get(1000);
    }
}

