/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.client;

import com.signalfx.shaded.jetty.client.HttpChannel;
import com.signalfx.shaded.jetty.client.HttpConversation;
import com.signalfx.shaded.jetty.client.HttpDestination;
import com.signalfx.shaded.jetty.client.HttpRequest;
import com.signalfx.shaded.jetty.client.HttpResponse;
import com.signalfx.shaded.jetty.client.ResponseNotifier;
import com.signalfx.shaded.jetty.client.api.Response;
import com.signalfx.shaded.jetty.client.api.Result;
import com.signalfx.shaded.jetty.util.log.Log;
import com.signalfx.shaded.jetty.util.log.Logger;
import java.util.List;

public class HttpExchange {
    private static final Logger LOG = Log.getLogger(HttpExchange.class);
    private final HttpDestination destination;
    private final HttpRequest request;
    private final List<Response.ResponseListener> listeners;
    private final HttpResponse response;
    private State requestState = State.PENDING;
    private State responseState = State.PENDING;
    private HttpChannel _channel;
    private Throwable requestFailure;
    private Throwable responseFailure;

    public HttpExchange(HttpDestination destination, HttpRequest request, List<Response.ResponseListener> listeners) {
        this.destination = destination;
        this.request = request;
        this.listeners = listeners;
        this.response = new HttpResponse(request, listeners);
        HttpConversation conversation = request.getConversation();
        conversation.getExchanges().offer(this);
        conversation.updateResponseListeners(null);
    }

    public HttpConversation getConversation() {
        return this.request.getConversation();
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getRequestFailure() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return this.requestFailure;
        }
    }

    public List<Response.ResponseListener> getResponseListeners() {
        return this.listeners;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getResponseFailure() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return this.responseFailure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean associate(HttpChannel channel) {
        boolean result = false;
        boolean abort = false;
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            if (this.requestState == State.PENDING && this.responseState == State.PENDING) {
                boolean bl = abort = this._channel != null;
                if (!abort) {
                    this._channel = channel;
                    result = true;
                }
            }
        }
        if (abort) {
            this.request.abort(new IllegalStateException(this.toString()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disassociate(HttpChannel channel) {
        boolean abort = false;
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            if (this._channel != channel || this.requestState != State.TERMINATED || this.responseState != State.TERMINATED) {
                abort = true;
            }
            this._channel = null;
        }
        if (abort) {
            this.request.abort(new IllegalStateException(this.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpChannel getHttpChannel() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return this._channel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestComplete(Throwable failure) {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return this.completeRequest(failure);
        }
    }

    private boolean completeRequest(Throwable failure) {
        if (this.requestState == State.PENDING) {
            this.requestState = State.COMPLETED;
            this.requestFailure = failure;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean responseComplete(Throwable failure) {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return this.completeResponse(failure);
        }
    }

    private boolean completeResponse(Throwable failure) {
        if (this.responseState == State.PENDING) {
            this.responseState = State.COMPLETED;
            this.responseFailure = failure;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result terminateRequest() {
        Result result = null;
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            if (this.requestState == State.COMPLETED) {
                this.requestState = State.TERMINATED;
            }
            if (this.requestState == State.TERMINATED && this.responseState == State.TERMINATED) {
                result = new Result(this.getRequest(), this.requestFailure, this.getResponse(), this.responseFailure);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminated request for {}, result: {}", this, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result terminateResponse() {
        Result result = null;
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            if (this.responseState == State.COMPLETED) {
                this.responseState = State.TERMINATED;
            }
            if (this.requestState == State.TERMINATED && this.responseState == State.TERMINATED) {
                result = new Result(this.getRequest(), this.requestFailure, this.getResponse(), this.responseFailure);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminated response for {}, result: {}", this, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean abort(Throwable failure) {
        boolean abortResponse;
        boolean abortRequest;
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            abortRequest = this.completeRequest(failure);
            abortResponse = this.completeResponse(failure);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failed {}: req={}/rsp={} {}", this, abortRequest, abortResponse, failure);
        }
        if (!abortRequest && !abortResponse) {
            return false;
        }
        if (this.destination.remove(this)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborting while queued {}: {}", this, failure);
            }
            this.notifyFailureComplete(failure);
            return true;
        }
        HttpChannel channel = this.getHttpChannel();
        if (channel == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborted before association {}: {}", this, failure);
            }
            this.notifyFailureComplete(failure);
            return true;
        }
        boolean aborted = channel.abort(this, abortRequest ? failure : null, abortResponse ? failure : null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Aborted ({}) while active {}: {}", aborted, this, failure);
        }
        return aborted;
    }

    private void notifyFailureComplete(Throwable failure) {
        this.destination.getRequestNotifier().notifyFailure(this.request, failure);
        List<Response.ResponseListener> listeners = this.getConversation().getResponseListeners();
        ResponseNotifier responseNotifier = this.destination.getResponseNotifier();
        responseNotifier.notifyFailure(listeners, (Response)this.response, failure);
        responseNotifier.notifyComplete(listeners, new Result(this.request, failure, this.response, failure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetResponse() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            this.responseState = State.PENDING;
            this.responseFailure = null;
        }
    }

    public void proceed(Throwable failure) {
        HttpChannel channel = this.getHttpChannel();
        if (channel != null) {
            channel.proceed(this, failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return String.format("%s@%x{req=%s[%s/%s] res=%s[%s/%s]}", new Object[]{HttpExchange.class.getSimpleName(), this.hashCode(), this.request, this.requestState, this.requestFailure, this.response, this.responseState, this.responseFailure});
        }
    }

    private static enum State {
        PENDING,
        COMPLETED,
        TERMINATED;

    }
}

