/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.metrics.flush;

import com.signalfx.metrics.SignalFxMetricsException;
import com.signalfx.metrics.auth.AuthToken;
import com.signalfx.metrics.auth.NoAuthTokenException;
import com.signalfx.metrics.connection.DataPointReceiver;
import com.signalfx.metrics.connection.DataPointReceiverFactory;
import com.signalfx.metrics.connection.EventReceiver;
import com.signalfx.metrics.connection.EventReceiverFactory;
import com.signalfx.metrics.errorhandler.MetricErrorImpl;
import com.signalfx.metrics.errorhandler.MetricErrorType;
import com.signalfx.metrics.errorhandler.OnSendErrorHandler;
import com.signalfx.metrics.protobuf.SignalFxProtocolBuffers;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AggregateMetricSender {
    private final String defaultSourceName;
    private final Set<String> registeredMetricPairs;
    private final DataPointReceiverFactory dataPointReceiverFactory;
    private final EventReceiverFactory eventReceiverFactory;
    private final AuthToken authToken;
    private final Collection<OnSendErrorHandler> onSendErrorHandlerCollection;

    public AggregateMetricSender(String defaultSourceName, DataPointReceiverFactory dataPointReceiverFactory, AuthToken authToken, Collection<OnSendErrorHandler> onSendErrorHandlerCollection) {
        this(defaultSourceName, dataPointReceiverFactory, null, authToken, onSendErrorHandlerCollection);
    }

    public AggregateMetricSender(String defaultSourceName, EventReceiverFactory eventReceiverFactory, AuthToken authToken, Collection<OnSendErrorHandler> onSendErrorHandlerCollection) {
        this(defaultSourceName, null, eventReceiverFactory, authToken, onSendErrorHandlerCollection);
    }

    public AggregateMetricSender(String defaultSourceName, DataPointReceiverFactory dataPointReceiverFactory, EventReceiverFactory eventReceiverFactory, AuthToken authToken, Collection<OnSendErrorHandler> onSendErrorHandlerCollection) {
        this.defaultSourceName = defaultSourceName;
        this.dataPointReceiverFactory = dataPointReceiverFactory;
        this.eventReceiverFactory = eventReceiverFactory;
        this.authToken = authToken;
        this.onSendErrorHandlerCollection = onSendErrorHandlerCollection;
        this.registeredMetricPairs = new HashSet<String>();
    }

    public String getDefaultSourceName() {
        return this.defaultSourceName;
    }

    private void communicateError(String message, MetricErrorType code, SignalFxMetricsException signalfxMetricsException) {
        for (OnSendErrorHandler onSendErrorHandler : this.onSendErrorHandlerCollection) {
            onSendErrorHandler.handleError(new MetricErrorImpl(message, code, signalfxMetricsException));
        }
    }

    public Session createSession() {
        return new SessionImpl();
    }

    private final class SessionImpl
    implements Session {
        private final Map<String, SignalFxProtocolBuffers.MetricType> toBeRegisteredMetricPairs = new HashMap<String, SignalFxProtocolBuffers.MetricType>();
        private final List<SignalFxProtocolBuffers.DataPoint> pointsToFlush = new ArrayList<SignalFxProtocolBuffers.DataPoint>();
        private final List<SignalFxProtocolBuffers.Event> eventsToFlush = new ArrayList<SignalFxProtocolBuffers.Event>();

        private SessionImpl() {
        }

        @Override
        public Session setCumulativeCounter(String metric, long value) {
            return this.setCumulativeCounter(AggregateMetricSender.this.defaultSourceName, metric, value);
        }

        @Override
        public Session setCumulativeCounter(String source, String metric, long value) {
            this.setDatapoint(source, metric, SignalFxProtocolBuffers.MetricType.CUMULATIVE_COUNTER, value);
            return this;
        }

        @Override
        public Session incrementCounter(String metric, long value) {
            return this.incrementCounter(AggregateMetricSender.this.defaultSourceName, metric, value);
        }

        @Override
        public Session incrementCounter(String source, String metric, long value) {
            this.setDatapoint(source, metric, SignalFxProtocolBuffers.MetricType.COUNTER, value);
            return this;
        }

        @Override
        public Session setDatapoint(String source, String metric, SignalFxProtocolBuffers.MetricType metricType, long value) {
            this.check(metric, metricType);
            this.pointsToFlush.add(SignalFxProtocolBuffers.DataPoint.newBuilder().setSource(source).setMetricType(metricType).setMetric(metric).setValue(SignalFxProtocolBuffers.Datum.newBuilder().setIntValue(value).build()).build());
            return this;
        }

        @Override
        public Session setDatapoint(String source, String metric, SignalFxProtocolBuffers.MetricType metricType, double value) {
            this.check(metric, metricType);
            this.pointsToFlush.add(SignalFxProtocolBuffers.DataPoint.newBuilder().setSource(source).setMetricType(metricType).setMetric(metric).setValue(SignalFxProtocolBuffers.Datum.newBuilder().setDoubleValue(value).build()).build());
            return this;
        }

        @Override
        public Session setDatapoint(SignalFxProtocolBuffers.DataPoint datapoint) {
            this.check(datapoint.getMetric(), datapoint.getMetricType());
            this.pointsToFlush.add(datapoint);
            return this;
        }

        @Override
        public Session setEvent(SignalFxProtocolBuffers.Event event) {
            this.eventsToFlush.add(event);
            return this;
        }

        @Override
        public Session setGauge(String metric, long value) {
            return this.setGauge(AggregateMetricSender.this.defaultSourceName, metric, value);
        }

        @Override
        public Session setGauge(String source, String metric, long value) {
            this.setDatapoint(source, metric, SignalFxProtocolBuffers.MetricType.GAUGE, value);
            return this;
        }

        @Override
        public Session setGauge(String metric, double value) {
            return this.setGauge(AggregateMetricSender.this.defaultSourceName, metric, value);
        }

        @Override
        public Session setGauge(String source, String metric, double value) {
            this.setDatapoint(source, metric, SignalFxProtocolBuffers.MetricType.GAUGE, value);
            return this;
        }

        private void check(String metricPair, SignalFxProtocolBuffers.MetricType metricType) {
            if (!AggregateMetricSender.this.registeredMetricPairs.contains(metricPair)) {
                this.toBeRegisteredMetricPairs.put(metricPair, metricType);
            }
        }

        @Override
        public void close() {
            String authTokenStr;
            try {
                authTokenStr = AggregateMetricSender.this.authToken.getAuthToken();
            }
            catch (NoAuthTokenException e) {
                AggregateMetricSender.this.communicateError("Unable to get auth token", MetricErrorType.AUTH_TOKEN_ERROR, e);
                return;
            }
            this.flushDatapoints(authTokenStr);
            this.flushEvents(authTokenStr);
        }

        private void flushDatapoints(String authTokenStr) {
            if (this.pointsToFlush.isEmpty()) {
                return;
            }
            if (AggregateMetricSender.this.dataPointReceiverFactory == null) {
                AggregateMetricSender.this.communicateError("DataPointReceiverFactory object is not set", MetricErrorType.DATAPOINT_SEND_ERROR, new SignalFxMetricsException());
                return;
            }
            DataPointReceiver dataPointReceiver = AggregateMetricSender.this.dataPointReceiverFactory.createDataPointReceiver();
            if (!this.toBeRegisteredMetricPairs.isEmpty()) {
                try {
                    Map<String, Boolean> registeredPairs = dataPointReceiver.registerMetrics(authTokenStr, this.toBeRegisteredMetricPairs);
                    for (Map.Entry<String, Boolean> i : registeredPairs.entrySet()) {
                        if (!i.getValue().booleanValue()) continue;
                        AggregateMetricSender.this.registeredMetricPairs.add(i.getKey());
                    }
                }
                catch (SignalFxMetricsException e) {
                    AggregateMetricSender.this.communicateError("Unable to register metrics", MetricErrorType.REGISTRATION_ERROR, e);
                    return;
                }
            }
            Iterator<SignalFxProtocolBuffers.DataPoint> i = this.pointsToFlush.iterator();
            while (i.hasNext()) {
                SignalFxProtocolBuffers.DataPoint currentEntry = i.next();
                if (AggregateMetricSender.this.registeredMetricPairs.contains(currentEntry.getMetric())) continue;
                i.remove();
            }
            try {
                dataPointReceiver.addDataPoints(authTokenStr, this.pointsToFlush);
            }
            catch (SignalFxMetricsException e) {
                AggregateMetricSender.this.communicateError("Unable to send datapoints", MetricErrorType.DATAPOINT_SEND_ERROR, e);
            }
        }

        private void flushEvents(String authTokenStr) {
            if (this.eventsToFlush.isEmpty()) {
                return;
            }
            if (AggregateMetricSender.this.eventReceiverFactory == null) {
                AggregateMetricSender.this.communicateError("EventReceiverFactory object is not set", MetricErrorType.EVENT_SEND_ERROR, new SignalFxMetricsException());
                return;
            }
            try {
                EventReceiver eventReceiver = AggregateMetricSender.this.eventReceiverFactory.createEventReceiver();
                eventReceiver.addEvents(authTokenStr, this.eventsToFlush);
            }
            catch (SignalFxMetricsException e) {
                AggregateMetricSender.this.communicateError("Unable to send events", MetricErrorType.EVENT_SEND_ERROR, e);
            }
        }
    }

    public static interface Session
    extends Closeable {
        public Session setCumulativeCounter(String var1, long var2);

        public Session setCumulativeCounter(String var1, String var2, long var3);

        public Session setGauge(String var1, long var2);

        public Session setGauge(String var1, String var2, long var3);

        public Session setGauge(String var1, double var2);

        public Session setGauge(String var1, String var2, double var3);

        public Session incrementCounter(String var1, long var2);

        public Session incrementCounter(String var1, String var2, long var3);

        public Session setDatapoint(String var1, String var2, SignalFxProtocolBuffers.MetricType var3, long var4);

        public Session setDatapoint(String var1, String var2, SignalFxProtocolBuffers.MetricType var3, double var4);

        public Session setDatapoint(SignalFxProtocolBuffers.DataPoint var1);

        public Session setEvent(SignalFxProtocolBuffers.Event var1);
    }
}

