/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.signalflow;

import com.signalfx.shaded.google.common.base.Preconditions;
import com.signalfx.shaded.google.common.collect.ImmutableMap;
import com.signalfx.signalflow.Computation;
import com.signalfx.signalflow.SignalFlowTransport;
import com.signalfx.signalflow.WebSocketTransport;
import java.util.Collections;
import java.util.Map;

public class SignalFlowClient {
    private SignalFlowTransport transport;

    public SignalFlowClient(String token) {
        this(new WebSocketTransport.TransportBuilder(token).build());
    }

    public SignalFlowClient(SignalFlowTransport transport) {
        this.transport = transport;
    }

    public Computation execute(String program) {
        return new Computation(this.transport, program, Collections.<String, String>emptyMap(), false);
    }

    @Deprecated
    public Computation execute(String program, long start, long stop, long resolution, long maxDelay, boolean persistent) {
        return this.execute(program, start, stop, resolution, maxDelay, persistent, false);
    }

    public Computation execute(String program, Long start, Long stop, Long resolution, Long maxDelay, Boolean persistent, Boolean immediate) {
        Map<String, String> params = SignalFlowClient.buildParams("start", start, "stop", stop, "resolution", resolution, "maxDelay", maxDelay, "persistent", persistent, "immediate", immediate);
        return new Computation(this.transport, program, params, false);
    }

    public void start(String program) {
        this.transport.start(program, Collections.<String, String>emptyMap());
    }

    public void start(String program, long start, long stop, long resolution, long maxDelay) {
        Map<String, String> params = SignalFlowClient.buildParams("start", start, "stop", stop, "resolution", resolution, "maxDelay", maxDelay);
        this.transport.start(program, params);
    }

    public void stop(Computation computation, String reason) {
        this.stop(computation.getId(), reason);
        computation.close();
    }

    public void stop(String handle, String reason) {
        Map<String, String> params = SignalFlowClient.buildParams("reason", reason);
        this.transport.stop(handle, params);
    }

    public void keepalive(String handle) {
        this.transport.keepalive(handle);
    }

    public Computation attach(String handle, String filters, long resolution) {
        return new Computation(this.transport, handle, SignalFlowClient.buildParams("filters", filters, "resolution", resolution), true);
    }

    public void close() {
        this.transport.close(1000, null);
    }

    private static Map<String, String> buildParams(Object ... params) {
        Preconditions.checkArgument(params.length % 2 == 0);
        ImmutableMap.Builder<String, String> builder = new ImmutableMap.Builder<String, String>();
        for (int i = 0; i < params.length; i += 2) {
            if (params[i] == null || params[i + 1] == null) continue;
            builder.put(params[i].toString(), params[i + 1].toString());
        }
        return builder.build();
    }
}

