/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.websocket.common.events;

import com.signalfx.shaded.jetty.util.log.Log;
import com.signalfx.shaded.jetty.util.log.Logger;
import com.signalfx.shaded.jetty.websocket.api.WebSocketListener;
import com.signalfx.shaded.jetty.websocket.api.WebSocketPolicy;
import com.signalfx.shaded.jetty.websocket.api.extensions.Frame;
import com.signalfx.shaded.jetty.websocket.common.CloseInfo;
import com.signalfx.shaded.jetty.websocket.common.events.AbstractEventDriver;
import com.signalfx.shaded.jetty.websocket.common.message.SimpleBinaryMessage;
import com.signalfx.shaded.jetty.websocket.common.message.SimpleTextMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;

public class JettyListenerEventDriver
extends AbstractEventDriver {
    private static final Logger LOG = Log.getLogger(JettyListenerEventDriver.class);
    private final WebSocketListener listener;
    private boolean hasCloseBeenCalled = false;

    public JettyListenerEventDriver(WebSocketPolicy policy, WebSocketListener listener) {
        super(policy, listener);
        this.listener = listener;
    }

    @Override
    public void onBinaryFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.activeMessage == null) {
            this.activeMessage = new SimpleBinaryMessage(this);
        }
        this.appendMessage(buffer, fin);
    }

    @Override
    public void onBinaryMessage(byte[] data) {
        this.listener.onWebSocketBinary(data, 0, data.length);
    }

    @Override
    public void onClose(CloseInfo close) {
        if (this.hasCloseBeenCalled) {
            return;
        }
        this.hasCloseBeenCalled = true;
        int statusCode = close.getStatusCode();
        String reason = close.getReason();
        this.listener.onWebSocketClose(statusCode, reason);
    }

    @Override
    public void onConnect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onConnect()", new Object[0]);
        }
        this.listener.onWebSocketConnect(this.session);
    }

    @Override
    public void onError(Throwable cause) {
        this.listener.onWebSocketError(cause);
    }

    @Override
    public void onFrame(Frame frame) {
    }

    @Override
    public void onInputStream(InputStream stream) {
    }

    @Override
    public void onReader(Reader reader) {
    }

    @Override
    public void onTextFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.activeMessage == null) {
            this.activeMessage = new SimpleTextMessage(this);
        }
        this.appendMessage(buffer, fin);
    }

    @Override
    public void onTextMessage(String message) {
        this.listener.onWebSocketText(message);
    }

    public String toString() {
        return String.format("%s[%s]", JettyListenerEventDriver.class.getSimpleName(), this.listener.getClass().getName());
    }
}

