/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.websocket.client.io;

import com.signalfx.shaded.jetty.io.EndPoint;
import com.signalfx.shaded.jetty.util.log.Log;
import com.signalfx.shaded.jetty.util.log.Logger;
import com.signalfx.shaded.jetty.websocket.api.BatchMode;
import com.signalfx.shaded.jetty.websocket.api.WebSocketPolicy;
import com.signalfx.shaded.jetty.websocket.api.WriteCallback;
import com.signalfx.shaded.jetty.websocket.api.extensions.Frame;
import com.signalfx.shaded.jetty.websocket.api.extensions.IncomingFrames;
import com.signalfx.shaded.jetty.websocket.client.io.ConnectPromise;
import com.signalfx.shaded.jetty.websocket.client.io.ConnectionManager;
import com.signalfx.shaded.jetty.websocket.client.masks.Masker;
import com.signalfx.shaded.jetty.websocket.common.WebSocketFrame;
import com.signalfx.shaded.jetty.websocket.common.WebSocketSession;
import com.signalfx.shaded.jetty.websocket.common.io.AbstractWebSocketConnection;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class WebSocketClientConnection
extends AbstractWebSocketConnection {
    private static final Logger LOG = Log.getLogger(WebSocketClientConnection.class);
    private final ConnectPromise connectPromise;
    private final Masker masker;
    private final AtomicBoolean opened = new AtomicBoolean(false);

    public WebSocketClientConnection(EndPoint endp, Executor executor, ConnectPromise connectPromise, WebSocketPolicy policy) {
        super(endp, executor, connectPromise.getClient().getScheduler(), policy, connectPromise.getClient().getBufferPool());
        this.connectPromise = connectPromise;
        this.masker = connectPromise.getMasker();
        assert (this.masker != null);
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    @Override
    public void onClose() {
        super.onClose();
        ConnectionManager connectionManager = this.connectPromise.getClient().getConnectionManager();
        connectionManager.removeSession(this.getSession());
    }

    @Override
    public void onOpen() {
        boolean beenOpened = this.opened.getAndSet(true);
        if (!beenOpened) {
            WebSocketSession session = this.getSession();
            ConnectionManager connectionManager = this.connectPromise.getClient().getConnectionManager();
            connectionManager.addSession(session);
            this.connectPromise.succeeded(session);
            ByteBuffer extraBuf = this.connectPromise.getResponse().getRemainingBuffer();
            if (extraBuf.hasRemaining()) {
                LOG.debug("Parsing extra remaining buffer from UpgradeConnection", new Object[0]);
                this.getParser().parse(extraBuf);
            }
        }
        super.onOpen();
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (frame instanceof WebSocketFrame) {
            this.masker.setMask((WebSocketFrame)frame);
        }
        super.outgoingFrame(frame, callback, batchMode);
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.getParser().setIncomingFramesHandler(incoming);
    }
}

