/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.apache.http.impl.cookie;

import com.signalfx.shaded.apache.http.annotation.Contract;
import com.signalfx.shaded.apache.http.annotation.ThreadingBehavior;
import com.signalfx.shaded.apache.http.cookie.CommonCookieAttributeHandler;
import com.signalfx.shaded.apache.http.cookie.Cookie;
import com.signalfx.shaded.apache.http.cookie.CookieOrigin;
import com.signalfx.shaded.apache.http.cookie.MalformedCookieException;
import com.signalfx.shaded.apache.http.cookie.SetCookie;
import com.signalfx.shaded.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.signalfx.shaded.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

