/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.util;

import com.signalfx.shaded.jetty.util.Callback;
import java.util.concurrent.atomic.AtomicInteger;

public class CountingCallback
implements Callback {
    private final Callback callback;
    private final AtomicInteger count;

    public CountingCallback(Callback callback, int count) {
        this.callback = callback;
        this.count = new AtomicInteger(count);
    }

    @Override
    public void succeeded() {
        int current;
        do {
            if ((current = this.count.get()) != 0) continue;
            return;
        } while (!this.count.compareAndSet(current, current - 1));
        if (current == 1) {
            this.callback.succeeded();
        }
    }

    @Override
    public void failed(Throwable failure) {
        int current;
        do {
            if ((current = this.count.get()) != 0) continue;
            return;
        } while (!this.count.compareAndSet(current, 0));
        this.callback.failed(failure);
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

