/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.metrics.connection;

import com.signalfx.common.proto.ProtocolBufferStreamingInputStream;
import com.signalfx.connection.AbstractHttpReceiverConnection;
import com.signalfx.endpoint.SignalFxReceiverEndpoint;
import com.signalfx.metrics.SignalFxMetricsException;
import com.signalfx.metrics.connection.DataPointReceiver;
import com.signalfx.metrics.protobuf.SignalFxProtocolBuffers;
import com.signalfx.shaded.apache.http.HttpEntity;
import com.signalfx.shaded.apache.http.client.utils.URLEncodedUtils;
import com.signalfx.shaded.apache.http.conn.HttpClientConnectionManager;
import com.signalfx.shaded.apache.http.entity.ContentType;
import com.signalfx.shaded.apache.http.entity.InputStreamEntity;
import com.signalfx.shaded.apache.http.message.BasicNameValuePair;
import com.signalfx.shaded.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractHttpDataPointProtobufReceiverConnection
extends AbstractHttpReceiverConnection
implements DataPointReceiver {
    protected static final ContentType PROTO_TYPE = ContentType.create("application/x-protobuf");
    private final boolean compress = !Boolean.getBoolean("com.signalfx.public.java.disableHttpCompression");

    public AbstractHttpDataPointProtobufReceiverConnection(SignalFxReceiverEndpoint endpoint, int timeoutMs, HttpClientConnectionManager httpClientConnectionManager) {
        super(endpoint, timeoutMs, httpClientConnectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDataPoints(String auth, List<SignalFxProtocolBuffers.DataPoint> dataPoints) throws SignalFxMetricsException {
        if (dataPoints.isEmpty()) {
            return;
        }
        try {
            Closeable resp = null;
            try {
                resp = this.postToEndpoint(auth, this.getEntityForVersion(dataPoints), this.getEndpointForAddDatapoints(), this.compress);
                int code = resp.getStatusLine().getStatusCode();
                if (code != 200) {
                    throw new SignalFxMetricsException("Invalid status code " + code);
                }
            }
            finally {
                if (resp != null) {
                    resp.close();
                }
            }
        }
        catch (IOException e) {
            throw new SignalFxMetricsException("Exception posting to addDataPoints", e);
        }
    }

    protected abstract String getEndpointForAddDatapoints();

    protected abstract HttpEntity getEntityForVersion(List<SignalFxProtocolBuffers.DataPoint> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backfillDataPoints(String auth, String metric, String metricType, String orgId, Map<String, String> dimensions, List<SignalFxProtocolBuffers.PointValue> datumPoints) throws SignalFxMetricsException {
        if (datumPoints.isEmpty()) {
            return;
        }
        ArrayList<BasicNameValuePair> params = Lists.newArrayList();
        params.add(new BasicNameValuePair("orgid", orgId));
        params.add(new BasicNameValuePair("metric_type", metricType));
        params.add(new BasicNameValuePair("metric", metric));
        for (Map.Entry<String, String> entry : dimensions.entrySet()) {
            params.add(new BasicNameValuePair("sfxdim_" + entry.getKey(), entry.getValue()));
        }
        try {
            Closeable resp = null;
            try {
                resp = this.postToEndpoint(auth, new InputStreamEntity(new ProtocolBufferStreamingInputStream<SignalFxProtocolBuffers.PointValue>(datumPoints.iterator()), PROTO_TYPE), "/v1/backfill?" + URLEncodedUtils.format(params, StandardCharsets.UTF_8), false);
                int code = resp.getStatusLine().getStatusCode();
                if (code != 200) {
                    throw new SignalFxMetricsException("Invalid status code " + code);
                }
            }
            finally {
                if (resp != null) {
                    resp.close();
                }
            }
        }
        catch (IOException e) {
            throw new SignalFxMetricsException("Exception posting to backfillDataPoints", e);
        }
    }
}

