/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.signalflow;

import com.signalfx.shaded.apache.commons.lang3.RandomStringUtils;
import com.signalfx.shaded.slf4j.Logger;
import com.signalfx.shaded.slf4j.LoggerFactory;
import com.signalfx.signalflow.ChannelMessage;
import com.signalfx.signalflow.StreamMessage;
import java.io.Closeable;
import java.util.Iterator;

public abstract class Channel
implements Iterator<ChannelMessage>,
Closeable {
    protected static final Logger log = LoggerFactory.getLogger(Channel.class);
    private static final int CHANNEL_NAME_LENGTH = 8;
    protected final String name;
    protected boolean isClosed = false;
    protected Iterator<StreamMessage> iterator;

    protected Channel() {
        this.name = "channel-" + RandomStringUtils.random(8, true, true);
    }

    public Channel(Iterator<StreamMessage> iterator) {
        this.iterator = iterator;
        this.name = "channel-" + RandomStringUtils.random(8, true, true);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasNext() {
        if (!this.isClosed()) {
            return this.iterator.hasNext();
        }
        throw new IllegalStateException("channel is closed");
    }

    @Override
    public ChannelMessage next() {
        if (!this.isClosed()) {
            ChannelMessage message = null;
            while (message == null) {
                StreamMessage streamMessage = this.iterator.next();
                message = ChannelMessage.decodeStreamMessage(streamMessage);
                if (message != null) continue;
                log.warn("Unsupported control message {}. ignoring!", (Object)streamMessage);
            }
            return message;
        }
        throw new IllegalStateException("channel is closed");
    }

    @Override
    public void remove() {
        if (this.isClosed()) {
            throw new IllegalStateException("channel is closed");
        }
        this.iterator.remove();
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String toString() {
        return "channel<" + this.name + ">";
    }
}

