/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.common.proto;

import com.google.protobuf.MessageLite;
import com.signalfx.common.proto.PeekableByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public final class ProtocolBufferStreamingInputStream<ProtocolBufferObject extends MessageLite>
extends InputStream {
    public static final int DEFAULT_STREAM_SIZE = 1024;
    private final Iterator<ProtocolBufferObject> protoBufferIterator;
    private final PeekableByteArrayOutputStream currentBytes;

    public ProtocolBufferStreamingInputStream(Iterator<ProtocolBufferObject> protoBufferIterator) {
        this.protoBufferIterator = protoBufferIterator;
        this.currentBytes = new PeekableByteArrayOutputStream(1024);
    }

    private void fillBytes() throws IOException {
        if (this.currentBytes.available() > 0) {
            return;
        }
        this.currentBytes.reset();
        while (this.protoBufferIterator.hasNext() && this.currentBytes.size() <= 1000) {
            ((MessageLite)this.protoBufferIterator.next()).writeDelimitedTo(this.currentBytes);
        }
    }

    @Override
    public int read() throws IOException {
        this.fillBytes();
        return this.currentBytes.read();
    }

    @Override
    public int available() {
        return this.currentBytes.available();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.currentBytes.close();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int total_read = 0;
        while (len > 0) {
            this.fillBytes();
            int result = this.currentBytes.read(b, off, len);
            if (result == -1) {
                return total_read == 0 ? -1 : total_read;
            }
            len -= result;
            total_read += result;
            off += result;
        }
        return total_read;
    }
}

