/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.connection;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.signalfx.endpoint.SignalFxReceiverEndpoint;
import com.signalfx.metrics.SignalFxMetricsException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpReceiverConnection {
    protected static final Logger log = LoggerFactory.getLogger(AbstractHttpReceiverConnection.class);
    public static final String VERSION_NUMBER = "0.0.38";
    public static final String USER_AGENT = "SignalFx-java-client/0.0.38";
    protected static final ObjectMapper MAPPER = new ObjectMapper();
    protected static final ContentType JSON_TYPE = ContentType.APPLICATION_JSON;
    protected final CloseableHttpClient client;
    protected final HttpHost host;
    protected final RequestConfig requestConfig;

    protected AbstractHttpReceiverConnection(SignalFxReceiverEndpoint endpoint, int timeoutMs, HttpClientConnectionManager httpClientConnectionManager) {
        this.client = HttpClientBuilder.create().setConnectionManager(httpClientConnectionManager).build();
        this.host = new HttpHost(endpoint.getHostname(), endpoint.getPort(), endpoint.getScheme());
        HttpHost proxy = this.createHttpProxyFromSystemProperties(endpoint.getHostname());
        this.requestConfig = RequestConfig.custom().setSocketTimeout(timeoutMs).setConnectionRequestTimeout(timeoutMs).setConnectTimeout(timeoutMs).setProxy(proxy).build();
    }

    protected CloseableHttpResponse postToEndpoint(String auth, HttpEntity httpEntity, String endpoint) throws IOException {
        HttpPost http_post = new HttpPost(String.format("%s%s", this.host.toURI(), endpoint));
        http_post.setConfig(this.requestConfig);
        http_post.setHeader("X-SF-TOKEN", auth);
        http_post.setHeader("User-Agent", USER_AGENT);
        http_post.setEntity(httpEntity);
        try {
            log.trace("Talking to endpoint {}", (Object)http_post);
            return this.client.execute((HttpUriRequest)http_post);
        }
        catch (IOException e) {
            log.trace("Exception trying to execute {}, Exception: {} ", (Object)http_post, (Object)e);
            throw e;
        }
    }

    protected void checkHttpResponse(CloseableHttpResponse resp) throws SignalFxMetricsException {
        String body;
        try {
            body = IOUtils.toString((InputStream)resp.getEntity().getContent());
        }
        catch (IOException e) {
            throw new SignalFxMetricsException("Unable to get reponse content", e);
        }
        if (resp.getStatusLine().getStatusCode() != 200) {
            throw new SignalFxMetricsException("Invalid status code " + resp.getStatusLine().getStatusCode() + ": " + body);
        }
        if (!"\"OK\"".equals(body)) {
            throw new SignalFxMetricsException("Invalid response body: " + body);
        }
    }

    protected HttpHost createHttpProxyFromSystemProperties(String endpointHostname) {
        String proxyHost = System.getProperty("http.proxyHost");
        if (proxyHost != null && proxyHost.trim().length() > 0) {
            String proxyPort;
            String nonProxyHosts = System.getProperty("http.nonProxyHosts");
            if (nonProxyHosts != null) {
                nonProxyHosts = nonProxyHosts.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*?");
                nonProxyHosts = "(" + nonProxyHosts.replaceAll("\\|", ")|(") + ")";
                Pattern pattern = Pattern.compile(nonProxyHosts);
                if (pattern.matcher(endpointHostname).find()) {
                    return null;
                }
            }
            if ((proxyPort = System.getProperty("http.proxyPort")) == null || proxyPort.trim().length() == 0) {
                proxyPort = "80";
            }
            return new HttpHost(proxyHost.trim(), Integer.parseInt(proxyPort.trim()), "http");
        }
        return null;
    }
}

