/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.signalflow;

import com.signalfx.signalflow.ChannelMessage;
import com.signalfx.signalflow.Computation;
import com.signalfx.signalflow.ComputationAbortedException;
import com.signalfx.signalflow.ComputationFailedException;
import com.signalfx.signalflow.SignalFlowException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComputationHandler
implements Callable<Computation> {
    protected static final Logger log = LoggerFactory.getLogger(ComputationHandler.class);
    protected Computation computation;
    private Long startTimeMs;
    private Long stopTimeMs;

    public ComputationHandler(Computation computation) {
        this.computation = computation;
    }

    protected void onMessage(ChannelMessage.JobStartMessage message) {
    }

    protected void onMessage(ChannelMessage.JobProgressMessage message) {
    }

    protected void onMessage(ChannelMessage.DataMessage message) {
    }

    protected void onMessage(ChannelMessage.EventMessage message) {
    }

    protected void onMessage(ChannelMessage.MetadataMessage message) {
    }

    public Long getStartTimeMs() {
        return this.startTimeMs;
    }

    public Long getStopTimeMs() {
        return this.stopTimeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Computation process() throws ComputationAbortedException, ComputationFailedException, SignalFlowException, IllegalStateException {
        if (this.computation.getState() == Computation.State.STATE_COMPLETED) {
            throw new IllegalStateException("computation is completed");
        }
        this.startTimeMs = System.currentTimeMillis();
        this.stopTimeMs = null;
        try {
            for (ChannelMessage message : this.computation) {
                switch (message.getType()) {
                    case JOB_START: {
                        ChannelMessage.JobStartMessage jobStartMessage = (ChannelMessage.JobStartMessage)message;
                        this.onMessage(jobStartMessage);
                        break;
                    }
                    case JOB_PROGRESS: {
                        ChannelMessage.JobProgressMessage jobProgressMessage = (ChannelMessage.JobProgressMessage)message;
                        this.onMessage(jobProgressMessage);
                        break;
                    }
                    case DATA_MESSAGE: {
                        ChannelMessage.DataMessage dataMessage = (ChannelMessage.DataMessage)message;
                        this.onMessage(dataMessage);
                        break;
                    }
                    case EVENT_MESSAGE: {
                        ChannelMessage.EventMessage eventMessage = (ChannelMessage.EventMessage)message;
                        this.onMessage(eventMessage);
                        break;
                    }
                    case METADATA_MESSAGE: {
                        ChannelMessage.MetadataMessage metadataMessage = (ChannelMessage.MetadataMessage)message;
                        this.onMessage(metadataMessage);
                        break;
                    }
                }
            }
        }
        finally {
            this.stopTimeMs = System.currentTimeMillis();
            this.close();
        }
        return this.computation;
    }

    public void close() {
        this.computation.close();
    }

    @Override
    public Computation call() throws ComputationAbortedException, ComputationFailedException, SignalFlowException, IllegalStateException {
        return this.process();
    }
}

