/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.signalflow;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.signalfx.signalflow.Computation;
import com.signalfx.signalflow.SignalFlowTransport;
import com.signalfx.signalflow.WebSocketTransport;
import java.util.Collections;
import java.util.Map;

public class SignalFlowClient {
    private SignalFlowTransport transport;

    public SignalFlowClient(String token) {
        this.transport = new WebSocketTransport.TransportBuilder(token).build();
    }

    public SignalFlowClient(SignalFlowTransport transport) {
        this.transport = transport;
    }

    public Computation execute(String program) {
        return new Computation(this.transport, program, Collections.<String, String>emptyMap(), false);
    }

    public Computation execute(String program, Long start, Long stop, Integer resolution, Integer maxDelay, Boolean persistent) {
        Map<String, String> params = SignalFlowClient.buildParams("start", start, "stop", stop, "resolution", resolution, "maxDelay", maxDelay, "persistent", persistent);
        return new Computation(this.transport, program, params, false);
    }

    public void start(String program) {
        this.transport.start(program, Collections.<String, String>emptyMap());
    }

    public void start(String program, Long start, Long stop, Integer resolution, Integer maxDelay) {
        Map<String, String> params = SignalFlowClient.buildParams("start", start, "stop", stop, "resolution", resolution, "maxDelay", maxDelay);
        this.transport.start(program, params);
    }

    public void stop(Computation computation, String reason) {
        this.stop(computation.getId(), reason);
        computation.close();
    }

    public void stop(String handle, String reason) {
        Map<String, String> params = SignalFlowClient.buildParams("reason", reason);
        this.transport.stop(handle, params);
    }

    public void keepalive(String handle) {
        this.transport.keepalive(handle);
    }

    public Computation attach(String handle, String filters, Integer resolution) {
        return new Computation(this.transport, handle, SignalFlowClient.buildParams("filters", filters, "resolution", resolution), true);
    }

    public void close() {
        this.transport.close(1000, null);
    }

    private static Map<String, String> buildParams(Object ... params) {
        Preconditions.checkArgument((params.length % 2 == 0 ? 1 : 0) != 0);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (int i = 0; i < params.length; i += 2) {
            if (params[i] == null || params[i + 1] == null) continue;
            builder.put((Object)params[i].toString(), (Object)params[i + 1].toString());
        }
        return builder.build();
    }
}

