/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.metrics.connection;

import com.signalfx.common.proto.ProtocolBufferStreamingInputStream;
import com.signalfx.connection.AbstractHttpReceiverConnection;
import com.signalfx.endpoint.SignalFxReceiverEndpoint;
import com.signalfx.metrics.SignalFxMetricsException;
import com.signalfx.metrics.connection.DataPointReceiver;
import com.signalfx.metrics.protobuf.SignalFxProtocolBuffers;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;

public abstract class AbstractHttpDataPointProtobufReceiverConnection
extends AbstractHttpReceiverConnection
implements DataPointReceiver {
    protected static final ContentType PROTO_TYPE = ContentType.create((String)"application/x-protobuf");

    public AbstractHttpDataPointProtobufReceiverConnection(SignalFxReceiverEndpoint endpoint, int timeoutMs, HttpClientConnectionManager httpClientConnectionManager) {
        super(endpoint, timeoutMs, httpClientConnectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDataPoints(String auth, List<SignalFxProtocolBuffers.DataPoint> dataPoints) throws SignalFxMetricsException {
        if (dataPoints.isEmpty()) {
            return;
        }
        try {
            CloseableHttpResponse resp = null;
            try {
                String body;
                resp = this.postToEndpoint(auth, this.getEntityForVersion(dataPoints), this.getEndpointForAddDatapoints());
                try {
                    body = IOUtils.toString((InputStream)resp.getEntity().getContent());
                }
                catch (IOException e) {
                    throw new SignalFxMetricsException("Unable to get reponse content", e);
                }
                if (resp.getStatusLine().getStatusCode() != 200) {
                    throw new SignalFxMetricsException("Invalid status code " + resp.getStatusLine().getStatusCode() + ": " + body);
                }
                if (!"\"OK\"".equals(body)) {
                    throw new SignalFxMetricsException("Invalid response body: " + body);
                }
            }
            finally {
                if (resp != null) {
                    resp.close();
                }
            }
        }
        catch (IOException e) {
            throw new SignalFxMetricsException("Exception posting to addDataPoints", e);
        }
    }

    protected abstract String getEndpointForAddDatapoints();

    protected abstract HttpEntity getEntityForVersion(List<SignalFxProtocolBuffers.DataPoint> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backfillDataPoints(String auth, String source, String metric, List<SignalFxProtocolBuffers.Datum> datumPoints) throws SignalFxMetricsException {
        if (datumPoints.isEmpty()) {
            return;
        }
        try {
            CloseableHttpResponse resp = null;
            try {
                resp = this.postToEndpoint(auth, (HttpEntity)new InputStreamEntity((InputStream)new ProtocolBufferStreamingInputStream(datumPoints.iterator()), PROTO_TYPE), "/v1/backfill");
                if (resp.getStatusLine().getStatusCode() != 200) {
                    throw new SignalFxMetricsException("Invalid status coded " + resp.getStatusLine().getStatusCode());
                }
            }
            finally {
                if (resp != null) {
                    resp.close();
                }
            }
        }
        catch (IOException e) {
            throw new SignalFxMetricsException("Exception posting to addDataPoints", e);
        }
    }
}

