/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.endpoint;

import com.signalfx.endpoint.SignalFxReceiverEndpoint;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalFxEndpoint
implements SignalFxReceiverEndpoint {
    public static final String DEFAULT_SCHEME = "https";
    public static final String DEFAULT_HOSTNAME = "ingest.signalfx.com";
    public static final int DEFAULT_PORT = 443;
    private static final Logger log = LoggerFactory.getLogger(SignalFxEndpoint.class);
    private final String scheme;
    private final String hostname;
    private final int port;

    public SignalFxEndpoint(String hostname, int port) {
        this(SignalFxEndpoint.getDefaultScheme(), hostname, port);
    }

    public SignalFxEndpoint(String scheme, String hostname, int port) {
        this.scheme = scheme;
        this.hostname = hostname;
        this.port = port;
    }

    public SignalFxEndpoint() {
        this(SignalFxEndpoint.getDefaultScheme(), SignalFxEndpoint.getDefaultHostname(), SignalFxEndpoint.getDefaultPort());
    }

    private static String getPropertyOrEnv(String propertyName, String envName, String fallback) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)System.getProperty(propertyName, System.getenv(envName)), (CharSequence)fallback);
    }

    private static String getDefaultScheme() {
        return SignalFxEndpoint.getPropertyOrEnv("com.signalfx.api.scheme", "SIGNALFX_API_SCHEME", DEFAULT_SCHEME);
    }

    private static String getDefaultHostname() {
        return SignalFxEndpoint.getPropertyOrEnv("com.signalfx.api.hostname", "SIGNALFX_API_HOSTNAME", DEFAULT_HOSTNAME);
    }

    private static int getDefaultPort() throws NumberFormatException {
        String foundPort = SignalFxEndpoint.getPropertyOrEnv("com.signalfx.api.port", "SIGNALFX_API_PORT", Integer.toString(443));
        try {
            return Integer.parseInt(foundPort);
        }
        catch (NumberFormatException e) {
            log.error("Invalid found port >>{}<<", (Object)foundPort, (Object)e);
            throw e;
        }
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.getScheme() + "://" + this.getHostname() + ':' + this.getPort();
    }
}

