/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.metrics.flush;

import com.signalfx.metrics.SignalFxMetricsException;
import com.signalfx.metrics.auth.AuthToken;
import com.signalfx.metrics.auth.NoAuthTokenException;
import com.signalfx.metrics.connection.DataPointReceiver;
import com.signalfx.metrics.connection.DataPointReceiverFactory;
import com.signalfx.metrics.errorhandler.MetricErrorImpl;
import com.signalfx.metrics.errorhandler.MetricErrorType;
import com.signalfx.metrics.errorhandler.OnSendErrorHandler;
import com.signalfx.metrics.protobuf.SignalFxProtocolBuffers;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AggregateMetricSender {
    private final String defaultSourceName;
    private final Set<String> registeredMetricPairs;
    private final DataPointReceiverFactory dataPointReceiverFactory;
    private final AuthToken authToken;
    private final Collection<OnSendErrorHandler> onSendErrorHandlerCollection;

    public AggregateMetricSender(String defaultSourceName, DataPointReceiverFactory dataPointReceiverFactory, AuthToken authToken, Collection<OnSendErrorHandler> onSendErrorHandlerCollection) {
        this.defaultSourceName = defaultSourceName;
        this.registeredMetricPairs = new HashSet<String>();
        this.dataPointReceiverFactory = dataPointReceiverFactory;
        this.authToken = authToken;
        this.onSendErrorHandlerCollection = onSendErrorHandlerCollection;
    }

    public String getDefaultSourceName() {
        return this.defaultSourceName;
    }

    private void communicateError(String message, MetricErrorType code, SignalFxMetricsException signalfxMetricsException) {
        for (OnSendErrorHandler onSendErrorHandler : this.onSendErrorHandlerCollection) {
            onSendErrorHandler.handleError(new MetricErrorImpl(message, code, signalfxMetricsException));
        }
    }

    public Session createSession() {
        return new SessionImpl();
    }

    public static interface Session
    extends Closeable {
        public Session setCumulativeCounter(String var1, long var2);

        public Session setCumulativeCounter(String var1, String var2, long var3);

        public Session setGauge(String var1, long var2);

        public Session setGauge(String var1, String var2, long var3);

        public Session setGauge(String var1, double var2);

        public Session setGauge(String var1, String var2, double var3);

        public Session incrementCounter(String var1, long var2);

        public Session incrementCounter(String var1, String var2, long var3);

        public Session setDatapoint(String var1, String var2, SignalFxProtocolBuffers.MetricType var3, long var4);

        public Session setDatapoint(String var1, String var2, SignalFxProtocolBuffers.MetricType var3, double var4);

        public Session setDatapoint(SignalFxProtocolBuffers.DataPoint var1);
    }

    private final class SessionImpl
    implements Session {
        private final Map<String, SignalFxProtocolBuffers.MetricType> toBeRegisteredMetricPairs = new HashMap<String, SignalFxProtocolBuffers.MetricType>();
        private final List<SignalFxProtocolBuffers.DataPoint> pointsToFlush = new ArrayList<SignalFxProtocolBuffers.DataPoint>();

        private SessionImpl() {
        }

        @Override
        public Session setCumulativeCounter(String metric, long value) {
            return this.setCumulativeCounter(AggregateMetricSender.this.defaultSourceName, metric, value);
        }

        @Override
        public Session setCumulativeCounter(String source, String metric, long value) {
            this.setDatapoint(source, metric, SignalFxProtocolBuffers.MetricType.CUMULATIVE_COUNTER, value);
            return this;
        }

        @Override
        public Session incrementCounter(String metric, long value) {
            return this.incrementCounter(AggregateMetricSender.this.defaultSourceName, metric, value);
        }

        @Override
        public Session incrementCounter(String source, String metric, long value) {
            this.setDatapoint(source, metric, SignalFxProtocolBuffers.MetricType.COUNTER, value);
            return this;
        }

        @Override
        public Session setDatapoint(String source, String metric, SignalFxProtocolBuffers.MetricType metricType, long value) {
            this.check(metric, metricType);
            this.pointsToFlush.add(SignalFxProtocolBuffers.DataPoint.newBuilder().setSource(source).setMetricType(metricType).setMetric(metric).setValue(SignalFxProtocolBuffers.Datum.newBuilder().setIntValue(value).build()).build());
            return this;
        }

        @Override
        public Session setDatapoint(String source, String metric, SignalFxProtocolBuffers.MetricType metricType, double value) {
            this.check(metric, metricType);
            this.pointsToFlush.add(SignalFxProtocolBuffers.DataPoint.newBuilder().setSource(source).setMetricType(metricType).setMetric(metric).setValue(SignalFxProtocolBuffers.Datum.newBuilder().setDoubleValue(value).build()).build());
            return this;
        }

        @Override
        public Session setDatapoint(SignalFxProtocolBuffers.DataPoint datapoint) {
            this.check(datapoint.getMetric(), datapoint.getMetricType());
            this.pointsToFlush.add(datapoint);
            return this;
        }

        @Override
        public Session setGauge(String metric, long value) {
            return this.setGauge(AggregateMetricSender.this.defaultSourceName, metric, value);
        }

        @Override
        public Session setGauge(String source, String metric, long value) {
            this.setDatapoint(source, metric, SignalFxProtocolBuffers.MetricType.GAUGE, value);
            return this;
        }

        @Override
        public Session setGauge(String metric, double value) {
            return this.setGauge(AggregateMetricSender.this.defaultSourceName, metric, value);
        }

        @Override
        public Session setGauge(String source, String metric, double value) {
            this.setDatapoint(source, metric, SignalFxProtocolBuffers.MetricType.GAUGE, value);
            return this;
        }

        private void check(String metricPair, SignalFxProtocolBuffers.MetricType metricType) {
            if (!AggregateMetricSender.this.registeredMetricPairs.contains(metricPair)) {
                this.toBeRegisteredMetricPairs.put(metricPair, metricType);
            }
        }

        @Override
        public void close() {
            String authTokenStr;
            try {
                authTokenStr = AggregateMetricSender.this.authToken.getAuthToken();
            }
            catch (NoAuthTokenException e) {
                AggregateMetricSender.this.communicateError("Unable to get auth token", MetricErrorType.AUTH_TOKEN_ERROR, e);
                return;
            }
            DataPointReceiver dataPointReceiver = AggregateMetricSender.this.dataPointReceiverFactory.createDataPointReceiver();
            if (!this.toBeRegisteredMetricPairs.isEmpty()) {
                try {
                    Map<String, Boolean> registeredPairs = dataPointReceiver.registerMetrics(authTokenStr, this.toBeRegisteredMetricPairs);
                    for (Map.Entry<String, Boolean> i : registeredPairs.entrySet()) {
                        if (!i.getValue().booleanValue()) continue;
                        AggregateMetricSender.this.registeredMetricPairs.add(i.getKey());
                    }
                }
                catch (SignalFxMetricsException e) {
                    AggregateMetricSender.this.communicateError("Unable to register metrics", MetricErrorType.REGISTRATION_ERROR, e);
                    return;
                }
            }
            Iterator<SignalFxProtocolBuffers.DataPoint> i = this.pointsToFlush.iterator();
            while (i.hasNext()) {
                SignalFxProtocolBuffers.DataPoint currentEntry = i.next();
                if (AggregateMetricSender.this.registeredMetricPairs.contains(currentEntry.getMetric())) continue;
                i.remove();
            }
            if (!this.pointsToFlush.isEmpty()) {
                try {
                    dataPointReceiver.addDataPoints(authTokenStr, this.pointsToFlush);
                }
                catch (SignalFxMetricsException e) {
                    AggregateMetricSender.this.communicateError("Unable to send datapoints", MetricErrorType.DATAPOINT_SEND_ERROR, e);
                    return;
                }
            }
        }
    }
}

