/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.google.common.collect;

import com.signalfx.shaded.checkerframework.checker.nullness.qual.Nullable;
import com.signalfx.shaded.google.common.annotations.Beta;
import com.signalfx.shaded.google.common.annotations.GwtIncompatible;
import com.signalfx.shaded.google.common.collect.ElementTypesAreNonnullByDefault;
import com.signalfx.shaded.google.common.collect.Range;
import com.signalfx.shaded.google.errorprone.annotations.DoNotMock;
import com.signalfx.shaded.javax.annotation.CheckForNull;
import java.util.Map;
import java.util.function.BiFunction;

@DoNotMock(value="Use ImmutableRangeMap or TreeRangeMap")
@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public interface RangeMap<K extends Comparable, V> {
    @CheckForNull
    public V get(K var1);

    @CheckForNull
    public Map.Entry<Range<K>, V> getEntry(K var1);

    public Range<K> span();

    public void put(Range<K> var1, V var2);

    public void putCoalescing(Range<K> var1, V var2);

    public void putAll(RangeMap<K, V> var1);

    public void clear();

    public void remove(Range<K> var1);

    public void merge(Range<K> var1, @CheckForNull V var2, BiFunction<? super V, ? super @Nullable V, ? extends @Nullable V> var3);

    public Map<Range<K>, V> asMapOfRanges();

    public Map<Range<K>, V> asDescendingMapOfRanges();

    public RangeMap<K, V> subRangeMap(Range<K> var1);

    public boolean equals(@CheckForNull Object var1);

    public int hashCode();

    public String toString();
}

