/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.google.common.cache;

import com.signalfx.shaded.google.common.annotations.GwtIncompatible;
import com.signalfx.shaded.google.common.base.Preconditions;
import com.signalfx.shaded.google.common.cache.ElementTypesAreNonnullByDefault;
import com.signalfx.shaded.google.common.cache.RemovalListener;
import com.signalfx.shaded.google.common.cache.RemovalNotification;
import java.util.concurrent.Executor;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class RemovalListeners {
    private RemovalListeners() {
    }

    public static <K, V> RemovalListener<K, V> asynchronous(final RemovalListener<K, V> listener, final Executor executor) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        return new RemovalListener<K, V>(){

            @Override
            public void onRemoval(final RemovalNotification<K, V> notification) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onRemoval(notification);
                    }
                });
            }
        };
    }
}

