/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.ui.event;

import javax.rad.ui.IComponent;

public abstract class UIEvent {
    public static final int SHIFT_MASK = 1;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int ALT_MASK = 8;
    public static final int ALT_GRAPH_MASK = 32;
    public static final int BUTTON1_MASK = 16;
    public static final int BUTTON2_MASK = 8;
    public static final int BUTTON3_MASK = 4;
    private IComponent source;
    private int id;
    private long when;
    private int modifiers;

    protected UIEvent(IComponent iComponent, int n, long l, int n2) {
        this.checkId(n);
        this.source = iComponent;
        this.id = n;
        this.when = l;
        this.modifiers = n2;
    }

    protected void checkId(int n) {
        throw new IllegalArgumentException("The given id is not allowed for a " + this.getClass().getName());
    }

    public IComponent getSource() {
        return this.source;
    }

    public int getId() {
        return this.id;
    }

    public long getWhen() {
        return this.when;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isModifier(int n) {
        return (this.modifiers & n) == n;
    }
}

