/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model.reference;

import java.io.Serializable;
import java.util.Arrays;

public class ColumnMapping
implements Cloneable,
Serializable {
    private String[] columnNames;
    private String[] referencedColumnNames;

    public ColumnMapping() {
        this(null);
    }

    public ColumnMapping(String[] stringArray) {
        this.setColumnNames(stringArray);
    }

    public ColumnMapping(String[] stringArray, String[] stringArray2) {
        this.setColumnNames(stringArray);
        this.setReferencedColumnNames(stringArray2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ColumnMapping columnMapping = (ColumnMapping)object;
        if (!Arrays.equals(this.columnNames, columnMapping.columnNames)) {
            return false;
        }
        return Arrays.equals(this.referencedColumnNames, columnMapping.referencedColumnNames);
    }

    public int hashCode() {
        int n = 7 + Arrays.hashCode(this.columnNames);
        n = 7 * n + Arrays.hashCode(this.referencedColumnNames);
        return n;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray == null ? new String[0] : stringArray;
        this.setReferencedColumnNames(this.referencedColumnNames);
    }

    public String[] getReferencedColumnNames() {
        return this.referencedColumnNames;
    }

    public String getReferencedColumnName(String string) {
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (string != this.columnNames[i] && !string.equals(this.columnNames[i])) continue;
            return this.referencedColumnNames[i];
        }
        return string;
    }

    public String getColumnName(String string) {
        for (int i = 0; i < this.referencedColumnNames.length; ++i) {
            if (string != this.referencedColumnNames[i] && !string.equals(this.referencedColumnNames[i])) continue;
            return this.columnNames[i];
        }
        return string;
    }

    public void setReferencedColumnNames(String[] stringArray) {
        if (stringArray == null) {
            this.referencedColumnNames = this.columnNames;
        } else if (stringArray.length < this.columnNames.length) {
            this.referencedColumnNames = new String[this.columnNames.length];
            System.arraycopy(stringArray, 0, this.referencedColumnNames, 0, stringArray.length);
            System.arraycopy(this.columnNames, stringArray.length, this.referencedColumnNames, stringArray.length, this.columnNames.length - stringArray.length);
        } else {
            this.referencedColumnNames = stringArray;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("columnMapping={");
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.columnNames[i]);
            stringBuilder.append("->");
            stringBuilder.append(this.referencedColumnNames[i]);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public ColumnMapping clone() {
        try {
            ColumnMapping columnMapping = (ColumnMapping)super.clone();
            if (this.columnNames != null) {
                columnMapping.columnNames = (String[])this.columnNames.clone();
            }
            if (this.referencedColumnNames != null) {
                columnMapping.referencedColumnNames = (String[])this.referencedColumnNames.clone();
            }
            return columnMapping;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

