/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.model;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.IntHashMap;
import com.sibvisions.util.type.StringUtil;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.ColumnView;
import javax.rad.model.IDataBook;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.BinaryDataType;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.IControl;
import javax.rad.model.ui.IEditorControl;
import javax.rad.ui.celleditor.ILinkedCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowDefinition
implements IRowDefinition,
Serializable {
    private transient ArrayUtil<IDataBook> auDataBooks;
    private transient ArrayUtil<Class<? extends IControl>> auColumnViewClasses;
    private transient HashMap<Class<? extends IControl>, ColumnView> hmColumnViews;
    private transient ColumnView defaultColumnView;
    private ArrayUtil<ColumnDefinition> auColumnDefinitions = new ArrayUtil();
    private Map<String, Integer> hmColumnDefinitionsMap = new HashMap<String, Integer>();
    private IntHashMap<int[]> hmColumnArrayDefinitionsMap = new IntHashMap();
    private IntHashMap<RowDefinition> hmRowDefinitionsMap = new IntHashMap();
    private String[] saColumnNames = new String[0];
    private String[] saPKColumnNames;
    private static String[] saDefaultIgnoredColumnNames = new String[]{"id", "*_id", "*_intern", "ID", "*_ID", "*_INTERN"};
    private transient ArrayUtil<WeakReference<IControl>> auControls;

    @Override
    public void addDataBook(IDataBook iDataBook) throws ModelException {
        if (iDataBook != null) {
            if (this.auDataBooks == null) {
                this.auDataBooks = new ArrayUtil();
                this.auDataBooks.add(iDataBook);
            } else if (this.auDataBooks.indexOfReference(iDataBook) < 0) {
                this.auDataBooks.add(iDataBook);
            }
        }
    }

    @Override
    public void removeDataBook(IDataBook iDataBook) {
        int n = this.auDataBooks.indexOfReference(iDataBook);
        if (n >= 0) {
            this.auDataBooks.remove(n);
        }
    }

    @Override
    public IDataBook[] getDataBooks() {
        if (this.auDataBooks == null) {
            return new IDataBook[0];
        }
        return this.auDataBooks.toArray(new IDataBook[this.auDataBooks.size()]);
    }

    @Override
    public IRowDefinition createRowDefinition(String[] stringArray) throws ModelException {
        if (stringArray == null) {
            return this;
        }
        int n = RowDefinition.getStringArrayHashCode(stringArray);
        RowDefinition rowDefinition = this.hmRowDefinitionsMap.get(n);
        if (rowDefinition == null || RowDefinition.getStringArrayHashCode(rowDefinition.saColumnNames) != n) {
            rowDefinition = new RowDefinition();
            int[] nArray = this.getColumnDefinitionIndexes(stringArray);
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                if (n2 < 0) {
                    throw new ModelException("Column '" + stringArray[i] + "' doesn't exists in RowDefinition! - Check that the DataBook is open or the column is added before.");
                }
                ColumnDefinition columnDefinition = this.getColumnDefinition(n2).clone();
                columnDefinition.setNullable(true);
                rowDefinition.addColumnDefinition(columnDefinition);
            }
            this.hmRowDefinitionsMap.put(n, rowDefinition);
        }
        return rowDefinition;
    }

    @Override
    public void addColumnDefinition(ColumnDefinition columnDefinition) throws ModelException {
        if (columnDefinition != null) {
            if (columnDefinition.getRowDefinition() != null) {
                throw new ModelException("Column '" + columnDefinition.getName() + "' already added to another RowDefinition! - " + columnDefinition.getRowDefinition().toString());
            }
            if (ArrayUtil.contains(this.saColumnNames, columnDefinition.getName())) {
                throw new ModelException("Column '" + columnDefinition.getName() + "' already exists in RowDefinition!");
            }
            if (this.auDataBooks != null && this.auDataBooks.size() > 0) {
                throw new ModelException("RowDefinition is already in use (IDataBook is open)! -> Changes not possible! - " + this.auDataBooks.get(0).toString());
            }
            this.auColumnDefinitions.add(columnDefinition);
            this.saColumnNames = ArrayUtil.add(this.saColumnNames, columnDefinition.getName());
            this.hmColumnDefinitionsMap.put(columnDefinition.getName(), this.auColumnDefinitions.size() - 1);
            columnDefinition.setRowDefinition(this);
        }
    }

    @Override
    public ColumnDefinition getColumnDefinition(String string) throws ModelException {
        int n = this.getColumnDefinitionIndex(string);
        if (n < 0) {
            throw new ModelException("Column '" + string + "' doesn't exists in RowDefinition! - Check that the DataBook is open or the column is added before.");
        }
        ColumnDefinition columnDefinition = this.auColumnDefinitions.get(n);
        return columnDefinition;
    }

    @Override
    public ColumnDefinition getColumnDefinition(int n) {
        return this.auColumnDefinitions.get(n);
    }

    @Override
    public int getColumnDefinitionIndex(String string) {
        Integer n = this.hmColumnDefinitionsMap.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    @Override
    public int[] getColumnDefinitionIndexes(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = RowDefinition.getStringArrayHashCode(stringArray);
        int[] nArray = this.hmColumnArrayDefinitionsMap.get(n);
        if (nArray == null) {
            nArray = new int[stringArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                Integer n2 = this.hmColumnDefinitionsMap.get(stringArray[i]);
                nArray[i] = n2 == null ? -1 : n2;
            }
            this.hmColumnArrayDefinitionsMap.put(n, nArray);
        }
        return nArray;
    }

    @Override
    public int getColumnCount() {
        return this.saColumnNames.length;
    }

    @Override
    public String[] getColumnNames() {
        return this.saColumnNames;
    }

    @Override
    public String[] getPrimaryKeyColumnNames() {
        if (this.saPKColumnNames == null) {
            return null;
        }
        return this.saPKColumnNames;
    }

    @Override
    public void setPrimaryKeyColumnNames(String[] stringArray) throws ModelException {
        if (this.auDataBooks != null && this.auDataBooks.size() > 0) {
            throw new ModelException("RowDefinition is already in use (IDataBook is open)! -> Changes not possible! - " + this.auDataBooks.get(0).toString());
        }
        this.saPKColumnNames = stringArray == null ? null : (String[])stringArray.clone();
    }

    @Override
    public Class<? extends IControl>[] getColumnViewClasses() {
        if (this.auColumnViewClasses == null) {
            return new Class[0];
        }
        return this.auColumnViewClasses.toArray(new Class[this.auColumnViewClasses.size()]);
    }

    @Override
    public ColumnView getColumnView(Class<? extends IControl> clazz) {
        if (clazz != null && this.auColumnViewClasses != null) {
            int n = this.auColumnViewClasses.size();
            for (int i = 0; i < n; ++i) {
                Class<? extends IControl> clazz2 = this.auColumnViewClasses.get(i);
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return this.hmColumnViews.get(clazz2);
            }
        }
        if (this.defaultColumnView == null) {
            this.defaultColumnView = this.getDefaultColumnView();
            this.defaultColumnView.addRowDefinition(this);
        }
        return this.defaultColumnView;
    }

    @Override
    public void setColumnView(Class<? extends IControl> clazz, ColumnView columnView) throws ModelException {
        ColumnView columnView2;
        if (columnView == null) {
            if (clazz == null) {
                this.defaultColumnView.removeRowDefinition(this);
                this.defaultColumnView = null;
            } else if (this.hmColumnViews != null && (columnView2 = this.hmColumnViews.remove(clazz)) != null) {
                columnView2.removeRowDefinition(this);
                this.auColumnViewClasses.remove(clazz);
                if (this.hmColumnViews.size() == 0) {
                    this.hmColumnViews = null;
                    this.auColumnViewClasses = null;
                }
            }
        } else {
            this.checkColumnNames(columnView.getColumnNames());
            if (clazz == null) {
                if (this.defaultColumnView != null) {
                    this.defaultColumnView.removeRowDefinition(this);
                }
                this.defaultColumnView = columnView;
                this.defaultColumnView.addRowDefinition(this);
            } else {
                if (this.hmColumnViews == null) {
                    this.hmColumnViews = new HashMap();
                    this.auColumnViewClasses = new ArrayUtil();
                }
                if ((columnView2 = this.hmColumnViews.put(clazz, columnView)) == null) {
                    int n;
                    int n2 = this.auColumnViewClasses.size();
                    for (n = 0; n < n2 && !this.auColumnViewClasses.get(n).isAssignableFrom(clazz); ++n) {
                    }
                    this.auColumnViewClasses.add(n, clazz);
                } else {
                    columnView2.removeRowDefinition(this);
                }
                columnView.addRowDefinition(this);
            }
        }
        if (this.auDataBooks != null) {
            for (int i = 0; i < this.auDataBooks.size(); ++i) {
                IControl[] iControlArray;
                IDataBook iDataBook = this.auDataBooks.get(i);
                for (IControl iControl : iControlArray = iDataBook.getControls()) {
                    if (iControl instanceof IEditorControl) continue;
                    iControl.notifyRepaint();
                }
            }
        }
    }

    @Override
    public void setReadOnly(String[] stringArray) throws ModelException {
        if (stringArray == null || stringArray.length == 0) {
            stringArray = this.getColumnNames();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.getColumnDefinition(stringArray[i]).setReadOnly(true);
        }
    }

    @Override
    public String[] getReadOnly() {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        for (int i = 0; i < this.auColumnDefinitions.size(); ++i) {
            if (!this.auColumnDefinitions.get(i).isReadOnly()) continue;
            arrayUtil.add(this.auColumnDefinitions.get(i).getName());
        }
        return arrayUtil.toArray(new String[arrayUtil.size()]);
    }

    @Override
    public void addControl(IControl iControl) {
        if (this.auControls == null) {
            this.auControls = new ArrayUtil();
        } else {
            for (int i = this.auControls.size() - 1; i >= 0; --i) {
                if (this.auControls.get(i).get() != null) continue;
                this.auControls.remove(i);
            }
        }
        if (this.auControls.indexOf(iControl) < 0) {
            this.auControls.add(new WeakReference<IControl>(iControl));
        }
    }

    @Override
    public void removeControl(IControl iControl) {
        if (this.auControls != null) {
            for (int i = this.auControls.size() - 1; i >= 0; --i) {
                IControl iControl2 = (IControl)this.auControls.get(i).get();
                if (iControl2 != null && iControl2 != iControl) continue;
                this.auControls.remove(i);
            }
        }
    }

    @Override
    public IControl[] getControls() {
        ArrayUtil<IControl> arrayUtil = new ArrayUtil<IControl>();
        if (this.auControls != null) {
            for (int i = this.auControls.size() - 1; i >= 0; --i) {
                IControl iControl = (IControl)this.auControls.get(i).get();
                if (iControl == null) {
                    this.auControls.remove(i);
                    continue;
                }
                arrayUtil.add(0, iControl);
            }
        }
        return arrayUtil.toArray(new IControl[arrayUtil.size()]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int n = this.auColumnDefinitions.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            ColumnDefinition columnDefinition = this.auColumnDefinitions.get(i);
            stringBuilder.append(columnDefinition.getName());
            boolean bl = false;
            if (ArrayUtil.indexOf(this.saPKColumnNames, columnDefinition.getName()) >= 0) {
                stringBuilder.append(" (");
                stringBuilder.append("PK");
                bl = true;
            }
            if (columnDefinition.isWritable()) {
                if (bl) {
                    stringBuilder.append(", ");
                } else {
                    stringBuilder.append(" (");
                    bl = true;
                }
                stringBuilder.append("writable");
            }
            if (!bl) continue;
            stringBuilder.append(")");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private void checkColumnNames(String[] stringArray) throws ModelException {
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            this.getColumnDefinition(stringArray[i]);
        }
    }

    public ColumnView getDefaultColumnView() {
        if (this.getColumnCount() == 0) {
            throw new IllegalStateException("It is not allowed to call getDefaultColumnView, if the RowDefinition has no columns!");
        }
        ColumnView columnView = new ColumnView(new String[0]);
        for (int i = 0; i < this.saColumnNames.length; ++i) {
            String string = this.saColumnNames[i];
            if (this.auColumnDefinitions.get(i).getDataType() instanceof BinaryDataType || RowDefinition.isColumnIgnored(string) || this.isMasterLinkColumn(string)) continue;
            columnView.addColumnNames(string);
        }
        return columnView;
    }

    public String[] getLinkReferenceColumnNames(String string) {
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        int n = this.auColumnDefinitions.size();
        for (int i = 0; i < n; ++i) {
            ReferenceDefinition referenceDefinition;
            ICellEditor iCellEditor = this.auColumnDefinitions.get(i).getDataType().getCellEditor();
            if (!(iCellEditor instanceof ILinkedCellEditor) || ArrayUtil.indexOf((referenceDefinition = ((ILinkedCellEditor)iCellEditor).getLinkReference()).getColumnNames(), string) < 0) continue;
            arrayUtil.add(this.saColumnNames[i]);
        }
        if (arrayUtil.size() == 0) {
            return null;
        }
        return arrayUtil.toArray(new String[arrayUtil.size()]);
    }

    public ReferenceDefinition getLinkReference(String string) {
        ReferenceDefinition referenceDefinition = null;
        int n = this.auColumnDefinitions.size();
        for (int i = 0; i < n; ++i) {
            ReferenceDefinition referenceDefinition2;
            ICellEditor iCellEditor = this.auColumnDefinitions.get(i).getDataType().getCellEditor();
            if (!(iCellEditor instanceof ILinkedCellEditor) || ArrayUtil.indexOf((referenceDefinition2 = ((ILinkedCellEditor)iCellEditor).getLinkReference()).getColumnNames(), string) < 0 || referenceDefinition != null && referenceDefinition2.getColumnNames().length >= referenceDefinition.getColumnNames().length) continue;
            referenceDefinition = referenceDefinition2;
        }
        return referenceDefinition;
    }

    public ReferenceDefinition getMasterReference() {
        if (this.auDataBooks != null) {
            int n = this.auDataBooks.size();
            for (int i = 0; i < n; ++i) {
                IDataBook iDataBook = this.auDataBooks.get(i);
                if (iDataBook.getMasterReference() == null) continue;
                return iDataBook.getMasterReference();
            }
        }
        return null;
    }

    public boolean isMasterLinkColumn(String string) {
        ReferenceDefinition referenceDefinition = this.getMasterReference();
        ReferenceDefinition referenceDefinition2 = this.getLinkReference(string);
        return referenceDefinition != null && (ArrayUtil.indexOf(referenceDefinition.getColumnNames(), string) >= 0 || referenceDefinition2 != null && ArrayUtil.containsAll(referenceDefinition2.getColumnNames(), referenceDefinition.getColumnNames()));
    }

    public static void setDefaultIgnoredColumnNames(String ... stringArray) {
        saDefaultIgnoredColumnNames = stringArray;
    }

    public static String[] getDefaultIgnoredColumnNames() {
        return saDefaultIgnoredColumnNames;
    }

    public static boolean isColumnIgnored(String string) {
        if (saDefaultIgnoredColumnNames == null) {
            return false;
        }
        for (int i = 0; i < saDefaultIgnoredColumnNames.length; ++i) {
            if (!StringUtil.like(string, saDefaultIgnoredColumnNames[i])) continue;
            return true;
        }
        return false;
    }

    private static final int getStringArrayHashCode(String[] stringArray) {
        int n = stringArray.length * 29;
        for (int i = 0; i < stringArray.length; ++i) {
            n = n * 13 + stringArray[i].hashCode();
        }
        return n;
    }
}

