/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.genui;

import com.sibvisions.util.type.StringUtil;
import java.util.Hashtable;
import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.UIFactoryResource;
import javax.rad.ui.IColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIColor
extends UIFactoryResource<IColor>
implements IColor {
    public static final UIColor white = new UIColor(255, 255, 255);
    public static final UIColor lightGray = new UIColor(192, 192, 192);
    public static final UIColor gray = new UIColor(128, 128, 128);
    public static final UIColor darkGray = new UIColor(64, 64, 64);
    public static final UIColor black = new UIColor(0, 0, 0);
    public static final UIColor red = new UIColor(255, 0, 0);
    public static final UIColor pink = new UIColor(255, 175, 175);
    public static final UIColor orange = new UIColor(255, 200, 0);
    public static final UIColor yellow = new UIColor(255, 255, 0);
    public static final UIColor green = new UIColor(0, 255, 0);
    public static final UIColor magenta = new UIColor(255, 0, 255);
    public static final UIColor cyan = new UIColor(0, 255, 255);
    public static final UIColor blue = new UIColor(0, 0, 255);
    public static final UIColor controlBackground = UIColor.getSystemColor("IControl.background");
    public static final UIColor controlAlternateBackground = UIColor.getSystemColor("IControl.alternateBackground");
    public static final UIColor controlForeground = UIColor.getSystemColor("IControl.background");
    public static final UIColor controlActiveSelectionBackground = UIColor.getSystemColor("IControl.activeSelectionBackground");
    public static final UIColor controlActiveSelectionForeground = UIColor.getSystemColor("IControl.activeSelectionForeground");
    public static final UIColor controlInactiveSelectionBackground = UIColor.getSystemColor("IControl.inactiveSelectionBackground");
    public static final UIColor controlInactiveSelectionForeground = UIColor.getSystemColor("IControl.inactiveSelectionForeground");
    public static final UIColor controlMandatoryBackground = UIColor.getSystemColor("IControl.mandatoryBackground");
    public static final UIColor controlReadOnlyBackground = UIColor.getSystemColor("IControl.readOnlyBackground");
    public static final UIColor invalidEditorBackground = UIColor.getSystemColor("IControl.invalidEditorBackground");
    private static Hashtable<String, UIColor> systemColors;

    protected UIColor(IColor iColor) {
        super(iColor);
    }

    public UIColor(int n) {
        super(UIFactoryManager.getFactory().createColor(0xFF000000 | n));
    }

    public UIColor(int n, boolean bl) {
        super(UIFactoryManager.getFactory().createColor(bl ? n : 0xFF000000 | n));
    }

    public UIColor(int n, int n2, int n3) {
        super(UIFactoryManager.getFactory().createColor(0xFF000000 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF));
    }

    public UIColor(int n, int n2, int n3, int n4) {
        super(UIFactoryManager.getFactory().createColor((n4 & 0xFF) << 24 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | n3 & 0xFF));
    }

    @Override
    public int getRed() {
        return ((IColor)this.getUIResource()).getRed();
    }

    @Override
    public int getGreen() {
        return ((IColor)this.getUIResource()).getGreen();
    }

    @Override
    public int getBlue() {
        return ((IColor)this.getUIResource()).getBlue();
    }

    @Override
    public int getAlpha() {
        return ((IColor)this.getUIResource()).getAlpha();
    }

    @Override
    public int getRGBA() {
        return ((IColor)this.getUIResource()).getRGBA();
    }

    public static UIColor getSystemColor(String string) {
        UIColor uIColor;
        if (systemColors == null) {
            systemColors = new Hashtable();
        }
        if ((uIColor = systemColors.get(string)) == null) {
            uIColor = new UIColor(UIFactoryManager.getFactory().getSystemColor(string));
            systemColors.put(string, uIColor);
        }
        return uIColor;
    }

    public static void setSystemColor(String string, IColor iColor) {
        if (iColor instanceof UIColor) {
            UIFactoryManager.getFactory().setSystemColor(string, (IColor)((UIColor)iColor).getUIResource());
        } else {
            UIFactoryManager.getFactory().setSystemColor(string, iColor);
        }
    }

    public static UIColor createColor(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("#")) {
            if (string.length() == 7) {
                return new UIColor(Integer.valueOf(string.substring(1, 3), 16), Integer.valueOf(string.substring(3, 5), 16), Integer.valueOf(string.substring(5, 7), 16));
            }
            return null;
        }
        if (string.startsWith("0x") || string.startsWith("0X")) {
            if (string.length() == 8) {
                return new UIColor(Integer.valueOf(string.substring(2, 4), 16), Integer.valueOf(string.substring(4, 6), 16), Integer.valueOf(string.substring(6, 8), 16));
            }
            return null;
        }
        int[] nArray = StringUtil.parseInteger(string, ",");
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 3) {
            return new UIColor(nArray[0], nArray[1], nArray[2]);
        }
        if (nArray.length == 4) {
            return new UIColor(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        return null;
    }

    public static String toHex(IColor iColor) {
        return "#" + Integer.toString(0x1000000 | iColor.getRGBA() & 0xFFFFFF, 16).substring(1).toUpperCase();
    }

    public String toHex() {
        return UIColor.toHex(this);
    }
}

