/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.security;

import java.security.MessageDigest;
import java.util.Arrays;

public class MD4MessageDigest
extends MessageDigest {
    private int[] contextState = new int[4];
    private long contextCount = 0L;
    private byte[] contextBuffer = new byte[64];
    static byte[] padding = new byte[64];
    private int[] x = new int[16];

    public MD4MessageDigest() {
        super("MD4");
        this.engineReset();
    }

    protected void engineUpdate(byte by) {
        int n = (int)(this.contextCount % 64L);
        ++this.contextCount;
        this.contextBuffer[n] = by;
        if (n == 63) {
            this.transform(this.contextBuffer, 0);
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = (int)this.contextCount % 64;
        this.contextCount += (long)n2;
        int n4 = 64 - n3;
        int n5 = 0;
        if (n2 >= n4) {
            System.arraycopy(byArray, n, this.contextBuffer, n3, n4);
            this.transform(this.contextBuffer, 0);
            n5 = n4;
            while (n5 + 63 < n2) {
                this.transform(byArray, n + n5);
                n5 += 64;
            }
            n3 = 0;
        }
        if (n5 < n2) {
            System.arraycopy(byArray, n + n5, this.contextBuffer, n3, n2 - n5);
        }
    }

    protected byte[] engineDigest() {
        int n;
        byte[] byArray = new byte[8];
        for (n = 0; n < 8; ++n) {
            byArray[n] = (byte)(this.contextCount * 8L >>> 8 * n);
        }
        n = (int)this.contextCount % 64;
        int n2 = n < 56 ? 56 - n : 120 - n;
        this.engineUpdate(padding, 0, n2);
        this.engineUpdate(byArray, 0, 8);
        byte[] byArray2 = this.encode(this.contextState, 0, 4);
        this.engineReset();
        return byArray2;
    }

    protected void engineReset() {
        this.contextState[0] = 1732584193;
        this.contextState[1] = -271733879;
        this.contextState[2] = -1732584194;
        this.contextState[3] = 271733878;
        this.contextCount = 0L;
        Arrays.fill(this.contextBuffer, (byte)0);
        Arrays.fill(padding, (byte)0);
        MD4MessageDigest.padding[0] = -128;
        Arrays.fill(this.x, 0);
    }

    private void transform(byte[] byArray, int n) {
        int n2 = this.contextState[0];
        int n3 = this.contextState[1];
        int n4 = this.contextState[2];
        int n5 = this.contextState[3];
        this.x = this.decode(byArray, n, 64);
        n2 = this.ff(n2, n3, n4, n5, this.x[0], 3);
        n5 = this.ff(n5, n2, n3, n4, this.x[1], 7);
        n4 = this.ff(n4, n5, n2, n3, this.x[2], 11);
        n3 = this.ff(n3, n4, n5, n2, this.x[3], 19);
        n2 = this.ff(n2, n3, n4, n5, this.x[4], 3);
        n5 = this.ff(n5, n2, n3, n4, this.x[5], 7);
        n4 = this.ff(n4, n5, n2, n3, this.x[6], 11);
        n3 = this.ff(n3, n4, n5, n2, this.x[7], 19);
        n2 = this.ff(n2, n3, n4, n5, this.x[8], 3);
        n5 = this.ff(n5, n2, n3, n4, this.x[9], 7);
        n4 = this.ff(n4, n5, n2, n3, this.x[10], 11);
        n3 = this.ff(n3, n4, n5, n2, this.x[11], 19);
        n2 = this.ff(n2, n3, n4, n5, this.x[12], 3);
        n5 = this.ff(n5, n2, n3, n4, this.x[13], 7);
        n4 = this.ff(n4, n5, n2, n3, this.x[14], 11);
        n3 = this.ff(n3, n4, n5, n2, this.x[15], 19);
        n2 = this.gg(n2, n3, n4, n5, this.x[0], 3);
        n5 = this.gg(n5, n2, n3, n4, this.x[4], 5);
        n4 = this.gg(n4, n5, n2, n3, this.x[8], 9);
        n3 = this.gg(n3, n4, n5, n2, this.x[12], 13);
        n2 = this.gg(n2, n3, n4, n5, this.x[1], 3);
        n5 = this.gg(n5, n2, n3, n4, this.x[5], 5);
        n4 = this.gg(n4, n5, n2, n3, this.x[9], 9);
        n3 = this.gg(n3, n4, n5, n2, this.x[13], 13);
        n2 = this.gg(n2, n3, n4, n5, this.x[2], 3);
        n5 = this.gg(n5, n2, n3, n4, this.x[6], 5);
        n4 = this.gg(n4, n5, n2, n3, this.x[10], 9);
        n3 = this.gg(n3, n4, n5, n2, this.x[14], 13);
        n2 = this.gg(n2, n3, n4, n5, this.x[3], 3);
        n5 = this.gg(n5, n2, n3, n4, this.x[7], 5);
        n4 = this.gg(n4, n5, n2, n3, this.x[11], 9);
        n3 = this.gg(n3, n4, n5, n2, this.x[15], 13);
        n2 = this.hh(n2, n3, n4, n5, this.x[0], 3);
        n5 = this.hh(n5, n2, n3, n4, this.x[8], 9);
        n4 = this.hh(n4, n5, n2, n3, this.x[4], 11);
        n3 = this.hh(n3, n4, n5, n2, this.x[12], 15);
        n2 = this.hh(n2, n3, n4, n5, this.x[2], 3);
        n5 = this.hh(n5, n2, n3, n4, this.x[10], 9);
        n4 = this.hh(n4, n5, n2, n3, this.x[6], 11);
        n3 = this.hh(n3, n4, n5, n2, this.x[14], 15);
        n2 = this.hh(n2, n3, n4, n5, this.x[1], 3);
        n5 = this.hh(n5, n2, n3, n4, this.x[9], 9);
        n4 = this.hh(n4, n5, n2, n3, this.x[5], 11);
        n3 = this.hh(n3, n4, n5, n2, this.x[13], 15);
        n2 = this.hh(n2, n3, n4, n5, this.x[3], 3);
        n5 = this.hh(n5, n2, n3, n4, this.x[11], 9);
        n4 = this.hh(n4, n5, n2, n3, this.x[7], 11);
        n3 = this.hh(n3, n4, n5, n2, this.x[15], 15);
        this.contextState[0] = this.contextState[0] + n2;
        this.contextState[1] = this.contextState[1] + n3;
        this.contextState[2] = this.contextState[2] + n4;
        this.contextState[3] = this.contextState[3] + n5;
        Arrays.fill(this.x, 0);
    }

    private byte[] encode(int[] nArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > nArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        for (int i = 0; i < n2 * 4; i += 4) {
            byArray[i] = (byte)(nArray[n3] & 0xFF);
            byArray[i + 1] = (byte)(nArray[n3] >> 8 & 0xFF);
            byArray[i + 2] = (byte)(nArray[n3] >> 16 & 0xFF);
            byArray[i + 3] = (byte)(nArray[n3] >> 24 & 0xFF);
            ++n3;
        }
        return byArray;
    }

    private int[] decode(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 % 4 != 0) {
            throw new IllegalArgumentException("The value of the parameter pLength must be a multiple of 4.");
        }
        int[] nArray = new int[n2 / 4];
        int n3 = 0;
        for (int i = 0; i < n2; i += 4) {
            nArray[n3] = byArray[n + i] & 0xFF | (byArray[n + i + 1] & 0xFF) << 8 | (byArray[n + i + 2] & 0xFF) << 16 | (byArray[n + i + 3] & 0xFF) << 24;
            ++n3;
        }
        return nArray;
    }

    private int rotateLeft(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private int ff(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + (n2 & n3 | ~n2 & n4) + n5;
        return this.rotateLeft(n7, n6);
    }

    private int gg(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + (n2 & n3 | n2 & n4 | n3 & n4) + n5 + 1518500249;
        return this.rotateLeft(n7, n6);
    }

    private int hh(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n + (n2 ^ n3 ^ n4) + n5 + 1859775393;
        return this.rotateLeft(n7, n6);
    }
}

