/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteCountInputStream
extends FilterInputStream {
    private long lExpectedBytes;
    private volatile long lSkippedBytes;
    private volatile long lReadBytes;

    public ByteCountInputStream(InputStream inputStream) {
        this(inputStream, -1L);
    }

    public ByteCountInputStream(InputStream inputStream, long l) {
        super(inputStream);
        this.lExpectedBytes = l;
    }

    public void close() throws IOException {
        this.readAvailableBytes();
        super.close();
    }

    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            ++this.lReadBytes;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 >= 0) {
            this.lReadBytes += (long)n3;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = super.skip(l);
        this.lSkippedBytes += l2;
        return l2;
    }

    public void readAvailableBytes() throws IOException {
        if (this.lExpectedBytes > 0L && this.lReadBytes + this.lSkippedBytes < this.lExpectedBytes) {
            byte[] byArray = new byte[(int)(this.lExpectedBytes - this.lReadBytes - this.lSkippedBytes)];
            this.read(byArray, 0, byArray.length);
            while (this.lExpectedBytes - this.lReadBytes - this.lSkippedBytes > 0L) {
                this.read();
            }
        }
    }

    public long getReadBytes() {
        return this.lReadBytes;
    }

    public long getSkippedBytes() {
        return this.lSkippedBytes;
    }

    public long getExpectedBytes() {
        return this.lExpectedBytes;
    }
}

