/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Internalize {
    private static final int MIN_SIZE = 63719;
    private static boolean outOfMemoryDetectedOrMaxSizeReached = false;
    private static long nextRehashCheck = -1L;
    private static int size = 0;
    private static WeakReference<?>[] cache = new WeakReference[63719];
    private static int maxSize;
    private static boolean disabled;
    private static long minimalRehashCheckInterval;

    private Internalize() {
    }

    public static final synchronized void clearCache() {
        cache = new WeakReference[63719];
    }

    public static final long getMinimalRehashCheckInterval() {
        return minimalRehashCheckInterval;
    }

    public static final void setMinimalRehashCheckInterval(long l) {
        minimalRehashCheckInterval = l;
    }

    public static final boolean isDisabled() {
        return disabled;
    }

    public static final void setDisabled(boolean bl) {
        if (disabled != bl && (disabled = bl)) {
            Internalize.clearCache();
        }
    }

    public static final int getObjectCount() {
        return size;
    }

    public static final int getMaxObjectCount() {
        return maxSize / 2;
    }

    public static final void setMaxObjectCount(int n) {
        maxSize = n * 2;
    }

    private static final int hashCode(int n, Class clazz) {
        if (clazz == BigDecimal.class || clazz == BigInteger.class) {
            return n & Integer.MAX_VALUE;
        }
        long l = n < 0 ? (long)(-n) : (long)n;
        int n2 = (int)((long)((int)(l >>> 32) * 31) + (l & 0xFFFFFFFFL));
        return 31 * (n < 0 ? -n2 : n2) & Integer.MAX_VALUE;
    }

    public static final synchronized <T> T intern(T t) {
        return Internalize.internNoSync(t);
    }

    public static final <T> T internNoSync(T t) {
        if (disabled || t == null) {
            return t;
        }
        Class<?> clazz = t.getClass();
        int n = Internalize.hashCode(t.hashCode(), clazz) % cache.length;
        int n2 = -1;
        WeakReference<?> weakReference = cache[n];
        T t2 = null;
        while (weakReference != null) {
            Object t3 = weakReference.get();
            t2 = t3;
            if (t.equals(t3)) break;
            if (t2 == null) {
                if (n2 < 0) {
                    n2 = n;
                }
                Internalize.cache[n] = null;
                --size;
            }
            if (++n == cache.length) {
                n = 0;
            }
            weakReference = cache[n];
        }
        if (weakReference == null) {
            if (outOfMemoryDetectedOrMaxSizeReached) {
                if (System.currentTimeMillis() > nextRehashCheck) {
                    Internalize.rehashAndClearUnused();
                }
            } else {
                if (n2 >= 0) {
                    Internalize.cache[n2] = new WeakReference<T>(t, null);
                } else {
                    Internalize.cache[n] = new WeakReference<T>(t, null);
                }
                if (++size > cache.length / 2) {
                    Internalize.rehashAndClearUnused();
                }
            }
            return t;
        }
        if (n2 >= 0) {
            Internalize.cache[n] = null;
            Internalize.cache[n2] = weakReference;
        }
        return t2;
    }

    private static final void rehashAndClearUnused() {
        WeakReference<?> weakReference;
        int n;
        for (n = 0; n < cache.length; ++n) {
            weakReference = cache[n];
            if (weakReference == null || weakReference.get() != null) continue;
            Internalize.cache[n] = null;
            --size;
        }
        n = cache.length;
        if (size > n / 2) {
            n *= 3;
        } else {
            outOfMemoryDetectedOrMaxSizeReached = false;
            while (n > 63719 && size < n / 8) {
                n /= 3;
            }
        }
        if (n > maxSize || outOfMemoryDetectedOrMaxSizeReached) {
            outOfMemoryDetectedOrMaxSizeReached = true;
            nextRehashCheck = System.currentTimeMillis() + minimalRehashCheckInterval;
        } else if (n != cache.length) {
            try {
                WeakReference[] weakReferenceArray = new WeakReference[n];
                for (int i = 0; i < cache.length; ++i) {
                    weakReference = cache[i];
                    if (weakReference == null) continue;
                    Object t = weakReference.get();
                    if (t == null) {
                        --size;
                        continue;
                    }
                    int n2 = Internalize.hashCode(t.hashCode(), t.getClass()) % weakReferenceArray.length;
                    while (weakReferenceArray[n2] != null) {
                        if (++n2 != weakReferenceArray.length) continue;
                        n2 = 0;
                    }
                    weakReferenceArray[n2] = weakReference;
                }
                cache = weakReferenceArray;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                outOfMemoryDetectedOrMaxSizeReached = true;
                nextRehashCheck = System.currentTimeMillis() + minimalRehashCheckInterval;
            }
        }
    }

    static {
        try {
            disabled = Boolean.valueOf(System.getProperty("com.sibvisions.util.Internalize.disabled"));
        }
        catch (Exception exception) {
            disabled = false;
        }
        try {
            maxSize = Integer.valueOf(System.getProperty("com.sibvisions.util.Internalize.maxObjectCount")) * 2;
        }
        catch (Exception exception) {
            maxSize = 5200000;
        }
        try {
            minimalRehashCheckInterval = Long.valueOf(System.getProperty("com.sibvisions.util.Internalize.minimalRehashCheckInterval")).intValue();
        }
        catch (Exception exception) {
            minimalRehashCheckInterval = 5000L;
        }
    }
}

