/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.impl;

import com.sibvisions.util.type.FileUtil;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.rad.application.IFileHandleReceiver;
import javax.rad.application.genui.UILauncher;
import javax.rad.io.DirectoryHandle;
import javax.rad.io.FileHandle;
import javax.rad.io.IFileHandle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class FileChooser {
    private File fiLastSelectedDir = null;
    private File fiLastSavedDir = null;

    public void saveAs(final UILauncher uILauncher, Frame frame, IFileHandle iFileHandle, String string) throws IOException {
        if (Boolean.valueOf(uILauncher.getParameter("FileChooser.native")).booleanValue()) {
            Object object;
            FileDialog fileDialog = new FileDialog(frame);
            fileDialog.setTitle(uILauncher.translate(string == null ? "Save as..." : string));
            fileDialog.setMode(1);
            if (this.fiLastSavedDir == null && fileDialog.getFile() != null) {
                this.fiLastSavedDir = new File(fileDialog.getFile());
            }
            if (this.fiLastSavedDir != null) {
                fileDialog.setDirectory(this.fiLastSavedDir.getParent());
            }
            fileDialog.setFile(iFileHandle.getFileName());
            try {
                object = fileDialog.getClass().getMethod("setIconImage", Image.class);
                ((Method)object).invoke((Object)fileDialog, frame.getIconImage());
            }
            catch (Exception exception) {
                // empty catch block
            }
            fileDialog.setVisible(true);
            object = fileDialog.getFile();
            if (object != null) {
                File file = new File(fileDialog.getDirectory(), (String)object);
                this.fiLastSavedDir = file.getParentFile();
                FileUtil.copy(iFileHandle.getInputStream(), true, new FileOutputStream(file), true);
            }
        } else {
            JFileChooser jFileChooser = new JFileChooser(){

                public void approveSelection() {
                    File file = this.getSelectedFile();
                    if (file.exists() && this.getDialogType() == 1) {
                        int n = JOptionPane.showOptionDialog(this, "<html>" + uILauncher.translate(file.getName() + " already exists.") + "<br>" + uILauncher.translate("Replace the file?") + "</html>", uILauncher.translate("Confirmation"), 0, 2, null, null, null);
                        switch (n) {
                            case 0: {
                                super.approveSelection();
                                return;
                            }
                        }
                        return;
                    }
                    super.approveSelection();
                }
            };
            jFileChooser.setDialogType(1);
            jFileChooser.setDialogTitle(uILauncher.translate(string == null ? "Save as..." : string));
            if (this.fiLastSavedDir == null) {
                this.fiLastSavedDir = jFileChooser.getCurrentDirectory();
            }
            jFileChooser.setSelectedFile(new File(this.fiLastSavedDir, iFileHandle.getFileName()));
            int n = jFileChooser.showSaveDialog(frame);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                this.fiLastSavedDir = file.getParentFile();
                FileUtil.copy(iFileHandle.getInputStream(), true, new FileOutputStream(file), true);
            }
        }
    }

    public IFileHandle[] open(UILauncher uILauncher, Frame frame, String string) throws IOException {
        if (Boolean.valueOf(uILauncher.getParameter("FileChooser.native")).booleanValue()) {
            Object object;
            FileDialog fileDialog = new FileDialog(frame);
            fileDialog.setTitle(uILauncher.translate(string == null ? "Open file" : string));
            fileDialog.setMode(0);
            if (this.fiLastSelectedDir == null && fileDialog.getFile() != null) {
                this.fiLastSelectedDir = new File(fileDialog.getFile());
            }
            if (this.fiLastSelectedDir != null) {
                fileDialog.setDirectory(this.fiLastSelectedDir.getParent());
            }
            try {
                object = fileDialog.getClass().getMethod("setIconImage", Image.class);
                ((Method)object).invoke((Object)fileDialog, frame.getIconImage());
            }
            catch (Exception exception) {
                // empty catch block
            }
            fileDialog.setVisible(true);
            object = fileDialog.getFile();
            if (object != null) {
                File file = new File(fileDialog.getDirectory(), (String)object);
                this.fiLastSelectedDir = file.getParentFile();
                return new FileHandle[]{new FileHandle(file)};
            }
        } else {
            File[] fileArray;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogType(0);
            jFileChooser.setDialogTitle(uILauncher.translate(string == null ? "Open file" : string));
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setCurrentDirectory(this.fiLastSelectedDir);
            int n = jFileChooser.showOpenDialog(frame);
            if (n == 0 && (fileArray = jFileChooser.getSelectedFiles()) != null && fileArray.length > 0) {
                File file = fileArray[fileArray.length - 1];
                this.fiLastSelectedDir = file.isDirectory() ? file : file.getParentFile();
                IFileHandle[] iFileHandleArray = new IFileHandle[fileArray.length];
                for (int i = 0; i < fileArray.length; ++i) {
                    iFileHandleArray[i] = new FileHandle(fileArray[i]);
                }
                return iFileHandleArray;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectDirectory(UILauncher uILauncher, Frame frame, IFileHandleReceiver iFileHandleReceiver, String string) throws IOException {
        block8: {
            File file;
            String string2 = System.getProperty("os.name").toLowerCase();
            if (Boolean.valueOf(uILauncher.getParameter("FileChooser.native")).booleanValue() && string2.indexOf("windows") < 0) {
                try {
                    Object object;
                    System.setProperty("apple.awt.fileDialogForDirectories", "true");
                    FileDialog fileDialog = new FileDialog(frame);
                    fileDialog.setTitle(uILauncher.translate(string == null ? "Select directory" : string));
                    fileDialog.setMode(0);
                    fileDialog.setFilenameFilter(new FilenameFilter(){

                        public boolean accept(File file, String string) {
                            if (string != null) {
                                return new File(file, string).isDirectory();
                            }
                            return file.isDirectory();
                        }
                    });
                    if (this.fiLastSelectedDir == null && fileDialog.getDirectory() != null) {
                        this.fiLastSelectedDir = new File(fileDialog.getDirectory());
                    }
                    try {
                        object = fileDialog.getClass().getMethod("setIconImage", Image.class);
                        ((Method)object).invoke((Object)fileDialog, frame.getIconImage());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    fileDialog.setVisible(true);
                    object = fileDialog.getDirectory();
                    if (object != null) {
                        File file2;
                        this.fiLastSelectedDir = file2 = new File((String)object);
                        iFileHandleReceiver.receiveFileHandle(new DirectoryHandle(file2));
                    }
                    Object var10_13 = null;
                }
                catch (Throwable throwable) {
                    Object var10_14 = null;
                    System.setProperty("apple.awt.fileDialogForDirectories", "false");
                    throw throwable;
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
                {
                    break block8;
                }
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogType(0);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle(uILauncher.translate(string == null ? "Select directory" : string));
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setCurrentDirectory(this.fiLastSelectedDir);
            int n = jFileChooser.showOpenDialog(frame);
            if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                this.fiLastSelectedDir = file;
                iFileHandleReceiver.receiveFileHandle(new DirectoryHandle(file));
            }
        }
    }
}

