/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.text;

import com.sibvisions.util.type.NumberUtil;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.rad.model.datatype.IDataType;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class NumberFormatter
extends JFormattedTextField.AbstractFormatter {
    private NumberUtil numberUtil = new NumberUtil();
    private IDataType dataType;
    private NumberDocumentFilter documentFilter = null;

    public NumberFormatter() {
        this(null);
    }

    public NumberFormatter(NumberFormat numberFormat) {
        this.setNumberFormat(numberFormat);
    }

    protected DocumentFilter getDocumentFilter() {
        if (this.documentFilter == null) {
            this.documentFilter = new NumberDocumentFilter();
        }
        return this.documentFilter;
    }

    public Object stringToValue(String string) throws ParseException {
        Number number = this.numberUtil.parse(string);
        if (this.dataType != null) {
            try {
                this.dataType.convertAndCheckToTypeClass(number);
            }
            catch (Exception exception) {
                throw new ParseException(string, 0);
            }
        }
        return number;
    }

    public String valueToString(Object object) throws ParseException {
        if (object == null) {
            return "";
        }
        return this.numberUtil.format((Number)object);
    }

    public IDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(IDataType iDataType) {
        this.dataType = iDataType;
    }

    public NumberFormat getNumberFormat() {
        return this.numberUtil.getNumberFormat();
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberUtil.setNumberFormat(numberFormat);
    }

    public String getNumberPattern() {
        return this.numberUtil.getNumberPattern();
    }

    public void setNumberPattern(String string) {
        this.numberUtil.setNumberPattern(string);
    }

    public void replaceAllowed(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        Document document = filterBypass.getDocument();
        String string2 = document.getText(0, document.getLength());
        String string3 = string2.substring(0, n) + (string != null ? string : "") + string2.substring(n + n2);
        try {
            if (string3.lastIndexOf(45) > 0) {
                string3 = string3.startsWith("-") ? string3.replace("-", "") : "-" + string3.replace("-", "");
                this.stringToValue(string3);
                filterBypass.replace(0, string2.length(), string3, attributeSet);
            } else {
                this.stringToValue(string3);
                filterBypass.replace(n, n2, string, attributeSet);
            }
        }
        catch (ParseException parseException) {
            this.invalidEdit();
        }
    }

    private class NumberDocumentFilter
    extends DocumentFilter {
        private NumberDocumentFilter() {
        }

        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            NumberFormatter.this.replaceAllowed(filterBypass, n, n2, "", null);
        }

        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            NumberFormatter.this.replaceAllowed(filterBypass, n, 0, string, attributeSet);
        }

        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            NumberFormatter.this.replaceAllowed(filterBypass, n, n2, string, attributeSet);
        }
    }
}

