/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.layout;

import com.sibvisions.rad.ui.swing.ext.JVxConstants;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JViewport;

public class JVxSequenceLayout
implements LayoutManager,
JVxConstants {
    private Insets insMargins = new Insets(0, 0, 0, 0);
    private int iOrientation;
    private int iHorizontalGap;
    private int iVerticalGap;
    private int iHorizontalAlignment = 0;
    private int iVerticalAlignment = 0;
    private int iHorizontalComponentAlignment = 0;
    private int iVerticalComponentAlignment = 0;
    private boolean bAutoWrap = false;

    public JVxSequenceLayout() {
        this(0, 5, 5);
    }

    public JVxSequenceLayout(int n) {
        this(n, 5, 5);
    }

    public JVxSequenceLayout(int n, int n2, int n3) {
        this.iOrientation = n;
        this.iHorizontalGap = n2;
        this.iVerticalGap = n3;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Rectangle rectangle = this.calculateGrid(container);
        return new Dimension(rectangle.width * rectangle.x + this.iHorizontalGap * (rectangle.x - 1) + insets.left + insets.right + this.insMargins.left + this.insMargins.right, rectangle.height * rectangle.y + this.iVerticalGap * (rectangle.y - 1) + insets.top + insets.bottom + this.insMargins.top + this.insMargins.bottom);
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(0, 0);
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        int n3;
        int n4;
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        dimension.width -= insets.left + insets.right + this.insMargins.left + this.insMargins.right;
        dimension.height -= insets.top + insets.bottom + this.insMargins.top + this.insMargins.bottom;
        Rectangle rectangle = this.calculateGrid(container);
        Dimension dimension2 = new Dimension(rectangle.width * rectangle.x + this.iHorizontalGap * (rectangle.x - 1), rectangle.height * rectangle.y + this.iVerticalGap * (rectangle.y - 1));
        if (this.iHorizontalAlignment == 100) {
            n4 = insets.left + this.insMargins.left;
            n3 = dimension.width;
        } else {
            n4 = (int)((float)(dimension.width - dimension2.width) * this.getAlignmentFactor(this.iHorizontalAlignment)) + insets.left + this.insMargins.left;
            n3 = dimension2.width;
        }
        if (this.iVerticalAlignment == 100) {
            n2 = insets.top + this.insMargins.top;
            n = dimension.height;
        } else {
            n2 = (int)((float)(dimension.height - dimension2.height) * this.getAlignmentFactor(this.iVerticalAlignment)) + insets.top + this.insMargins.top;
            n = dimension2.height;
        }
        int n5 = Math.max(1, n3);
        int n6 = Math.max(1, dimension2.width);
        int n7 = Math.max(1, n);
        int n8 = Math.max(1, dimension2.height);
        int n9 = 0;
        int n10 = 0;
        boolean bl = true;
        int n11 = container.getComponentCount();
        for (int i = 0; i < n11; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension3 = JVxUtil.getPreferredSize(component);
            if (this.iOrientation == 0) {
                if (!bl && this.bAutoWrap && dimension.width > 0 && n9 + dimension3.width > dimension.width) {
                    n9 = 0;
                    n10 += (rectangle.height + this.iVerticalGap) * n7 / n8;
                } else if (bl) {
                    bl = false;
                }
                if (this.iVerticalComponentAlignment == 100) {
                    component.setBounds(n4 + n9 * n5 / n6, n2 + n10, dimension3.width * n5 / n6, rectangle.height * n7 / n8);
                } else {
                    component.setBounds(n4 + n9 * n5 / n6, n2 + n10 + (int)((float)(rectangle.height - dimension3.height) * this.getAlignmentFactor(this.iVerticalComponentAlignment)) * n7 / n8, dimension3.width * n5 / n6, dimension3.height * n7 / n8);
                }
                n9 += dimension3.width + this.iHorizontalGap;
                continue;
            }
            if (!bl && this.bAutoWrap && dimension.height > 0 && n10 + dimension3.height > dimension.height) {
                n10 = 0;
                n9 += (rectangle.width + this.iHorizontalGap) * n5 / n6;
            } else if (bl) {
                bl = false;
            }
            if (this.iHorizontalComponentAlignment == 100) {
                component.setBounds(n4 + n9, n2 + n10 * n7 / n8, rectangle.width * n5 / n6, dimension3.height * n7 / n8);
            } else {
                component.setBounds(n4 + n9 + (int)((float)(rectangle.width - dimension3.width) * this.getAlignmentFactor(this.iHorizontalComponentAlignment)) * n5 / n6, n2 + n10 * n7 / n8, dimension3.width * n5 / n6, dimension3.height * n7 / n8);
            }
            n10 += dimension3.height + this.iVerticalGap;
        }
    }

    public void setOrientation(int n) {
        this.iOrientation = n;
    }

    public int getOrientation() {
        return this.iOrientation;
    }

    public void setHorizontalGap(int n) {
        this.iHorizontalGap = n;
    }

    public int getHorizontalGap() {
        return this.iHorizontalGap;
    }

    public void setVerticalGap(int n) {
        this.iVerticalGap = n;
    }

    public int getVerticalGap() {
        return this.iVerticalGap;
    }

    public void setAutoWrap(boolean bl) {
        this.bAutoWrap = bl;
    }

    public boolean isAutoWrap() {
        return this.bAutoWrap;
    }

    public void setHorizontalAlignment(int n) {
        this.iHorizontalAlignment = n;
    }

    public int getHorizontalAlignment() {
        return this.iHorizontalAlignment;
    }

    public void setVerticalAlignment(int n) {
        this.iVerticalAlignment = n;
    }

    public int getVerticalAlignment() {
        return this.iVerticalAlignment;
    }

    public void setHorizontalComponentAlignment(int n) {
        this.iHorizontalComponentAlignment = n;
    }

    public int getHorizontalComponentAlignment() {
        return this.iHorizontalComponentAlignment;
    }

    public void setVerticalComponentAlignment(int n) {
        this.iVerticalComponentAlignment = n;
    }

    public int getVerticalComponentAlignment() {
        return this.iVerticalComponentAlignment;
    }

    private Rectangle calculateGrid(Container container) {
        Serializable serializable;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        int n6 = 1;
        Insets insets = container.getInsets();
        Rectangle rectangle = container.getBounds();
        rectangle.width -= insets.left + insets.right + this.insMargins.left + this.insMargins.right;
        rectangle.height -= insets.top + insets.bottom + this.insMargins.top + this.insMargins.bottom;
        if (container.getParent() instanceof JViewport) {
            serializable = container.getParent().getSize();
            if (((Dimension)serializable).width < rectangle.width) {
                rectangle.width = ((Dimension)serializable).width;
            }
            if (((Dimension)serializable).height < rectangle.height) {
                rectangle.height = ((Dimension)serializable).height;
            }
        }
        boolean bl = true;
        int n7 = container.getComponentCount();
        for (int i = 0; i < n7; ++i) {
            serializable = container.getComponent(i);
            if (!((Component)serializable).isVisible()) continue;
            Dimension dimension = JVxUtil.getPreferredSize((Component)serializable);
            if (this.iOrientation == 0) {
                if (!bl) {
                    n3 += this.iHorizontalGap;
                }
                n2 = Math.max(n2, dimension.height);
                if (!bl && this.bAutoWrap && rectangle.width > 0 && (n3 += dimension.width) > rectangle.width) {
                    n3 = dimension.width;
                    ++n5;
                } else if (bl) {
                    bl = false;
                }
                n = Math.max(n, n3);
                continue;
            }
            if (!bl) {
                n4 += this.iVerticalGap;
            }
            n = Math.max(n, dimension.width);
            if (!bl && this.bAutoWrap && rectangle.height > 0 && (n4 += dimension.height) > rectangle.height) {
                n4 = dimension.height;
                ++n6;
            } else if (bl) {
                bl = false;
            }
            n2 = Math.max(n2, n4);
        }
        return new Rectangle(n6, n5, n, n2);
    }

    private float getAlignmentFactor(int n) {
        switch (n) {
            case 1: 
            case 2: {
                return 0.0f;
            }
            case 0: {
                return 0.5f;
            }
            case 3: 
            case 4: {
                return 1.0f;
            }
        }
        throw new IllegalArgumentException("Invalid alignment: " + n);
    }

    public void setMargins(Insets insets) {
        this.insMargins = insets;
    }

    public Insets getMargins() {
        return this.insMargins;
    }
}

