/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.layout;

import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public class JVxBorderLayout
implements LayoutManager2 {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    private Insets insMargins = new Insets(0, 0, 0, 0);
    private int iHorizontalGap;
    private int iVerticalGap;
    private Component north;
    private Component south;
    private Component east;
    private Component west;
    private Component center;

    public JVxBorderLayout() {
        this(0, 0);
    }

    public JVxBorderLayout(int n, int n2) {
        this.iHorizontalGap = n;
        this.iVerticalGap = n2;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.center) {
            this.center = null;
        } else if (component == this.north) {
            this.north = null;
        } else if (component == this.south) {
            this.south = null;
        } else if (component == this.east) {
            this.east = null;
        } else if (component == this.west) {
            this.west = null;
        }
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object == null || CENTER.equals(object)) {
            this.center = component;
        } else if (NORTH.equals(object)) {
            this.north = component;
        } else if (SOUTH.equals(object)) {
            this.south = component;
        } else if (EAST.equals(object)) {
            this.east = component;
        } else if (WEST.equals(object)) {
            this.west = component;
        } else {
            throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + object);
        }
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        Dimension dimension2;
        Dimension dimension3;
        Dimension dimension4;
        if (container.isMinimumSizeSet()) {
            return container.getMinimumSize();
        }
        if (this.north == null) {
            dimension4 = new Dimension(0, 0);
        } else {
            dimension4 = JVxUtil.getMinimumSize(this.north);
            dimension4.height += this.getVerticalGap();
        }
        if (this.west == null) {
            dimension3 = new Dimension(0, 0);
        } else {
            dimension3 = JVxUtil.getMinimumSize(this.west);
            dimension3.width += this.getHorizontalGap();
        }
        Dimension dimension5 = this.center == null ? new Dimension(0, 0) : JVxUtil.getMinimumSize(this.center);
        if (this.east == null) {
            dimension2 = new Dimension(0, 0);
        } else {
            dimension2 = JVxUtil.getMinimumSize(this.east);
            dimension2.width += this.getHorizontalGap();
        }
        if (this.south == null) {
            dimension = new Dimension(0, 0);
        } else {
            dimension = JVxUtil.getMinimumSize(this.south);
            dimension.height += this.getVerticalGap();
        }
        return new Dimension(Math.max(Math.max(dimension4.width, dimension.width), dimension3.width + dimension5.width + dimension2.width), Math.max(Math.max(dimension3.height, dimension2.height), dimension5.height) + dimension4.height + dimension.height);
    }

    public Dimension maximumLayoutSize(Container container) {
        if (container.isMaximumSizeSet()) {
            return container.getMaximumSize();
        }
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension preferredLayoutSize(Container container) {
        Cloneable cloneable;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.north != null && this.north.isVisible()) {
            cloneable = JVxUtil.getPreferredSize(this.north);
            n3 = cloneable.width;
            n2 += cloneable.height + this.iVerticalGap;
        }
        if (this.south != null && this.south.isVisible()) {
            cloneable = JVxUtil.getPreferredSize(this.south);
            if (cloneable.width > n3) {
                n3 = cloneable.width;
            }
            n2 += cloneable.height + this.iVerticalGap;
        }
        if (this.west != null && this.west.isVisible()) {
            cloneable = JVxUtil.getPreferredSize(this.west);
            n4 = cloneable.height;
            n += cloneable.width + this.iHorizontalGap;
        }
        if (this.east != null && this.east.isVisible()) {
            cloneable = JVxUtil.getPreferredSize(this.east);
            if (cloneable.height > n4) {
                n4 = cloneable.height;
            }
            n += cloneable.width + this.iHorizontalGap;
        }
        if (this.center != null && this.center.isVisible()) {
            cloneable = JVxUtil.getPreferredSize(this.center);
            if (cloneable.height > n4) {
                n4 = cloneable.height;
            }
            n += cloneable.width;
        }
        n2 += n4;
        if (n3 > n) {
            n = n3;
        }
        cloneable = container.getInsets();
        return new Dimension(n + ((Insets)cloneable).left + ((Insets)cloneable).right + this.insMargins.left + this.insMargins.right, n2 + ((Insets)cloneable).top + ((Insets)cloneable).bottom + this.insMargins.top + this.insMargins.bottom);
    }

    public void layoutContainer(Container container) {
        Dimension dimension;
        Dimension dimension2 = container.getSize();
        Insets insets = container.getInsets();
        int n = insets.left + this.insMargins.left;
        int n2 = insets.top + this.insMargins.top;
        int n3 = dimension2.width - n - insets.right - this.insMargins.right;
        int n4 = dimension2.height - n2 - insets.bottom - this.insMargins.bottom;
        if (this.north != null && this.north.isVisible()) {
            dimension = JVxUtil.getPreferredSize(this.north);
            this.north.setBounds(n, n2, n3, dimension.height);
            n2 += dimension.height + this.iVerticalGap;
            n4 -= dimension.height + this.iVerticalGap;
        }
        if (this.south != null && this.south.isVisible()) {
            dimension = JVxUtil.getPreferredSize(this.south);
            this.south.setBounds(n, n2 + n4 - dimension.height, n3, dimension.height);
            n4 -= dimension.height + this.iVerticalGap;
        }
        if (this.west != null && this.west.isVisible()) {
            dimension = JVxUtil.getPreferredSize(this.west);
            this.west.setBounds(n, n2, dimension.width, n4);
            n += dimension.width + this.iHorizontalGap;
            n3 -= dimension.width + this.iHorizontalGap;
        }
        if (this.east != null && this.east.isVisible()) {
            dimension = JVxUtil.getPreferredSize(this.east);
            this.east.setBounds(n + n3 - dimension.width, n2, dimension.width, n4);
            n3 -= dimension.width + this.iHorizontalGap;
        }
        if (this.center != null && this.center.isVisible()) {
            this.center.setBounds(n, n2, n3, n4);
        }
    }

    public void setHorizontalGap(int n) {
        this.iHorizontalGap = n;
    }

    public int getHorizontalGap() {
        return this.iHorizontalGap;
    }

    public void setVerticalGap(int n) {
        this.iVerticalGap = n;
    }

    public int getVerticalGap() {
        return this.iVerticalGap;
    }

    public void setMargins(Insets insets) {
        this.insMargins = insets == null ? new Insets(0, 0, 0, 0) : insets;
    }

    public Insets getMargins() {
        return this.insMargins;
    }

    public Object getConstraints(Component component) {
        if (component == this.center) {
            return CENTER;
        }
        if (component == this.north) {
            return NORTH;
        }
        if (component == this.south) {
            return SOUTH;
        }
        if (component == this.west) {
            return WEST;
        }
        if (component == this.east) {
            return EAST;
        }
        return null;
    }
}

