/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.focus;

import com.sibvisions.rad.ui.swing.ext.focus.TabIndexComparator;
import java.awt.Component;
import java.awt.Container;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class TabIndexFocusTraversalPolicy
extends LayoutFocusTraversalPolicy
implements Runnable {
    private Comparator originalComperator = super.getComparator();
    private JComponent centerComponent = null;

    public TabIndexFocusTraversalPolicy() {
        this.setComparator(new TabIndexComparator(this));
    }

    protected Comparator getComparator() {
        return this.originalComperator;
    }

    public Component getComponentAfter(Container container, Component component) {
        this.searchCenterComponent(container);
        return super.getComponentAfter(container, component);
    }

    public Component getComponentBefore(Container container, Component component) {
        this.searchCenterComponent(container);
        return super.getComponentBefore(container, component);
    }

    public Component getFirstComponent(Container container) {
        this.searchCenterComponent(container);
        return super.getFirstComponent(container);
    }

    public Component getLastComponent(Container container) {
        this.searchCenterComponent(container);
        return super.getLastComponent(container);
    }

    protected boolean accept(Component component) {
        return super.accept(component) && (!(component instanceof JTextComponent) || ((JTextComponent)component).isEditable());
    }

    public void run() {
        this.centerComponent = null;
    }

    protected JComponent getCenterComponent() {
        return this.centerComponent;
    }

    private final void searchCenterComponent(Container container) {
        if (this.centerComponent == null) {
            this.searchCenterComponent(container, Integer.MIN_VALUE);
            SwingUtilities.invokeLater(this);
        }
    }

    private final void searchCenterComponent(Container container, int n) {
        if (container.isVisible() && container.isDisplayable()) {
            int n2 = container.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                int n3;
                JComponent jComponent;
                Object object;
                Component component = container.getComponent(i);
                if (component instanceof JComponent && (object = (jComponent = (JComponent)component).getClientProperty("tabIndex")) instanceof Number && (n3 = ((Number)object).intValue()) > n) {
                    n = n3;
                    this.centerComponent = jComponent;
                }
                if (!(component instanceof Container) || ((Container)component).isFocusTraversalPolicyProvider() || ((Container)component).isFocusCycleRoot() || component instanceof JComponent && ((JComponent)component).isManagingFocus()) continue;
                this.searchCenterComponent((Container)component, n);
            }
        }
    }
}

