/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext.celleditor;

import com.sibvisions.rad.ui.swing.ext.JVxCheckBox;
import com.sibvisions.rad.ui.swing.ext.celleditor.JVxStyledCellEditor;
import com.sibvisions.rad.ui.swing.ext.cellrenderer.JVxCheckBoxRenderer;
import com.sibvisions.rad.ui.swing.impl.SwingFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.ICellEditorListener;
import javax.rad.model.ui.IEditorControl;
import javax.rad.ui.IAlignmentConstants;
import javax.rad.ui.celleditor.ICheckBoxCellEditor;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVxCheckBoxCellEditor
extends JVxStyledCellEditor
implements ICheckBoxCellEditor<Component> {
    private Object selectedValue;
    private Object deselectedValue;
    private String text;
    private JVxCheckBoxRenderer cellRenderer = null;

    public JVxCheckBoxCellEditor() {
        this(null, null, null);
    }

    public JVxCheckBoxCellEditor(Object object, Object object2) {
        this(object, object2, null);
    }

    public JVxCheckBoxCellEditor(Object object, Object object2, String string) {
        this.setSelectedValue(object);
        this.setDeselectedValue(object2);
        this.setText(string);
        this.setHorizontalAlignment(1);
    }

    @Override
    public ICellEditorHandler<JComponent> createCellEditorHandler(ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
        return new CellEditorHandler(this, iCellEditorListener, iDataRow, string);
    }

    @Override
    public Component getCellRendererComponent(Component component, IDataPage iDataPage, int n, IDataRow iDataRow, String string, boolean bl, boolean bl2) {
        if (this.cellRenderer == null) {
            this.cellRenderer = new JVxCheckBoxRenderer();
        }
        this.cellRenderer.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.getHorizontalAlignment()));
        this.cellRenderer.setVerticalAlignment(SwingFactory.getVerticalSwingAlignment(this.getVerticalAlignment()));
        try {
            this.cellRenderer.setSelected(this.selectedValue != null && this.selectedValue.equals(iDataRow.getValue(string)));
        }
        catch (Exception exception) {
            this.cellRenderer.setSelected(false);
        }
        return this.cellRenderer;
    }

    @Override
    public boolean isDirectCellEditor() {
        return true;
    }

    @Override
    public Object getSelectedValue() {
        return this.selectedValue;
    }

    @Override
    public void setSelectedValue(Object object) {
        this.selectedValue = object;
    }

    @Override
    public Object getDeselectedValue() {
        return this.deselectedValue;
    }

    @Override
    public void setDeselectedValue(Object object) {
        this.deselectedValue = object;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String string) {
        this.text = string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CellEditorHandler
    implements ICellEditorHandler<JComponent>,
    ItemListener,
    KeyListener,
    FocusListener {
        private JVxCheckBoxCellEditor cellEditor;
        private ICellEditorListener cellEditorListener;
        private IDataRow dataRow;
        private String columnName;
        private JVxCheckBox cellEditorComponent;
        private IAlignmentConstants dynamicAlignment = null;
        private boolean ignoreEvent = false;
        private boolean firstEditingStarted = true;

        public CellEditorHandler(JVxCheckBoxCellEditor jVxCheckBoxCellEditor, ICellEditorListener iCellEditorListener, IDataRow iDataRow, String string) {
            this.cellEditor = jVxCheckBoxCellEditor;
            this.cellEditorListener = iCellEditorListener;
            this.dataRow = iDataRow;
            this.columnName = string;
            this.cellEditorComponent = new JVxCheckBox();
            if (this.cellEditorListener instanceof IAlignmentConstants) {
                this.dynamicAlignment = (IAlignmentConstants)((Object)this.cellEditorListener);
            } else {
                this.cellEditorComponent.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(this.cellEditor.getHorizontalAlignment()));
                this.cellEditorComponent.setVerticalAlignment(SwingFactory.getVerticalSwingAlignment(this.cellEditor.getVerticalAlignment()));
            }
            this.cellEditorComponent.setFocusTraversalKeysEnabled(false);
            this.cellEditorComponent.addItemListener(this);
            this.cellEditorComponent.addKeyListener(this);
            this.cellEditorComponent.addFocusListener(this);
        }

        @Override
        public void uninstallEditor() {
            this.cellEditorComponent.removeItemListener(this);
            this.cellEditorComponent.removeKeyListener(this);
            this.cellEditorComponent.removeFocusListener(this);
        }

        @Override
        public void updateEditor() {
        }

        @Override
        public ICellEditor getCellEditor() {
            return this.cellEditor;
        }

        @Override
        public ICellEditorListener getCellEditorListener() {
            return this.cellEditorListener;
        }

        @Override
        public IDataRow getDataRow() {
            return this.dataRow;
        }

        @Override
        public String getColumnName() {
            return this.columnName;
        }

        @Override
        public JComponent getCellEditorComponent() {
            return this.cellEditorComponent;
        }

        @Override
        public void saveEditing() throws ModelException {
            if (this.cellEditorComponent.isSelected()) {
                this.dataRow.setValue(this.columnName, this.cellEditor.selectedValue);
            } else {
                this.dataRow.setValue(this.columnName, this.cellEditor.deselectedValue);
            }
        }

        @Override
        public void cancelEditing() throws ModelException {
            if (!this.ignoreEvent) {
                this.ignoreEvent = true;
                Container container = this.cellEditorComponent.getParent();
                boolean bl = container == null || container.isEnabled();
                try {
                    block12: {
                        try {
                            this.cellEditorComponent.setSelected(this.cellEditor.selectedValue != null && this.cellEditor.selectedValue.equals(this.dataRow.getValue(this.columnName)));
                            if (this.cellEditorListener instanceof IEditorControl) {
                                if (this.cellEditor.text == null) {
                                    this.cellEditorComponent.setText(this.dataRow.getRowDefinition().getColumnDefinition(this.columnName).getLabel());
                                } else {
                                    this.cellEditorComponent.setText(this.cellEditor.text);
                                }
                            }
                            if (this.dataRow instanceof IDataBook) {
                                IDataBook iDataBook = (IDataBook)this.dataRow;
                                this.cellEditorComponent.setEnabled(bl && iDataBook.isUpdateAllowed() && !iDataBook.getRowDefinition().getColumnDefinition(this.columnName).isReadOnly() && iDataBook.getSelectedRow() >= 0);
                            } else {
                                this.cellEditorComponent.setEnabled(bl && !this.dataRow.getRowDefinition().getColumnDefinition(this.columnName).isReadOnly());
                            }
                            if (this.dynamicAlignment == null) break block12;
                            int n = this.dynamicAlignment.getHorizontalAlignment();
                            if (n == -1) {
                                n = this.cellEditor.getHorizontalAlignment();
                            }
                            this.cellEditorComponent.setHorizontalAlignment(SwingFactory.getHorizontalSwingAlignment(n));
                            int n2 = this.dynamicAlignment.getVerticalAlignment();
                            if (n2 == -1) {
                                n2 = this.cellEditor.getVerticalAlignment();
                            }
                            this.cellEditorComponent.setVerticalAlignment(SwingFactory.getVerticalSwingAlignment(n2));
                        }
                        catch (Exception exception) {
                            this.cellEditorComponent.setSelected(false);
                            this.cellEditorComponent.setEnabled(false);
                            throw new ModelException("Editor cannot be restored!", exception);
                        }
                    }
                    Object var6_7 = null;
                    this.firstEditingStarted = true;
                    this.ignoreEvent = false;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    this.firstEditingStarted = true;
                    this.ignoreEvent = false;
                    throw throwable;
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (!this.ignoreEvent) {
                this.fireEditingStarted();
                this.fireEditingComplete("ACTION_KEY");
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                switch (keyEvent.getKeyCode()) {
                    case 27: {
                        keyEvent.consume();
                        this.fireEditingComplete("ESCAPE_KEY");
                        break;
                    }
                    case 10: {
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_ENTER_KEY");
                            break;
                        }
                        this.fireEditingComplete("ENTER_KEY");
                        break;
                    }
                    case 9: {
                        keyEvent.consume();
                        if (keyEvent.isShiftDown()) {
                            this.fireEditingComplete("SHIFT_TAB_KEY");
                            break;
                        }
                        this.fireEditingComplete("TAB_KEY");
                        break;
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                this.fireEditingComplete("FOCUS_LOST");
            }
        }

        protected void fireEditingStarted() {
            if (this.firstEditingStarted && !this.ignoreEvent && this.cellEditorListener != null) {
                this.firstEditingStarted = false;
                this.cellEditorListener.editingStarted();
            }
        }

        protected void fireEditingComplete(String string) {
            if (!this.ignoreEvent && this.cellEditorListener != null) {
                this.cellEditorListener.editingComplete(string);
            }
        }
    }
}

