/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.swing.ext.ICellFormatterEditorListener;
import com.sibvisions.rad.ui.swing.ext.JVxComboBase;
import com.sibvisions.rad.ui.swing.ext.JVxIcon;
import com.sibvisions.rad.ui.swing.ext.JVxScrollPane;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import com.sibvisions.rad.ui.swing.ext.cellrenderer.JVxIconRenderer;
import com.sibvisions.rad.ui.swing.ext.cellrenderer.JVxRendererContainer;
import com.sibvisions.rad.ui.swing.ext.format.CellFormat;
import com.sibvisions.rad.ui.swing.ext.format.ICellFormatter;
import com.sibvisions.rad.ui.swing.ext.layout.JVxBorderLayout;
import com.sibvisions.util.ArrayUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.ColumnView;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataBook;
import javax.rad.model.IDataRow;
import javax.rad.model.ModelException;
import javax.rad.model.SortDefinition;
import javax.rad.model.datatype.IDataType;
import javax.rad.model.event.DataBookEvent;
import javax.rad.model.event.DataRowEvent;
import javax.rad.model.event.IDataBookListener;
import javax.rad.model.event.IDataRowListener;
import javax.rad.model.ui.ICellEditor;
import javax.rad.model.ui.ICellEditorHandler;
import javax.rad.model.ui.ICellRenderer;
import javax.rad.model.ui.ITableControl;
import javax.rad.ui.IResource;
import javax.rad.ui.celleditor.IComboCellEditor;
import javax.rad.ui.celleditor.IInplaceCellEditor;
import javax.rad.ui.control.INavigationControl;
import javax.rad.util.ExceptionHandler;
import javax.rad.util.SilentAbortException;
import javax.rad.util.TranslationMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVxTable
extends JVxScrollPane
implements ITableControl,
INavigationControl,
ICellFormatterEditorListener,
ListSelectionListener,
Runnable,
KeyListener,
FocusListener,
IDataBookListener,
IDataRowListener {
    private JTable table = new JTable(){

        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            return false;
        }

        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            return super.editCellAt(n, n2, eventObject) && this.getEditorComponent() != null;
        }

        public void setShowHorizontalLines(boolean bl) {
            super.setShowHorizontalLines(bl);
            if (bl) {
                this.setRowMargin(1);
            } else {
                this.setRowMargin(0);
            }
        }

        public void setShowVerticalLines(boolean bl) {
            super.setShowVerticalLines(bl);
            if (bl) {
                this.getColumnModel().setColumnMargin(1);
            } else {
                this.getColumnModel().setColumnMargin(0);
            }
        }

        public void setColumnModel(TableColumnModel tableColumnModel) {
            super.setColumnModel(tableColumnModel);
            if (this.getShowVerticalLines()) {
                this.getColumnModel().setColumnMargin(1);
            } else {
                this.getColumnModel().setColumnMargin(0);
            }
        }

        public void doLayout() {
            TableColumn tableColumn;
            TableColumn tableColumn2;
            if (JVxTable.this.autoFillEmptySpace && !JVxTable.this.isAutoResize() && (tableColumn2 = this.getTableHeader().getResizingColumn()) != null && (tableColumn = this.getColumnModel().getColumn(this.getColumnModel().getColumnCount() - 1)) != tableColumn2) {
                Dimension dimension = JVxTable.this.getViewport().getSize();
                int n = this.getColumnModel().getTotalColumnWidth();
                if (n < dimension.width) {
                    tableColumn.setWidth(tableColumn.getWidth() + dimension.width - n);
                } else if (tableColumn.getWidth() > JVxTable.this.lastColumnWidth) {
                    tableColumn.setWidth(Math.max(JVxTable.this.lastColumnWidth, tableColumn.getWidth() + dimension.width - n));
                } else {
                    this.layout();
                    return;
                }
            }
            super.doLayout();
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (JVxTable.this.autoFillEmptySpace && !JVxTable.this.isAutoResize() && JVxTable.this.calculateMinSize && JVxTable.this.getViewport() != null) {
                TableColumn tableColumn;
                Dimension dimension2 = JVxTable.this.getViewport().getSize();
                TableColumn tableColumn2 = this.getTableHeader().getResizingColumn();
                if (tableColumn2 != null && tableColumn2 != (tableColumn = this.getColumnModel().getColumn(this.getColumnModel().getColumnCount() - 1)) && tableColumn.getWidth() > JVxTable.this.lastColumnWidth) {
                    dimension.width += JVxTable.this.lastColumnWidth - tableColumn.getWidth();
                }
                if (dimension2.width > dimension.width) {
                    dimension.width = dimension2.width;
                }
                if (dimension2.height > dimension.height) {
                    dimension.height = dimension2.height;
                }
            }
            return dimension;
        }
    };
    private IDataBook dataBook = null;
    private ColumnView columnView = null;
    private ICellFormatter cellFormatter = null;
    private ICellEditorHandler<JComponent> cellEditorHandler = null;
    private TranslationMap translation = null;
    private static KeyEvent focusKeyEvent = null;
    private int rowHeight = -1;
    private int minRowHeight = 20;
    private int maxRowHeight = 120;
    private int enterNavigationMode = 1;
    private int tabNavigationMode = 1;
    private int lastColumnWidth = 0;
    private boolean sortOnHeaderEnabled = true;
    private boolean autoFillEmptySpace = true;
    private boolean editable = true;
    private boolean showSelection = true;
    private boolean showFocusRect = true;
    private boolean firstNotifyRepaintCall = true;
    private boolean editingStarted = false;
    private boolean correctMouseSelection = false;
    private boolean ignoreEvent = false;
    private boolean ignoreMousePressed = false;
    private boolean isNotified = false;
    private boolean calculateMinSize = true;
    private boolean mouseEventOnSelectedCell = false;
    private static boolean ignoreFocusEvent = false;
    private boolean bTranslationEnabled = true;

    public JVxTable() {
        this.table.setSelectionMode(0);
        this.table.setFocusTraversalKeysEnabled(false);
        this.table.addKeyListener(this);
        this.table.addMouseListener(this);
        this.table.addFocusListener(this);
        this.setViewportView(this.table);
        this.setBackground(this.table.getBackground());
        this.configureTableHeader();
        this.setAutoResize(true);
    }

    @Override
    public void run() {
        this.firstNotifyRepaintCall = true;
        if (this.isNotified) {
            this.doRepaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.ignoreMousePressed && mouseEvent.getSource() == this.table) {
            this.correctMouseSelection = true;
            if (!this.ignoreEvent && this.firstNotifyRepaintCall && this.dataBook != null && this.dataBook.isOpen()) {
                this.ignoreEvent = true;
                try {
                    Point point = mouseEvent.getPoint();
                    int n = this.table.rowAtPoint(point);
                    if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                        if (n >= 0) {
                            this.mouseEventOnSelectedCell = true;
                            try {
                                int n2;
                                this.dataBook.setSelectedRow(n);
                                if (n != this.table.getSelectedRow()) {
                                    this.table.getSelectionModel().clearSelection();
                                    this.table.setRowSelectionInterval(n, n);
                                }
                                if ((n2 = this.table.columnAtPoint(point)) >= 0) {
                                    this.dataBook.setSelectedColumn((String)this.table.getColumnModel().getColumn(n2).getIdentifier());
                                }
                            }
                            catch (ModelException modelException) {
                                this.notifyRepaint();
                                ExceptionHandler.raise(modelException);
                            }
                        }
                    } else {
                        if (n >= 0) {
                            this.mouseEventOnSelectedCell = true;
                        }
                        this.dataBook.setSelectedRow(this.table.getSelectedRow());
                    }
                    this.repaint();
                    this.ignoreEvent = false;
                }
                catch (ModelException modelException) {
                    this.ignoreEvent = false;
                    this.notifyRepaint();
                    ExceptionHandler.raise(modelException);
                }
            }
        }
        super.mousePressed(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.correctMouseSelection = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JVxTable.this.mouseEventOnSelectedCell = false;
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.ignoreEvent) {
            this.ignoreEvent = true;
            try {
                if (EventQueue.getCurrentEvent() instanceof MouseEvent || EventQueue.getCurrentEvent() instanceof InvocationEvent) {
                    if (this.correctMouseSelection) {
                        try {
                            int n = this.dataBook.getSelectedRow();
                            if (n != this.table.getSelectedRow()) {
                                this.table.getSelectionModel().clearSelection();
                                if (n >= 0) {
                                    this.table.setRowSelectionInterval(n, n);
                                }
                            }
                        }
                        catch (ModelException modelException) {
                            this.notifyRepaint();
                            ExceptionHandler.raise(modelException);
                        }
                    }
                } else {
                    this.dataBook.setSelectedRow(this.table.getSelectedRow());
                }
                this.ignoreEvent = false;
            }
            catch (ModelException modelException) {
                this.ignoreEvent = false;
                this.notifyRepaint();
                ExceptionHandler.raise(modelException);
            }
        }
    }

    @Override
    public void notifyRepaint() {
        if (this.firstNotifyRepaintCall && !this.ignoreEvent && !this.editingStarted) {
            this.firstNotifyRepaintCall = false;
            JVxUtil.invokeLater(this);
        }
    }

    @Override
    public void startEditing() {
        if (this.cellEditorHandler == null) {
            this.table.editCellAt(this.table.getSelectedRow(), this.table.getSelectedColumn());
        }
    }

    @Override
    public void cancelEditing() {
        if (this.cellEditorHandler != null) {
            this.editingStarted = false;
            this.cellEditorHandler.uninstallEditor();
            this.cellEditorHandler = null;
            this.table.editingCanceled(null);
        }
    }

    @Override
    public void saveEditing() throws ModelException {
        if (this.editingStarted) {
            this.editingStarted = false;
            this.cellEditorHandler.saveEditing();
        }
        this.cancelEditing();
    }

    @Override
    public void setTranslation(TranslationMap translationMap) {
        this.translation = translationMap;
        if (this.cellEditorHandler != null) {
            this.cellEditorHandler.updateEditor();
        }
        this.notifyRepaint();
    }

    @Override
    public TranslationMap getTranslation() {
        return this.translation;
    }

    @Override
    public void setTranslationEnabled(boolean bl) {
        this.bTranslationEnabled = bl;
    }

    @Override
    public boolean isTranslationEnabled() {
        return this.bTranslationEnabled;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed()) {
            try {
                switch (keyEvent.getKeyCode()) {
                    case 10: {
                        if (!keyEvent.isControlDown() && !keyEvent.isAltDown()) {
                            keyEvent.consume();
                            if (keyEvent.isShiftDown()) {
                                this.selectPrevious(this.enterNavigationMode);
                                break;
                            }
                            this.selectNext(this.enterNavigationMode);
                        }
                        break;
                    }
                    case 9: {
                        if (!keyEvent.isControlDown() && !keyEvent.isAltDown()) {
                            keyEvent.consume();
                            if (keyEvent.isShiftDown()) {
                                this.selectPrevious(this.tabNavigationMode);
                                break;
                            }
                            this.selectNext(this.tabNavigationMode);
                        }
                        break;
                    }
                    case 33: {
                        if (!keyEvent.isControlDown() && !keyEvent.isAltDown()) {
                            keyEvent.consume();
                            this.ignoreEvent = true;
                            this.selectPreviousPage(false);
                        }
                        break;
                    }
                    case 34: {
                        if (!keyEvent.isControlDown() && !keyEvent.isAltDown()) {
                            keyEvent.consume();
                            this.ignoreEvent = true;
                            this.selectNextPage(false);
                        }
                        break;
                    }
                    case 38: {
                        if (!keyEvent.isControlDown() && !keyEvent.isAltDown()) {
                            keyEvent.consume();
                            this.ignoreEvent = true;
                            this.selectPreviousRow(false);
                        }
                        break;
                    }
                    case 40: {
                        if (keyEvent.isAltDown()) {
                            this.startEditing();
                            this.openComboBox();
                            break;
                        }
                        if (!keyEvent.isControlDown()) {
                            keyEvent.consume();
                            this.ignoreEvent = true;
                            this.selectNextRow(false);
                        }
                        break;
                    }
                    case 37: {
                        if (!keyEvent.isControlDown() && !keyEvent.isAltDown()) {
                            keyEvent.consume();
                            this.selectPreviousCell(false);
                        }
                        break;
                    }
                    case 39: {
                        if (!keyEvent.isControlDown() && !keyEvent.isAltDown()) {
                            keyEvent.consume();
                            this.selectNextCell(false);
                        }
                        break;
                    }
                    case 113: {
                        keyEvent.consume();
                        this.startEditing();
                        break;
                    }
                    case 155: {
                        keyEvent.consume();
                        if (this.dataBook.isInsertAllowed() && !this.dataBook.isReadOnly()) {
                            this.dataBook.insert(false);
                        }
                        break;
                    }
                    case 127: {
                        keyEvent.consume();
                        if (this.dataBook.isDeleteAllowed() && !this.dataBook.isReadOnly()) {
                            this.dataBook.delete();
                        }
                        break;
                    }
                    case 27: {
                        keyEvent.consume();
                        this.dataBook.restoreSelectedRow();
                        break;
                    }
                    default: {
                        char c;
                        int n = this.table.getSelectedRow();
                        int n2 = this.table.getSelectedColumn();
                        if (n >= 0 && n2 >= 0 && (c = keyEvent.getKeyChar()) >= ' ' && c < '\uffff' && c != '\u007f' && !keyEvent.isAltDown()) {
                            keyEvent.consume();
                            this.table.editCellAt(this.table.getSelectedRow(), this.table.getSelectedColumn(), keyEvent);
                        }
                        break;
                    }
                }
            }
            catch (ModelException modelException) {
                ExceptionHandler.raise(modelException);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.ignoreEvent) {
            try {
                this.dataBook.setSelectedRow(this.table.getSelectedRow());
                this.ignoreEvent = false;
            }
            catch (ModelException modelException) {
                this.ignoreEvent = false;
                this.notifyRepaint();
                ExceptionHandler.raise(modelException);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!ignoreFocusEvent && focusKeyEvent != null && (focusKeyEvent.getKeyChar() == '\t' && this.tabNavigationMode == 1 || focusKeyEvent.getKeyChar() == '\n' && this.enterNavigationMode == 1)) {
            if (focusKeyEvent.isShiftDown()) {
                this.table.setColumnSelectionInterval(this.table.getColumnCount() - 1, this.table.getColumnCount() - 1);
            } else {
                this.table.setColumnSelectionInterval(0, 0);
            }
            this.scrollToSelectedCell();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        ignoreFocusEvent = false;
    }

    @Override
    public void dataBookChanged(DataBookEvent dataBookEvent) throws ModelException {
        ((DataBookTableColumnModel)this.table.getColumnModel()).calculateHeightAndWidth = true;
    }

    @Override
    public void valuesChanged(DataRowEvent dataRowEvent) throws ModelException {
        ((DataBookTableColumnModel)this.table.getColumnModel()).calculateHeightAndWidth = true;
    }

    @Override
    public void editingStarted() {
        try {
            this.editingStarted = true;
            IDataRow iDataRow = this.dataBook.createDataRow(null);
            this.dataBook.update();
            if (this.cellEditorHandler == null || !iDataRow.equals(this.dataBook, new String[]{this.cellEditorHandler.getColumnName()})) {
                this.editingStarted = false;
                this.notifyRepaint();
            }
        }
        catch (ModelException modelException) {
            this.editingStarted = false;
            this.notifyRepaint();
            ExceptionHandler.raise(modelException);
        }
    }

    @Override
    public void editingComplete(String string) {
        ignoreFocusEvent = true;
        if (string == "ESCAPE_KEY") {
            this.cancelEditing();
            if (!this.table.hasFocus()) {
                this.table.requestFocus();
            }
        } else {
            try {
                this.saveEditing();
            }
            catch (ModelException modelException) {
                this.cancelEditing();
                if (!this.table.hasFocus()) {
                    this.table.requestFocus();
                }
                ExceptionHandler.raise(modelException);
            }
            if (string == "ENTER_KEY") {
                this.selectNext(this.enterNavigationMode);
            } else if (string == "SHIFT_ENTER_KEY") {
                this.selectPrevious(this.enterNavigationMode);
            } else if (string == "TAB_KEY") {
                this.selectNext(this.tabNavigationMode);
            } else if (string == "SHIFT_TAB_KEY") {
                this.selectPrevious(this.tabNavigationMode);
            }
        }
    }

    @Override
    public boolean isSavingImmediate() {
        return false;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.ignoreEvent = true;
        this.table.scrollRectToVisible(new Rectangle());
        this.table.getSelectionModel().clearSelection();
        this.ignoreEvent = false;
        this.doRepaint();
        this.isNotified = true;
    }

    @Override
    public void removeNotify() {
        this.isNotified = false;
        super.removeNotify();
        this.configureTableHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        this.calculateMinSize = false;
        try {
            Dimension dimension = super.getPreferredSize();
            Object var3_2 = null;
            this.calculateMinSize = true;
            return dimension;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.calculateMinSize = true;
            throw throwable;
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.table != null) {
            this.table.setBackground(color);
            this.getViewport().setBackground(color);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.table != null) {
            this.table.setEnabled(bl);
            if (this.isEnabled()) {
                this.getViewport().setBackground(this.table.getBackground());
            } else {
                this.getViewport().setBackground(JVxUtil.getSystemColor("IControl.readOnlyBackground"));
            }
        }
    }

    @Override
    @Deprecated
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (!this.isAutoResize()) {
            this.doLayout();
        }
    }

    public boolean isNotified() {
        return this.isNotified;
    }

    protected boolean isIgnoreEvent() {
        return this.ignoreEvent;
    }

    protected void setIgnoreEvent(boolean bl) {
        this.ignoreEvent = bl;
    }

    private void configureTableHeader() {
        this.setColumnHeaderView(this.table.getTableHeader());
        Border border = this.getBorder();
        if (border == null || border instanceof UIResource) {
            this.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        }
    }

    @Override
    public IDataBook getDataBook() {
        return this.dataBook;
    }

    @Override
    public void setDataBook(IDataBook iDataBook) {
        if (iDataBook != this.dataBook) {
            if (this.dataBook != null) {
                this.dataBook.removeControl(this);
                this.dataBook.eventAfterReload().removeListener(this);
                this.dataBook.eventValuesChanged().removeListener(this);
                this.table.getSelectionModel().removeListSelectionListener(this);
                this.table.setColumnModel(new DefaultTableColumnModel());
                this.table.setAutoCreateColumnsFromModel(true);
                this.table.setModel(new DefaultTableModel());
                if (this.columnView != null && this.columnView != this.dataBook.getRowDefinition().getColumnView(ITableControl.class)) {
                    this.columnView.removeRowDefinition(this.dataBook.getRowDefinition());
                }
            }
            this.dataBook = iDataBook;
            if (this.dataBook != null) {
                this.table.setModel(new DataBookTableModel(this, this.dataBook));
                this.table.setAutoCreateColumnsFromModel(false);
                this.table.setColumnModel(new DataBookTableColumnModel(this));
                this.table.getSelectionModel().addListSelectionListener(this);
                this.dataBook.addControl(this);
                this.dataBook.eventAfterReload().addListener(this);
                this.dataBook.eventValuesChanged().addListener(this);
                if (this.columnView != null && this.columnView != this.dataBook.getRowDefinition().getColumnView(ITableControl.class)) {
                    this.columnView.addRowDefinition(this.dataBook.getRowDefinition());
                }
            }
            this.notifyRepaint();
        }
    }

    public ColumnView getColumnView() {
        if (this.columnView == null && this.dataBook != null) {
            return this.dataBook.getRowDefinition().getColumnView(ITableControl.class);
        }
        return this.columnView;
    }

    public void setColumnView(ColumnView columnView) {
        if (this.columnView != columnView) {
            if (this.columnView != null && this.dataBook != null && this.columnView != this.dataBook.getRowDefinition().getColumnView(ITableControl.class)) {
                this.columnView.removeRowDefinition(this.dataBook.getRowDefinition());
            }
            this.columnView = columnView;
            if (this.columnView != null && this.dataBook != null && this.columnView != this.dataBook.getRowDefinition().getColumnView(ITableControl.class)) {
                this.columnView.addRowDefinition(this.dataBook.getRowDefinition());
            }
            this.notifyRepaint();
        }
    }

    @Override
    public ICellFormatter getCellFormatter() {
        return this.cellFormatter;
    }

    public void setCellFormatter(ICellFormatter iCellFormatter) {
        this.cellFormatter = iCellFormatter;
    }

    public boolean isTableHeaderVisible() {
        return this.getColumnHeader().isVisible();
    }

    public void setTableHeaderVisible(boolean bl) {
        this.getColumnHeader().setVisible(bl);
    }

    public boolean isSortOnHeaderEnabled() {
        return this.sortOnHeaderEnabled;
    }

    public void setSortOnHeaderEnabled(boolean bl) {
        this.sortOnHeaderEnabled = bl;
    }

    public boolean isAutoFillEmptySpace() {
        return this.autoFillEmptySpace;
    }

    public void setAutoFillEmptySpace(boolean bl) {
        this.autoFillEmptySpace = bl;
    }

    @Override
    public int getEnterNavigationMode() {
        return this.enterNavigationMode;
    }

    @Override
    public void setEnterNavigationMode(int n) {
        this.enterNavigationMode = n;
    }

    @Override
    public int getTabNavigationMode() {
        return this.tabNavigationMode;
    }

    @Override
    public void setTabNavigationMode(int n) {
        this.tabNavigationMode = n;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int n) {
        this.rowHeight = n;
    }

    public int getMinRowHeight() {
        return this.minRowHeight;
    }

    public void setMinRowHeight(int n) {
        this.minRowHeight = n;
    }

    public int getMaxRowHeight() {
        return this.maxRowHeight;
    }

    public void setMaxRowHeight(int n) {
        this.maxRowHeight = n;
    }

    public JTable getJTable() {
        return this.table;
    }

    public boolean isAutoResize() {
        return this.table.getAutoResizeMode() != 0;
    }

    public void setAutoResize(boolean bl) {
        if (bl) {
            this.table.setAutoResizeMode(2);
        } else {
            this.table.setAutoResizeMode(0);
        }
    }

    public ICellEditorHandler<JComponent> getCellEditorHandler() {
        return this.cellEditorHandler;
    }

    protected void setCellEditorHandler(ICellEditorHandler iCellEditorHandler) {
        this.cellEditorHandler = iCellEditorHandler;
    }

    public void scrollToSelectedCell() {
        this.doRepaint();
        this.table.scrollRectToVisible(this.table.getCellRect(Math.max(0, this.table.getSelectedRow()), Math.max(0, this.table.getSelectedColumn()), true));
    }

    public void openComboBox() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (JVxTable.this.cellEditorHandler != null && JVxTable.this.cellEditorHandler.getCellEditorComponent() instanceof JVxComboBase && !((JVxComboBase)JVxTable.this.cellEditorHandler.getCellEditorComponent()).isPopupVisible()) {
                            ((JVxComboBase)JVxTable.this.cellEditorHandler.getCellEditorComponent()).showPopup();
                        }
                    }
                });
            }
        });
    }

    public void selectNext(int n) {
        if (n == 1) {
            this.selectNextCell(true);
        } else if (n == 3) {
            this.selectNextRow(true);
        } else if (n == 2) {
            this.selectNextCellAndRow(true);
        }
    }

    public void selectPrevious(int n) {
        if (n == 1) {
            this.selectPreviousCell(true);
        } else if (n == 3) {
            this.selectPreviousRow(true);
        } else if (n == 2) {
            this.selectPreviousCellAndRow(true);
        }
    }

    public void selectNextCell(boolean bl) {
        int n = this.table.getSelectedColumn() + 1;
        if (n < this.table.getColumnCount() && this.table.getSelectedRow() >= 0) {
            this.table.setColumnSelectionInterval(n, n);
            this.scrollToSelectedCell();
        } else if (bl) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this.table);
        }
    }

    public void selectPreviousCell(boolean bl) {
        int n = this.table.getSelectedColumn() - 1;
        if (n >= 0 && this.table.getSelectedRow() >= 0) {
            this.table.setColumnSelectionInterval(n, n);
            this.scrollToSelectedCell();
        } else if (bl) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(this.table);
        }
    }

    public void selectNextCellAndRow(boolean bl) {
        int n = this.table.getSelectedColumn() + 1;
        int n2 = this.table.getSelectedRow() + 1;
        if (n < this.table.getColumnCount() && this.table.getSelectedRow() >= 0) {
            this.table.setColumnSelectionInterval(n, n);
            this.scrollToSelectedCell();
        } else if (n2 < this.table.getRowCount()) {
            this.table.setRowSelectionInterval(n2, n2);
            this.table.setColumnSelectionInterval(0, 0);
            this.scrollToSelectedCell();
        } else if (bl) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this.table);
        }
    }

    public void selectPreviousCellAndRow(boolean bl) {
        int n = this.table.getSelectedColumn() - 1;
        int n2 = this.table.getSelectedRow() - 1;
        if (n >= 0 && this.table.getSelectedRow() >= 0) {
            this.table.setColumnSelectionInterval(n, n);
            this.scrollToSelectedCell();
        } else if (n2 >= 0) {
            this.table.setRowSelectionInterval(n2, n2);
            this.table.setColumnSelectionInterval(this.table.getColumnCount() - 1, this.table.getColumnCount() - 1);
            this.scrollToSelectedCell();
        } else if (bl) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(this.table);
        }
    }

    public void selectNextRow(boolean bl) {
        int n = this.table.getSelectedRow() + 1;
        if (n < this.table.getRowCount()) {
            this.table.setRowSelectionInterval(n, n);
            this.scrollToSelectedCell();
        } else if (bl) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this.table);
        }
    }

    public void selectPreviousRow(boolean bl) {
        int n = this.table.getSelectedRow() - 1;
        if (n >= 0) {
            this.table.setRowSelectionInterval(n, n);
            this.scrollToSelectedCell();
        } else if (bl) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(this.table);
        }
    }

    private int getNumberOfRowsPerPage() {
        if (this.table.getParent() instanceof JViewport) {
            Rectangle rectangle = ((JViewport)this.table.getParent()).getViewRect();
            return Math.max(1, (rectangle.height - 1) / this.table.getRowHeight());
        }
        Rectangle rectangle = this.table.getBounds();
        return Math.max(1, (rectangle.height - 1) / this.table.getRowHeight());
    }

    public void selectNextPage(boolean bl) {
        int n = this.table.getSelectedRow();
        if (n < this.table.getRowCount() - 1) {
            if ((n += this.getNumberOfRowsPerPage()) >= this.table.getRowCount()) {
                n = this.table.getRowCount() - 1;
            }
            this.table.setRowSelectionInterval(n, n);
            this.scrollToSelectedCell();
        } else if (bl) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this.table);
        }
    }

    public void selectPreviousPage(boolean bl) {
        int n = this.table.getSelectedRow();
        if (n > 0) {
            if ((n -= this.getNumberOfRowsPerPage()) < 0) {
                n = 0;
            }
            this.table.setRowSelectionInterval(n, n);
            this.scrollToSelectedCell();
        } else if (bl) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(this.table);
        }
    }

    protected void doRepaint() {
        if (!this.ignoreEvent && this.dataBook != null && this.dataBook.isOpen()) {
            this.ignoreEvent = true;
            try {
                this.table.getRowCount();
                ((DataBookTableColumnModel)this.table.getColumnModel()).initTableColumns(true);
                int n = this.dataBook.getSelectedRow();
                if (n != this.table.getSelectedRow()) {
                    this.table.getSelectionModel().clearSelection();
                    if (n >= 0) {
                        this.table.setRowSelectionInterval(n, n);
                    }
                    if (this.table.getColumnCount() > 0 && (this.dataBook.isInserting() || this.table.getSelectedColumn() < 0)) {
                        this.table.revalidate();
                        this.table.setColumnSelectionInterval(0, 0);
                    }
                    this.scrollToSelectedCell();
                }
                if (this.isNotified) {
                    this.table.revalidate();
                    this.table.repaint();
                    this.table.getTableHeader().resizeAndRepaint();
                    JVxUtil.revalidateAllDelayed(this);
                }
                this.ignoreEvent = false;
            }
            catch (Exception exception) {
                this.ignoreEvent = false;
                ExceptionHandler.raise(exception);
            }
        }
    }

    protected String translate(String string) {
        if (this.bTranslationEnabled && this.translation != null) {
            return this.translation.translate(string);
        }
        return string;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isShowSelection() {
        return this.showSelection;
    }

    public void setShowSelection(boolean bl) {
        this.showSelection = bl;
        this.repaint();
    }

    public boolean isShowFocusRect() {
        return this.showFocusRect;
    }

    public void setShowFocusRect(boolean bl) {
        this.showFocusRect = bl;
        this.repaint();
    }

    public boolean isMouseEventOnSelectedCell() {
        return this.mouseEventOnSelectedCell;
    }

    static {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getID() == 400) {
                    focusKeyEvent = keyEvent;
                } else {
                    focusKeyEvent = null;
                    ignoreFocusEvent = false;
                }
                return false;
            }
        });
    }

    public static class StrikeThroughEmptyBorder
    extends EmptyBorder {
        protected Color lineColor;
        private boolean strikeThrough = false;

        public StrikeThroughEmptyBorder() {
            super(1, 1, 1, 1);
        }

        public boolean isStrikeThrough() {
            return this.strikeThrough;
        }

        public void setStrikeThrough(boolean bl) {
            this.strikeThrough = bl;
        }

        public Color getLineColor() {
            return this.lineColor;
        }

        public void setLineColor(Color color) {
            this.lineColor = color;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            super.paintBorder(component, graphics, n, n2, n3, n4);
            if (this.strikeThrough) {
                graphics.setColor(this.getLineColor());
                graphics.drawRect(n, n2 + n4 / 2, n3, 0);
            }
        }
    }

    public static class StrikeThroughLineBorder
    extends LineBorder {
        private boolean strikeThrough = false;

        public StrikeThroughLineBorder() {
            super(null, 1);
        }

        public boolean isStrikeThrough() {
            return this.strikeThrough;
        }

        public void setStrikeThrough(boolean bl) {
            this.strikeThrough = bl;
        }

        public void setLineColor(Color color) {
            this.lineColor = color;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            super.paintBorder(component, graphics, n, n2, n3, n4);
            if (this.strikeThrough) {
                graphics.setColor(this.lineColor);
                graphics.drawRect(n, n2 + n4 / 2, n3, 0);
            }
        }
    }

    public static class CellEditorPane
    extends JComponent
    implements Runnable,
    FocusListener {
        private static final LayoutFocusTraversalPolicy LAYOUT_POLICY = new LayoutFocusTraversalPolicy();
        private JVxTable tableControl;
        private int rowMargin;
        private int columnMargin;
        private int leftIndent;
        private JComponent leftSpacer;
        private JVxIcon icon;
        private Component cellEditorComponent;
        private Component focusComponent;
        private EventObject eventObject;
        private boolean isDirectEditor;
        private KeyEvent keyEvent;
        private MouseEvent mouseEvent;

        public CellEditorPane(JVxTable jVxTable) {
            this(jVxTable, null, null);
        }

        public CellEditorPane(JVxTable jVxTable, CellFormat cellFormat, EventObject eventObject) {
            this.tableControl = jVxTable;
            this.eventObject = eventObject;
            this.columnMargin = this.tableControl.table.getColumnModel().getColumnMargin();
            this.rowMargin = this.tableControl.table.getRowMargin();
            this.cellEditorComponent = (Component)this.tableControl.cellEditorHandler.getCellEditorComponent();
            this.isDirectEditor = this.tableControl.cellEditorHandler.getCellEditor().isDirectCellEditor();
            this.leftIndent = 0;
            this.icon = null;
            if (cellFormat != null) {
                this.leftIndent = cellFormat.getLeftIndent();
                Color color = cellFormat.getBackground();
                if (this.leftIndent > 0 && color != null) {
                    this.leftSpacer = new JLabel();
                    this.leftSpacer.setOpaque(true);
                    this.leftSpacer.setBackground(color);
                    this.add(this.leftSpacer);
                }
                this.setBackground(cellFormat.getBackground());
                if (cellFormat.getImage() != null) {
                    this.icon = new JVxIcon(((ImageIcon)cellFormat.getImage()).getImage());
                    this.icon.setBackground(color);
                    this.add(this.icon);
                }
            }
            this.add(this.cellEditorComponent);
        }

        public void focusGained(FocusEvent focusEvent) {
            this.dispatchKeyEvent();
            this.focusComponent.removeFocusListener(this);
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void run() {
            if (!this.isDirectEditor) {
                this.repaint();
                if (this.focusComponent != null) {
                    this.focusComponent.addFocusListener(this);
                    this.focusComponent.requestFocus();
                }
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            Dimension dimension;
            int n5 = this.leftIndent;
            if (this.icon == null) {
                dimension = new Dimension();
            } else {
                dimension = this.icon.getPreferredSize();
                n5 += dimension.width + 3;
            }
            int n6 = n - (this.columnMargin / 2 + 1);
            int n7 = n2 - (this.rowMargin / 2 + 1);
            int n8 = n3 + this.columnMargin + 1;
            int n9 = n4 + this.rowMargin + 1;
            Rectangle rectangle = this.tableControl.table.getVisibleRect();
            Dimension dimension2 = this.cellEditorComponent.getPreferredSize();
            dimension2.width += n5;
            if (dimension2.width > n8) {
                n8 = dimension2.width;
            }
            if (n6 + n8 > rectangle.x + rectangle.width) {
                n6 = rectangle.x + rectangle.width - n8;
            }
            if (n6 < rectangle.x) {
                n8 -= rectangle.x - n6;
                n6 = rectangle.x;
                if (n8 > rectangle.width) {
                    n8 = rectangle.width;
                }
            }
            if (dimension2.height > n9) {
                n9 = dimension2.height;
            }
            if (n7 + n9 > rectangle.y + rectangle.height) {
                n7 = rectangle.y + rectangle.height - n9;
            }
            if (n7 < rectangle.y) {
                n9 -= rectangle.y - n7;
                n7 = rectangle.y;
                if (n9 > rectangle.height) {
                    n9 = rectangle.height;
                }
            }
            super.setBounds(n6, n7, n8, n9);
            if (this.leftSpacer != null) {
                this.leftSpacer.setBounds(n - n6, n2 - n7, this.leftIndent, n4);
            }
            if (this.icon != null) {
                this.icon.setBounds(this.leftIndent + n - n6, n2 - n7, dimension.width + 3, n4);
            }
            this.cellEditorComponent.setBounds(n5, 0, n8 - n5, n9);
            this.cellEditorComponent.validate();
        }

        public void requestFocus() {
        }

        public void addNotify() {
            super.addNotify();
            this.focusComponent = LAYOUT_POLICY.getFirstComponent(this);
            if (this.eventObject instanceof KeyEvent) {
                this.keyEvent = (KeyEvent)this.eventObject;
                char c = this.keyEvent.getKeyChar();
                if (c < ' ' || c >= '\uffff' || c == '\u007f' || this.keyEvent.isAltDown()) {
                    this.keyEvent = null;
                }
            } else if (this.eventObject instanceof MouseEvent) {
                this.mouseEvent = (MouseEvent)this.eventObject;
            }
            if (this.isDirectEditor) {
                this.dispatchMouseEvent();
                this.dispatchKeyEvent();
                Container container = this.getParent();
                if (container != null) {
                    container.remove(this);
                }
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        public void removeNotify() {
            super.removeNotify();
            if (!this.isDirectEditor) {
                this.tableControl.table.repaint();
            }
        }

        private void dispatchMouseEvent() {
            if (this.focusComponent != null && this.mouseEvent != null) {
                try {
                    Point point = SwingUtilities.convertPoint(this.tableControl.table, this.mouseEvent.getPoint(), this.focusComponent);
                    this.focusComponent.dispatchEvent(new MouseEvent(this.focusComponent, 501, this.mouseEvent.getWhen(), this.mouseEvent.getModifiers(), point.x, point.y, this.mouseEvent.getClickCount(), false, this.mouseEvent.getButton()));
                    this.focusComponent.dispatchEvent(new MouseEvent(this.focusComponent, 502, this.mouseEvent.getWhen(), this.mouseEvent.getModifiers(), point.x, point.y, this.mouseEvent.getClickCount(), false, this.mouseEvent.getButton()));
                    this.focusComponent.dispatchEvent(new MouseEvent(this.focusComponent, 500, this.mouseEvent.getWhen(), this.mouseEvent.getModifiers(), point.x, point.y, this.mouseEvent.getClickCount(), false, this.mouseEvent.getButton()));
                    this.mouseEvent = null;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (throwable instanceof SilentAbortException && throwable.getCause() != null) {
                        throwable2 = throwable.getCause();
                    }
                    System.err.println("Exception in thread \"" + Thread.currentThread().getName() + " : " + throwable2.getMessage());
                }
            }
        }

        private void dispatchKeyEvent() {
            if (this.focusComponent != null && this.keyEvent != null) {
                try {
                    this.focusComponent.dispatchEvent(new KeyEvent(this.focusComponent, 401, this.keyEvent.getWhen(), this.keyEvent.getModifiers(), this.keyEvent.getKeyCode(), this.keyEvent.getKeyChar()));
                    this.focusComponent.dispatchEvent(new KeyEvent(this.focusComponent, 400, this.keyEvent.getWhen(), this.keyEvent.getModifiers(), 0, this.keyEvent.getKeyChar()));
                    this.focusComponent.dispatchEvent(new KeyEvent(this.focusComponent, 402, this.keyEvent.getWhen(), this.keyEvent.getModifiers(), this.keyEvent.getKeyCode(), this.keyEvent.getKeyChar()));
                    this.keyEvent = null;
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    if (throwable instanceof SilentAbortException && throwable.getCause() != null) {
                        throwable2 = throwable.getCause();
                    }
                    System.err.println("Exception in thread \"" + Thread.currentThread().getName() + " : " + throwable2.getMessage());
                }
            }
        }
    }

    public static class GenericTableCellHandler
    implements TableCellRenderer,
    TableCellEditor {
        private static DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
        private static StrikeThroughLineBorder strikeThroughLineBorder = new StrikeThroughLineBorder();
        private static StrikeThroughEmptyBorder strikeThroughEmptyBorder = new StrikeThroughEmptyBorder();
        private JVxTable tableControl;
        private String columnName;
        private JTableHeader tableHeader;
        private EventObject eventObject;

        public GenericTableCellHandler(JVxTable jVxTable, String string) {
            this.tableControl = jVxTable;
            this.columnName = string;
            this.tableHeader = this.tableControl.table.getTableHeader();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color;
            JVxIconRenderer jVxIconRenderer;
            int n3;
            Icon icon;
            Font font;
            Color color2;
            Object object2;
            Object object3;
            if (n < 0 || jTable == null) {
                SortDefinition sortDefinition;
                int n4;
                Serializable serializable;
                JComponent jComponent = (JComponent)this.tableHeader.getDefaultRenderer().getTableCellRendererComponent(this.tableControl.table, object, bl, bl2, n, n2);
                if (jComponent.getBorder() instanceof EmptyBorder) {
                    serializable = jComponent.getBorder().getBorderInsets(jComponent);
                    if (((Insets)serializable).top > 6 || ((Insets)serializable).bottom > 5) {
                        jComponent.setBorder(new EmptyBorder(6, 5, 5, 5));
                    }
                }
                if ((serializable = (JLabel)jComponent.getClientProperty("sortIcon")) == null) {
                    serializable = new JLabel();
                    ((JLabel)serializable).setHorizontalAlignment(4);
                    ((JLabel)serializable).setVerticalAlignment(3);
                    ((JLabel)serializable).setHorizontalTextPosition(4);
                    ((JLabel)serializable).setVerticalTextPosition(3);
                    ((JLabel)serializable).setIconTextGap(0);
                    ((JComponent)serializable).setFont(jComponent.getFont().deriveFont(0, 9.0f));
                    jComponent.putClientProperty("sortIcon", serializable);
                    jComponent.add((Component)serializable);
                }
                if ((n4 = (sortDefinition = this.tableControl.getDataBook().getSort()) == null ? -1 : ArrayUtil.indexOf(sortDefinition.getColumns(), this.columnName)) >= 0) {
                    ((JLabel)serializable).setText(String.valueOf(n4 + 1));
                    if (sortDefinition.isAscending().length <= n4 || sortDefinition.isAscending()[n4]) {
                        ((JLabel)serializable).setIcon(JVxUtil.getIcon("/com/sibvisions/rad/ui/swing/ext/images/up.png"));
                    } else {
                        ((JLabel)serializable).setIcon(JVxUtil.getIcon("/com/sibvisions/rad/ui/swing/ext/images/down.png"));
                    }
                } else {
                    ((JLabel)serializable).setText(null);
                    ((JLabel)serializable).setIcon(null);
                }
                if (jTable != null) {
                    Insets insets = jComponent.getInsets();
                    Rectangle rectangle = this.tableHeader.getHeaderRect(n2);
                    ((Component)serializable).setBounds(insets.left, insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
                }
                return jComponent;
            }
            bl2 = this.tableControl.table.getSelectionModel().getMinSelectionIndex() == n && this.tableControl.table.getColumnModel().getSelectionModel().getMinSelectionIndex() == n2;
            IDataBook iDataBook = this.tableControl.getDataBook();
            IChangeableDataRow iChangeableDataRow = null;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            JComponent jComponent = null;
            try {
                object3 = iDataBook.getRowDefinition().getColumnDefinition(this.columnName);
                if (!this.tableControl.isEnabled()) {
                    bl4 = true;
                } else if (!iDataBook.isReadOnly() && this.tableControl.isEnabled()) {
                    bl4 = ((ColumnDefinition)object3).isReadOnly();
                    bl5 = !((ColumnDefinition)object3).isNullable();
                }
                ICellRenderer iCellRenderer = ((ColumnDefinition)object3).getDataType().getCellRenderer();
                if (iCellRenderer == null) {
                    object2 = this.getCellEditor();
                    if (object2 instanceof IResource) {
                        object2 = (ICellEditor)((IResource)object2).getResource();
                    }
                    if (object2 instanceof ICellRenderer) {
                        iCellRenderer = (ICellRenderer)object2;
                    }
                }
                iChangeableDataRow = iDataBook.getDataRow(n);
                if (iCellRenderer != null) {
                    jComponent = iCellRenderer.getCellRendererComponent(jTable, iDataBook, n, iChangeableDataRow, this.columnName, bl, bl2);
                }
                bl3 = iChangeableDataRow.isDeleting();
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            if (jComponent == null) {
                jComponent = (JComponent)defaultRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (jTable.getColumnModel().getColumn(n2).getModelIndex() < 0) {
                    jComponent.setBackground(JVxUtil.getSystemColor("IControl.invalidEditorBackground"));
                    return jComponent;
                }
            }
            object3 = null;
            if (this.tableControl.cellFormatter != null) {
                try {
                    object3 = this.tableControl.cellFormatter.getCellFormat(iDataBook, iDataBook.getDataPage(), iDataBook.getDataRow(n), this.columnName, n, n2);
                }
                catch (ModelException modelException) {
                    // empty catch block
                }
            }
            if (object3 == null) {
                object2 = null;
                color2 = null;
                font = null;
                icon = null;
                n3 = 0;
            } else {
                object2 = ((CellFormat)object3).getBackground();
                color2 = ((CellFormat)object3).getForeground();
                font = ((CellFormat)object3).getFont();
                icon = ((CellFormat)object3).getImage();
                n3 = ((CellFormat)object3).getLeftIndent();
            }
            JVxRendererContainer jVxRendererContainer = (JVxRendererContainer)jComponent.getClientProperty("rendererContainer");
            if (jVxRendererContainer == null) {
                jVxRendererContainer = new JVxRendererContainer();
                ((JVxBorderLayout)jVxRendererContainer.getLayout()).setHorizontalGap(3);
                jComponent.setOpaque(false);
                jVxIconRenderer = new JVxIconRenderer();
                jVxIconRenderer.setOpaque(false);
                jVxRendererContainer.add((Component)jVxIconRenderer, "West");
                jComponent.putClientProperty("rendererContainer", jVxRendererContainer);
            } else {
                jVxIconRenderer = (JVxIconRenderer)jVxRendererContainer.getComponent(0);
            }
            ((JVxBorderLayout)jVxRendererContainer.getLayout()).getMargins().left = n3;
            if (jComponent.getParent() != jVxRendererContainer) {
                jVxRendererContainer.add((Component)jComponent, "Center");
                jComponent.setOpaque(false);
            }
            jVxIconRenderer.setVisible(icon != null);
            if (icon == null) {
                jVxIconRenderer.setImage(null);
            } else {
                jVxIconRenderer.setImage(((ImageIcon)icon).getImage());
            }
            if (object2 == null) {
                if (bl4) {
                    object2 = JVxUtil.getSystemColor("IControl.readOnlyBackground");
                } else if (bl5) {
                    object2 = JVxUtil.getSystemColor("IControl.mandatoryBackground");
                }
            } else if (!this.tableControl.isEnabled()) {
                object2 = JVxUtil.getAverageColor((Color)object2, JVxUtil.getSystemColor("IControl.readOnlyBackground"));
            }
            if (font == null) {
                font = this.tableControl.table.getFont();
            }
            boolean bl6 = jTable.hasFocus();
            if (bl && this.tableControl.showSelection) {
                Color color3;
                if (bl6) {
                    color = JVxUtil.getSystemColor("IControl.activeSelectionForeground");
                    color3 = JVxUtil.getSystemColor("IControl.activeSelectionBackground");
                } else {
                    color = JVxUtil.getSystemColor("IControl.inactiveSelectionForeground");
                    color3 = JVxUtil.getSystemColor("IControl.inactiveSelectionBackground");
                }
                jVxRendererContainer.setForeground(JVxUtil.getAverageColor(color2, color));
                jComponent.setForeground(JVxUtil.getAverageColor(color2, color));
                jVxRendererContainer.setBackground(JVxUtil.getAverageColor((Color)object2, color3));
            } else {
                jVxRendererContainer.setForeground(color2);
                jComponent.setForeground(color2);
                if (n % 2 == 0) {
                    jVxRendererContainer.setBackground((Color)object2);
                } else {
                    color = JVxUtil.getSystemColor("IControl.alternateBackground");
                    if (object2 == null) {
                        jVxRendererContainer.setBackground(JVxUtil.getAverageColor(this.tableControl.table.getBackground(), JVxUtil.getAverageColor((Color)object2, JVxUtil.getAverageColor((Color)object2, color))));
                    } else {
                        jVxRendererContainer.setBackground(JVxUtil.getAverageColor((Color)object2, JVxUtil.getAverageColor((Color)object2, JVxUtil.getAverageColor((Color)object2, color))));
                    }
                }
            }
            jVxRendererContainer.setFont(font);
            jComponent.setFont(font);
            color = bl6 ? this.tableControl.table.getForeground() : JVxUtil.getAverageColor(JVxUtil.getAverageColor(this.tableControl.table.getForeground(), this.tableControl.table.getGridColor()), this.tableControl.table.getGridColor());
            if (bl2 && this.tableControl.showFocusRect) {
                strikeThroughLineBorder.setLineColor(color);
                strikeThroughLineBorder.setStrikeThrough(bl3);
                jVxRendererContainer.setBorder(strikeThroughLineBorder);
            } else {
                strikeThroughEmptyBorder.setLineColor(color);
                strikeThroughEmptyBorder.setStrikeThrough(bl3);
                jVxRendererContainer.setBorder(strikeThroughEmptyBorder);
            }
            return jVxRendererContainer;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.tableControl.ignoreEvent = true;
            try {
                IDataBook iDataBook = this.tableControl.getDataBook();
                if (this.tableControl.table.getSelectedColumn() != n2) {
                    this.tableControl.table.setColumnSelectionInterval(n2, n2);
                }
                iDataBook.setSelectedRow(n);
                this.tableControl.ignoreEvent = false;
                this.tableControl.doRepaint();
                this.tableControl.setCellEditorHandler(this.getCellEditor().createCellEditorHandler(this.tableControl, iDataBook, this.columnName));
                this.tableControl.getCellEditorHandler().cancelEditing();
                CellFormat cellFormat = null;
                if (this.tableControl.getCellFormatter() != null) {
                    try {
                        cellFormat = this.tableControl.getCellFormatter().getCellFormat(iDataBook, iDataBook.getDataPage(), iDataBook, this.columnName, iDataBook.getSelectedRow(), -1);
                    }
                    catch (ModelException modelException) {
                        // empty catch block
                    }
                }
                this.tableControl.ignoreMousePressed = true;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        GenericTableCellHandler.this.tableControl.ignoreMousePressed = false;
                    }
                });
                return new CellEditorPane(this.tableControl, cellFormat, this.eventObject);
            }
            catch (ModelException modelException) {
                this.tableControl.ignoreEvent = false;
                this.tableControl.notifyRepaint();
                ExceptionHandler.raise(modelException);
                return null;
            }
        }

        public Object getCellEditorValue() {
            return null;
        }

        public boolean isCellEditable(EventObject eventObject) {
            this.eventObject = eventObject;
            try {
                ICellEditor iCellEditor = this.getCellEditor();
                if (this.eventObject instanceof MouseEvent) {
                    if (iCellEditor instanceof IInplaceCellEditor) {
                        Point point = ((MouseEvent)this.eventObject).getPoint();
                        int n = this.tableControl.table.rowAtPoint(point);
                        Rectangle rectangle = this.tableControl.table.getCellRect(n, this.tableControl.table.columnAtPoint(point), true);
                        if (rectangle.contains(point.x, point.y)) {
                            rectangle.x = rectangle.x + rectangle.width - 16;
                            rectangle.width = 16;
                            if (rectangle.contains(point.x, point.y) && iCellEditor instanceof IComboCellEditor) {
                                this.tableControl.openComboBox();
                                return true;
                            }
                            if (((IInplaceCellEditor)iCellEditor).getPreferredEditorMode() == 1) {
                                if (iCellEditor instanceof IComboCellEditor && ((IComboCellEditor)iCellEditor).isAutoOpenPopup()) {
                                    this.tableControl.openComboBox();
                                }
                                return true;
                            }
                        }
                    }
                    if (!iCellEditor.isDirectCellEditor() && ((MouseEvent)this.eventObject).getClickCount() == 1) {
                        return false;
                    }
                }
            }
            catch (ModelException modelException) {
                ExceptionHandler.raise(modelException);
            }
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return false;
        }

        public boolean stopCellEditing() {
            this.tableControl.editingComplete("FOCUS_LOST");
            return true;
        }

        public void cancelCellEditing() {
            this.tableControl.editingComplete("ESCAPE_KEY");
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            Component component = this.tableControl.table.getEditorComponent();
            if (component != null && component.getParent() == null) {
                this.tableControl.cancelEditing();
                this.tableControl.table.editingCanceled(null);
                this.tableControl.table.repaint();
                if (!this.tableControl.table.hasFocus()) {
                    this.tableControl.table.requestFocus();
                }
            }
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        }

        private ICellEditor getCellEditor() throws ModelException {
            IDataType iDataType = this.tableControl.getDataBook().getRowDefinition().getColumnDefinition(this.columnName).getDataType();
            ICellEditor iCellEditor = iDataType.getCellEditor();
            if (iCellEditor == null) {
                iCellEditor = JVxUtil.getDefaultCellEditor(iDataType.getTypeClass());
            }
            return iCellEditor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataBookTableColumnModel
    extends DefaultTableColumnModel
    implements MouseListener {
        private JVxTable tableControl;
        private int rowHeight;
        private boolean calculateHeightAndWidth = true;
        private ColumnView columnView = null;
        private int columnViewCount = 0;
        private boolean ignoreSetSelectedColumn = false;
        private boolean ignorePropertyChange = true;

        public DataBookTableColumnModel(JVxTable jVxTable) {
            this.tableControl = jVxTable;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            block23: {
                if (!this.tableControl.isSortOnHeaderEnabled() || !this.tableControl.isEnabled()) {
                    return;
                }
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                int n3 = this.getColumnIndexAtX(n);
                Rectangle rectangle = this.tableControl.table.getTableHeader().getHeaderRect(n3);
                if (n2 >= rectangle.y + 1 && n2 <= rectangle.y + rectangle.height - 2) {
                    if (n >= rectangle.x + 3 && n <= rectangle.x + rectangle.width - 6) {
                        boolean bl;
                        String string = (String)this.getColumn(n3).getIdentifier();
                        IDataBook iDataBook = this.tableControl.getDataBook();
                        SortDefinition sortDefinition = iDataBook.getSort();
                        boolean bl2 = this.tableControl.table.hasFocus();
                        boolean bl3 = bl = n3 != Math.max(0, this.tableControl.table.getSelectedColumn());
                        if (!bl2) {
                            this.tableControl.table.requestFocus();
                        }
                        if (bl) {
                            this.tableControl.table.setColumnSelectionInterval(n3, n3);
                        }
                        if (this.getColumn(n3).getModelIndex() >= 0) {
                            try {
                                if ((mouseEvent.getModifiers() & 0x410) != 0 && mouseEvent.isControlDown() && sortDefinition != null && sortDefinition.getColumns().length > 0) {
                                    String[] stringArray = sortDefinition.getColumns();
                                    boolean[] blArray = sortDefinition.isAscending();
                                    int n4 = ArrayUtil.indexOf(stringArray, string);
                                    if (n4 < 0) {
                                        iDataBook.setSort(new SortDefinition(ArrayUtil.add(stringArray, string), ArrayUtil.add(blArray, true)));
                                    } else if (blArray.length <= n4) {
                                        boolean[] blArray2 = new boolean[stringArray.length];
                                        System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
                                        blArray2[n4] = false;
                                        iDataBook.setSort(new SortDefinition(stringArray, blArray2));
                                    } else if (blArray[n4]) {
                                        blArray[n4] = false;
                                        iDataBook.setSort(new SortDefinition(stringArray, blArray));
                                    } else if (stringArray.length > 1) {
                                        iDataBook.setSort(new SortDefinition((String[])ArrayUtil.remove(stringArray, n4), ArrayUtil.remove(blArray, n4)));
                                    } else {
                                        iDataBook.setSort(null);
                                    }
                                    break block23;
                                }
                                if ((mouseEvent.getModifiers() & 0x410) == 0) break block23;
                                if (sortDefinition == null || sortDefinition.getColumns().length != 1 || !string.equals(sortDefinition.getColumns()[0])) {
                                    iDataBook.setSort(new SortDefinition(new String[]{string}, new boolean[]{true}));
                                    break block23;
                                }
                                if (sortDefinition.isAscending().length == 0 || sortDefinition.isAscending()[0]) {
                                    iDataBook.setSort(new SortDefinition(new String[]{string}, new boolean[]{false}));
                                    break block23;
                                }
                                iDataBook.setSort(null);
                            }
                            catch (ModelException modelException) {
                                ExceptionHandler.raise(modelException);
                            }
                        }
                    } else if (mouseEvent.getClickCount() == 2) {
                        if (n < rectangle.x + 3) {
                            --n3;
                        }
                        if (n3 >= 0) {
                            TableColumn tableColumn = (TableColumn)this.tableColumns.get(n3);
                            this.tableControl.getDataBook().getRowDefinition().getColumnDefinition(tableColumn.getModelIndex()).setWidth(0);
                            this.initTableColumns(true);
                            this.fireColumnMarginChanged();
                        }
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.ignorePropertyChange = false;
            this.tableControl.lastColumnWidth = this.getColumn(this.getColumnCount() - 1).getWidth();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.ignorePropertyChange = true;
        }

        @Override
        public void addColumn(TableColumn tableColumn) {
            try {
                Object object = tableColumn.getIdentifier();
                if (object instanceof String) {
                    int n = this.tableControl.getDataBook().getRowDefinition().getColumnDefinitionIndex((String)object);
                    if (n >= 0) {
                        tableColumn.setModelIndex(n);
                        this.addColumnIntern((String)object, tableColumn);
                    }
                } else {
                    int n = tableColumn.getModelIndex();
                    if (n >= 0 && n < this.tableControl.getDataBook().getRowDefinition().getColumnCount()) {
                        object = this.tableControl.getDataBook().getRowDefinition().getColumnDefinition(n).getName();
                        tableColumn.setIdentifier(object);
                        this.addColumnIntern((String)object, tableColumn);
                    }
                }
            }
            catch (ModelException modelException) {
                // empty catch block
            }
            throw new IllegalArgumentException("The given TableColumn is not allowed!");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void moveColumn(int n, int n2) {
            this.columnView.moveColumnName(n, n2);
            this.ignoreSetSelectedColumn = true;
            try {
                super.moveColumn(n, n2);
                Object var4_3 = null;
                this.ignoreSetSelectedColumn = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.ignoreSetSelectedColumn = false;
                throw throwable;
            }
        }

        @Override
        public void removeColumn(TableColumn tableColumn) {
            int n = this.tableColumns.indexOf(tableColumn);
            if (n >= 0) {
                this.columnView.removeColumnName(n);
                super.removeColumn(tableColumn);
            }
        }

        @Override
        public TableColumn getColumn(int n) {
            this.initTableColumns(false);
            return super.getColumn(n);
        }

        @Override
        public int getColumnCount() {
            return this.columnViewCount;
        }

        @Override
        public int getColumnIndex(Object object) {
            int n = this.tableControl.getDataBook().getRowDefinition().getColumnDefinitionIndex((String)object);
            if (n < 0) {
                throw new IllegalArgumentException("Identifier not found");
            }
            return n;
        }

        @Override
        public Enumeration<TableColumn> getColumns() {
            this.initTableColumns(false);
            return super.getColumns();
        }

        @Override
        public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            super.addColumnModelListener(tableColumnModelListener);
            if (tableColumnModelListener instanceof JTableHeader) {
                ((JTableHeader)tableColumnModelListener).addMouseListener(this);
            }
        }

        @Override
        public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            if (tableColumnModelListener instanceof JTableHeader) {
                ((JTableHeader)tableColumnModelListener).removeMouseListener(this);
            }
            super.removeColumnModelListener(tableColumnModelListener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            if (!this.ignorePropertyChange && propertyChangeEvent.getPropertyName() == "width") {
                TableColumn tableColumn = (TableColumn)propertyChangeEvent.getSource();
                int n = (Integer)propertyChangeEvent.getNewValue();
                tableColumn.setMaxWidth(Integer.MAX_VALUE - n);
                this.tableControl.getDataBook().getRowDefinition().getColumnDefinition(tableColumn.getModelIndex()).setWidth(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!this.ignoreSetSelectedColumn && this.tableControl.isEnabled()) {
                block6: {
                    int n = this.tableControl.table.getSelectedColumn();
                    if (n < 0 || this.getColumn(n).getModelIndex() >= 0) {
                        String string = n < 0 ? null : (String)this.getColumn(n).getIdentifier();
                        boolean bl = this.tableControl.ignoreEvent;
                        try {
                            try {
                                this.tableControl.ignoreEvent = true;
                                this.tableControl.getDataBook().setSelectedColumn(string);
                            }
                            catch (ModelException modelException) {
                                ExceptionHandler.raise(modelException);
                                Object var7_6 = null;
                                this.tableControl.ignoreEvent = bl;
                                break block6;
                            }
                            Object var7_5 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_7 = null;
                            this.tableControl.ignoreEvent = bl;
                            throw throwable;
                        }
                        this.tableControl.ignoreEvent = bl;
                    }
                }
                super.valueChanged(listSelectionEvent);
            }
        }

        private void addColumnIntern(String string, TableColumn tableColumn) throws ModelException {
            this.columnView.addColumnNames(string);
            super.addColumn(tableColumn);
        }

        private TableColumn findOrCreateTableColumn(String string, int n) {
            int n2 = this.tableControl.getDataBook().getRowDefinition().getColumnDefinitionIndex(string);
            ColumnDefinition columnDefinition = n2 < 0 ? null : this.tableControl.getDataBook().getRowDefinition().getColumnDefinition(n2);
            TableColumn tableColumn = null;
            for (int i = 0; i < this.tableColumns.size() && tableColumn == null; ++i) {
                TableColumn tableColumn2 = (TableColumn)this.tableColumns.get(i);
                if (tableColumn2.getModelIndex() != n2 || !string.equals(tableColumn2.getIdentifier())) continue;
                tableColumn = tableColumn2;
                this.tableColumns.remove(i);
            }
            if (tableColumn == null) {
                tableColumn = new TableColumn(n2);
                tableColumn.setIdentifier(string);
                GenericTableCellHandler genericTableCellHandler = new GenericTableCellHandler(this.tableControl, string);
                tableColumn.setHeaderRenderer(genericTableCellHandler);
                tableColumn.setCellRenderer(genericTableCellHandler);
                tableColumn.setCellEditor(genericTableCellHandler);
                this.calculateHeightAndWidth = true;
            }
            if (columnDefinition == null) {
                tableColumn.setHeaderValue(this.tableControl.translate(string));
                tableColumn.setResizable(true);
            } else {
                tableColumn.setHeaderValue(this.tableControl.translate(columnDefinition.getLabel()));
                tableColumn.setResizable(columnDefinition.isResizable());
                if (!this.calculateHeightAndWidth && columnDefinition.getWidth() == 0 && tableColumn.getMaxWidth() != Integer.MAX_VALUE) {
                    this.calculateHeightAndWidth = true;
                }
                if (this.calculateHeightAndWidth) {
                    if (columnDefinition.getWidth() <= 0) {
                        Dimension dimension;
                        if (this.tableControl.isTableHeaderVisible()) {
                            dimension = tableColumn.getHeaderRenderer().getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, -1, n).getPreferredSize();
                            dimension.width += 20;
                        } else {
                            dimension = new Dimension(20, 0);
                        }
                        tableColumn.setMaxWidth(Integer.MAX_VALUE);
                        tableColumn.setPreferredWidth(dimension.width);
                        tableColumn.setWidth(dimension.width);
                        this.calculateWidthAndHeightFromData(tableColumn, true);
                    } else {
                        this.calculateWidthAndHeightFromData(tableColumn, false);
                        tableColumn.setWidth(columnDefinition.getWidth());
                        tableColumn.setPreferredWidth(columnDefinition.getWidth());
                        tableColumn.setMaxWidth(Integer.MAX_VALUE - columnDefinition.getWidth());
                    }
                }
            }
            return tableColumn;
        }

        private void calculateWidthAndHeightFromData(TableColumn tableColumn, boolean bl) {
            try {
                int n = this.tableControl.table.getRowCount();
                if (n == 0 && !this.tableControl.getDataBook().isAllFetched()) {
                    this.tableControl.getDataBook().getDataRow(9);
                }
                int n2 = 0;
                n = this.tableControl.getDataBook().getRowCount();
                int n3 = tableColumn.getPreferredWidth();
                for (int i = 0; i < n && n2 < 20; ++i) {
                    Object object = this.tableControl.getDataBook().getDataRow(i).getValue(tableColumn.getModelIndex());
                    if (object == null) continue;
                    Component component = tableColumn.getCellRenderer().getTableCellRendererComponent(this.tableControl.table, object, false, false, i, tableColumn.getModelIndex());
                    Dimension dimension = component.getPreferredSize();
                    if (dimension.width + 10 > n3) {
                        n3 = dimension.width + 10;
                    }
                    if (dimension.height > this.rowHeight && this.rowHeight < this.tableControl.maxRowHeight) {
                        this.rowHeight = Math.min(dimension.height, this.tableControl.maxRowHeight);
                    }
                    ++n2;
                }
                if (bl && n2 > 0) {
                    tableColumn.setPreferredWidth(n3);
                    tableColumn.setWidth(n3);
                }
            }
            catch (Exception exception) {
                ExceptionHandler.show(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initTableColumns(boolean bl) {
            int n;
            this.tableControl.table.getRowCount();
            if (bl || this.columnView == null) {
                int n2;
                if (this.tableControl.cellEditorHandler != null) {
                    this.tableControl.editingComplete("FOCUS_LOST");
                }
                try {
                    this.columnView = this.tableControl.getColumnView();
                }
                catch (Exception exception) {
                    this.columnView = new ColumnView(new String[0]);
                }
                for (int i = 0; i < this.tableColumns.size(); ++i) {
                    ((TableColumn)this.tableColumns.get(i)).removePropertyChangeListener(this);
                }
                if (this.calculateHeightAndWidth) {
                    this.rowHeight = this.tableControl.getMinRowHeight();
                }
                this.columnViewCount = this.columnView.getColumnCount();
                if (this.tableControl.dataBook != null && !this.tableControl.dataBook.isOpen()) {
                    this.columnViewCount = 0;
                }
                Vector<TableColumn> vector = new Vector<TableColumn>();
                for (n2 = 0; n2 < this.columnViewCount; ++n2) {
                    vector.add(this.findOrCreateTableColumn(this.columnView.getColumnName(n2), n2));
                }
                if (this.calculateHeightAndWidth && this.tableControl.rowHeight >= 0) {
                    this.rowHeight = this.tableControl.rowHeight;
                }
                this.tableColumns = vector;
                this.totalColumnWidth = -1;
                this.calculateHeightAndWidth = false;
                this.tableControl.table.doLayout();
                for (n2 = 0; n2 < this.tableColumns.size(); ++n2) {
                    ((TableColumn)this.tableColumns.get(n2)).addPropertyChangeListener(this);
                }
                if (this.tableControl.table.getRowHeight() != this.rowHeight) {
                    this.tableControl.table.setRowHeight(this.rowHeight);
                }
            }
            try {
                n = this.columnView.getColumnNameIndex(this.tableControl.getDataBook().getSelectedColumn());
            }
            catch (Exception exception) {
                n = -1;
            }
            if (n != this.getSelectionModel().getMinSelectionIndex()) {
                this.ignoreSetSelectedColumn = true;
                try {
                    this.getSelectionModel().setSelectionInterval(n, n);
                    Object var5_8 = null;
                    this.ignoreSetSelectedColumn = false;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    this.ignoreSetSelectedColumn = false;
                    throw throwable;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataBookTableModel
    extends AbstractTableModel {
        private JVxTable tableControl;
        private JTable table;
        private IDataBook dataBook;

        public DataBookTableModel(JVxTable jVxTable, IDataBook iDataBook) {
            this.tableControl = jVxTable;
            this.table = this.tableControl.getJTable();
            this.dataBook = iDataBook;
        }

        @Override
        public String getColumnName(int n) {
            return this.dataBook.getRowDefinition().getColumnDefinition(n).getName();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 >= 0 && this.tableControl.isEditable() && !this.dataBook.isReadOnly() && !this.dataBook.getRowDefinition().getColumnDefinition(n2).isReadOnly();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getRowCount() {
            if (!this.dataBook.isOpen()) return 0;
            try {
                int n;
                Serializable serializable;
                if (!this.dataBook.isOutOfSync() && this.dataBook.isAllFetched()) return this.dataBook.getRowCount();
                if (this.table.getParent() instanceof JViewport) {
                    serializable = ((JViewport)this.table.getParent()).getViewRect();
                    n = (((Rectangle)serializable).y + ((Rectangle)serializable).height) / this.table.getRowHeight() + 1;
                } else {
                    serializable = this.table.getBounds();
                    n = ((Rectangle)serializable).height / this.table.getRowHeight() + 1;
                }
                if (!this.dataBook.isOutOfSync() && n < this.dataBook.getRowCount()) return this.dataBook.getRowCount();
                serializable = JVxUtil.getGlobalCursor(this.table);
                boolean bl = serializable == null || ((Cursor)serializable).getType() != 3;
                JVxUtil.setGlobalCursor(this.table, Cursor.getPredefinedCursor(3));
                try {
                    this.dataBook.getDataRow(n);
                    this.table.revalidate();
                    Object var5_5 = null;
                    if (!bl) return this.dataBook.getRowCount();
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    if (!bl) throw throwable;
                    JVxUtil.setGlobalCursor(this.table, null);
                    throw throwable;
                }
                JVxUtil.setGlobalCursor(this.table, null);
                return this.dataBook.getRowCount();
            }
            catch (Exception exception) {
                ExceptionHandler.show(exception);
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return this.dataBook.getRowDefinition().getColumnCount();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            try {
                return this.dataBook.getRowDefinition().getColumnDefinition(n2).getDataType().convertToString(this.dataBook.getDataRow(n).getValue(this.getColumnName(n2)));
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

