/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.swing.ext.JVxConstants;
import com.sibvisions.rad.ui.swing.ext.JVxUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class JVxIcon
extends JComponent
implements JVxConstants {
    private Image image;
    private int iImageWidth = 0;
    private int iImageHeight = 0;
    private int iHorizontalAlign = 0;
    private int iVerticalAlign = 0;

    public JVxIcon() {
        this(null);
    }

    public JVxIcon(Image image) {
        this.setImage(image);
    }

    public void paintComponent(Graphics graphics) {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        if (this.isBackgroundSet()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (this.image != null) {
            int n;
            int n2;
            int n3;
            int n4;
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            switch (this.iHorizontalAlign) {
                case 2: {
                    n4 = insets.left;
                    n3 = this.iImageWidth;
                    break;
                }
                case 0: {
                    n4 = insets.left + (dimension.width - this.iImageWidth) / 2;
                    n3 = this.iImageWidth;
                    break;
                }
                case 4: {
                    n4 = insets.left + dimension.width - this.iImageWidth;
                    n3 = this.iImageWidth;
                    break;
                }
                default: {
                    n4 = insets.left;
                    n3 = dimension.width;
                }
            }
            switch (this.iVerticalAlign) {
                case 1: {
                    n2 = insets.top;
                    n = this.iImageHeight;
                    break;
                }
                case 0: {
                    n2 = insets.top + (dimension.height - this.iImageHeight) / 2;
                    n = this.iImageHeight;
                    break;
                }
                case 3: {
                    n2 = insets.top + dimension.height - this.iImageHeight;
                    n = this.iImageHeight;
                    break;
                }
                default: {
                    n2 = insets.top;
                    n = dimension.height;
                }
            }
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.drawImage(this.image, n4, n2, n3, n, this);
        }
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets insets = this.getInsets();
        return new Dimension(this.iImageWidth + insets.left + insets.right, this.iImageHeight + insets.top + insets.bottom);
    }

    public void setImage(Image image) {
        this.image = image;
        int n = this.iImageHeight;
        int n2 = this.iImageWidth;
        if (this.image == null) {
            this.iImageHeight = 0;
            this.iImageWidth = 0;
        } else {
            this.iImageHeight = image.getHeight(this);
            this.iImageWidth = image.getWidth(this);
        }
        this.invalidate();
        if (!(n == this.iImageHeight && n2 == this.iImageWidth || this.isPreferredSizeSet())) {
            JVxUtil.revalidateAllDelayed(this);
        }
        this.repaint();
    }

    public void setHorizontalAlignment(int n) {
        if (n == 2 || n == 0 || n == 4 || n == 100) {
            if (n != this.iHorizontalAlign) {
                this.iHorizontalAlign = n;
                this.invalidate();
                this.repaint();
            }
        } else {
            throw new IllegalArgumentException("horizontalAlignment");
        }
    }

    public int getHorizontalAlignment() {
        return this.iHorizontalAlign;
    }

    public void setVerticalAlignment(int n) {
        if (n == 1 || n == 0 || n == 3 || n == 100) {
            if (n != this.iVerticalAlign) {
                this.iVerticalAlign = n;
                this.invalidate();
                this.repaint();
            }
        } else {
            throw new IllegalArgumentException("verticalAlignment");
        }
    }

    public int getVerticalAlignment() {
        return this.iVerticalAlign;
    }
}

