/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.awt.impl;

import com.sibvisions.rad.ui.awt.impl.AwtComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.rad.ui.IComponent;
import javax.rad.ui.IContainer;
import javax.rad.ui.ILayout;
import javax.rad.ui.IResource;
import javax.rad.ui.container.IToolBar;
import javax.rad.ui.menu.IMenuBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwtContainer<C extends Container>
extends AwtComponent<C>
implements IContainer {
    private ILayout layout = null;
    private List<IComponent> components = new ArrayList<IComponent>(4);

    protected AwtContainer(C c) {
        super(c);
    }

    @Override
    public ILayout getLayout() {
        return this.layout;
    }

    @Override
    public void setLayout(ILayout iLayout) {
        if (iLayout == null) {
            this.setLayoutIntern(null);
        } else {
            this.setLayoutIntern((LayoutManager)iLayout.getResource());
        }
        this.layout = iLayout;
    }

    @Override
    public void add(IComponent iComponent) {
        this.add(iComponent, null, -1);
    }

    @Override
    public void add(IComponent iComponent, Object object) {
        this.add(iComponent, object, -1);
    }

    @Override
    public void add(IComponent iComponent, int n) {
        this.add(iComponent, null, n);
    }

    @Override
    public void add(IComponent iComponent, Object object, int n) {
        this.checkAdd(iComponent, object, n);
        if (iComponent.getParent() != null) {
            iComponent.getParent().remove(iComponent);
        }
        Object object2 = object instanceof IResource ? ((IResource)object).getResource() : object;
        if (n < 0) {
            this.components.add(iComponent);
        } else {
            this.components.add(n, iComponent);
        }
        IContainer iContainer = iComponent.getParent();
        iComponent.setParent(this);
        try {
            this.addIntern((Component)iComponent.getResource(), object2, n);
        }
        catch (RuntimeException runtimeException) {
            this.removeIntern((Component)iComponent.getResource());
            this.components.remove(iComponent);
            iComponent.setParent(iContainer);
            throw runtimeException;
        }
        catch (Error error) {
            this.removeIntern((Component)iComponent.getResource());
            this.components.remove(iComponent);
            iComponent.setParent(iContainer);
            throw error;
        }
    }

    @Override
    public void remove(int n) {
        Component component = (Component)this.components.get(n).getResource();
        boolean bl = component.isVisible();
        component.setVisible(false);
        this.removeIntern(component);
        if (bl && !component.isVisible()) {
            component.setVisible(bl);
        }
        IComponent iComponent = this.components.remove(n);
        iComponent.setParent(null);
        ((Container)this.resource).repaint();
    }

    @Override
    public void remove(IComponent iComponent) {
        if (iComponent.getParent() == this) {
            this.remove(this.components.indexOf(iComponent));
        }
    }

    @Override
    public void removeAll() {
        while (this.components.size() > 0) {
            this.remove(this.components.size() - 1);
        }
    }

    @Override
    public int getComponentCount() {
        return this.components.size();
    }

    @Override
    public IComponent getComponent(int n) {
        return this.components.get(n);
    }

    @Override
    public int indexOf(IComponent iComponent) {
        return this.components.indexOf(iComponent);
    }

    protected void checkAdd(IComponent iComponent, Object object, int n) {
        if (!(this instanceof IToolBar) && iComponent instanceof IToolBar) {
            throw new IllegalArgumentException("It's not supported to 'add' an IToolBar. Use 'addToolBar'!");
        }
        if (iComponent instanceof IMenuBar) {
            throw new IllegalArgumentException("It's not supported to 'add' an IMenuBar. Use 'setMenuBar'!");
        }
    }

    protected void setLayoutIntern(LayoutManager layoutManager) {
        ((Container)this.resource).setLayout(layoutManager);
    }

    protected void addIntern(Component component, Object object, int n) {
        ((Container)this.resource).add(component, object, n);
    }

    protected void removeIntern(Component component) {
        ((Container)this.resource).remove(component);
    }
}

