/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server.security.ntlm;

import com.sibvisions.rad.server.config.Configuration;
import com.sibvisions.rad.server.security.ntlm.NtlmAuthInfo;
import com.sibvisions.rad.server.security.ntlm.NtlmSession;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.xml.XmlNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.rad.server.IConfiguration;
import javax.rad.server.SessionContext;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmChallenge;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbSession;
import jcifs.util.Base64;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;

public final class NtlmHelper {
    private static final int DEFAULT_ALIVEDELAY = 15000;
    private ILogger log = LoggerFactory.getInstance(this.getClass());
    private static NtlmHelper instance = null;
    private ArrayList<String> alDomainController;
    private UniAddress uaCurrentDomainController;
    private Object oSync = new Object();
    private String sApplicationName = null;
    private String sCurrentConfig = null;
    private int iCurrentDomainController;
    private boolean bLoadBalance;

    private NtlmHelper() {
    }

    public static synchronized NtlmHelper getInstance() {
        if (instance == null) {
            instance = new NtlmHelper();
        }
        return instance;
    }

    public void setApplicatioName(String string) {
        this.sApplicationName = string;
    }

    private void setConfig() throws Exception {
        IConfiguration iConfiguration = SessionContext.getCurrentSessionConfig();
        List<XmlNode> list = iConfiguration == null ? Configuration.getApplicationZone(this.sApplicationName).getNodes("/application/ntlm/init-param") : iConfiguration.getNodes("/application/ntlm/init-param");
        if (this.sCurrentConfig == null || !this.sCurrentConfig.equals(list.toString())) {
            int n;
            Object object;
            Object object2;
            Object object3;
            Config.setProperty((String)"jcifs.netbios.cachePolicy", (String)"1200");
            if (list != null) {
                int n2 = list.size();
                for (int i = 0; i < n2; ++i) {
                    object3 = list.get(i);
                    object2 = ((XmlNode)object3).getNode("param-name");
                    object = ((XmlNode)object3).getNode("param-value");
                    if (object2 != null && object != null) {
                        Config.setProperty((String)((XmlNode)object2).getValue(), (String)((XmlNode)object).getValue());
                        continue;
                    }
                    this.log.debug("Parameter: '", object2, "' is incorrect!");
                }
            }
            Config.setProperty((String)"jcifs.lmCompatibility", (String)"0");
            Config.setProperty((String)"jcifs.smb.client.useExtendedSecurity", (String)"false");
            object3 = Config.getProperty((String)"jcifs.smb.client.domain");
            object2 = Config.getProperty((String)"jcifs.http.domainController");
            if (object2 == null) {
                this.bLoadBalance = Config.getBoolean((String)"jcifs.http.loadBalance", (boolean)true);
                if (object3 == null) {
                    try {
                        object2 = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        object2 = "127.0.0.1";
                    }
                } else {
                    object2 = object3;
                }
                object2 = object3;
            } else {
                this.bLoadBalance = false;
            }
            if (!this.bLoadBalance) {
                this.alDomainController = new ArrayList();
                object = new StringTokenizer((String)object2, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    this.alDomainController.add(((StringTokenizer)object).nextToken());
                }
                this.iCurrentDomainController = 0;
                this.uaCurrentDomainController = null;
            }
            if ((n = Config.getInt((String)"jcifs.util.loglevel", (int)-1)) != -1) {
                LogStream.setLevel((int)n);
            }
            this.sCurrentConfig = list.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoadBalance() {
        Object object = this.oSync;
        synchronized (object) {
            return this.bLoadBalance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NtlmSession getSession() throws Throwable {
        Object object = this.oSync;
        synchronized (object) {
            this.setConfig();
            return this.getSessionIntern();
        }
    }

    private NtlmSession getSessionIntern() throws Throwable {
        byte[] byArray = null;
        if (this.bLoadBalance) {
            NtlmChallenge ntlmChallenge = SmbSession.getChallengeForDomain();
            UniAddress uniAddress = ntlmChallenge.dc;
            byArray = ntlmChallenge.challenge;
        } else {
            int n = this.iCurrentDomainController;
            UniAddress uniAddress = this.uaCurrentDomainController;
            do {
                try {
                    if (uniAddress == null) {
                        uniAddress = UniAddress.getByName((String)this.alDomainController.get(n), (boolean)true);
                    }
                    byArray = SmbSession.getChallenge((UniAddress)uniAddress);
                    this.log.info("Mode DomainController '", uniAddress, "', #", n, " challenge = ", byArray != null ? Base64.encode((byte[])byArray) : null);
                    this.uaCurrentDomainController = uniAddress;
                    this.iCurrentDomainController = n;
                }
                catch (Throwable throwable) {
                    this.log.info("Mode DomainController '", this.alDomainController.get(n), "', #", n, " failed");
                    uniAddress = null;
                    n = (n + 1) % this.alDomainController.size();
                    if (n != this.iCurrentDomainController) continue;
                    throw throwable;
                }
            } while (this.uaCurrentDomainController == null);
        }
        return new NtlmSession(this.uaCurrentDomainController, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NtlmAuthInfo logon(String string, String string2, String string3) throws Throwable {
        Object object = this.oSync;
        synchronized (object) {
            this.setConfig();
            NtlmSession ntlmSession = this.getSessionIntern();
            NtlmPasswordAuthentication ntlmPasswordAuthentication = new NtlmPasswordAuthentication(string, string2, string3);
            return this.logon(ntlmSession, ntlmPasswordAuthentication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NtlmAuthInfo logon() throws Throwable {
        Class<?> clazz = Class.forName("sun.net.www.protocol.http.NTLMAuthSequence");
        Constructor<?> constructor = clazz.getDeclaredConstructor(String.class, String.class, String.class);
        constructor.setAccessible(true);
        Object obj = constructor.newInstance(null, null, null);
        Method method = clazz.getMethod("getAuthHeader", String.class);
        String string = (String)method.invoke(obj, new Object[]{null});
        Object object = this.oSync;
        synchronized (object) {
            Object object2;
            Type1Message type1Message;
            this.setConfig();
            NtlmSession ntlmSession = this.getSessionIntern();
            byte[] byArray = Base64.decode((String)string);
            if (byArray[8] == 1) {
                type1Message = new Type1Message(byArray);
                object2 = new Type2Message(type1Message, ntlmSession.getChallenge(), null);
                string = (String)method.invoke(obj, Base64.encode((byte[])object2.toByteArray()));
            }
            if ((byArray = Base64.decode((String)string))[8] == 3) {
                byte[] byArray2;
                type1Message = new Type3Message(byArray);
                object2 = type1Message.getLMResponse();
                if (object2 == null) {
                    object2 = new byte[0];
                }
                if ((byArray2 = type1Message.getNTResponse()) == null) {
                    byArray2 = new byte[]{};
                }
                NtlmPasswordAuthentication ntlmPasswordAuthentication = new NtlmPasswordAuthentication(type1Message.getDomain(), type1Message.getUser(), ntlmSession.getChallenge(), (byte[])object2, byArray2);
                return this.logon(ntlmSession, ntlmPasswordAuthentication);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NtlmAuthInfo logon(NtlmSession ntlmSession, NtlmPasswordAuthentication ntlmPasswordAuthentication) throws Throwable {
        try {
            Object object = this.oSync;
            synchronized (object) {
                this.setConfig();
                SmbSession.logon((UniAddress)ntlmSession.getDomainController(), (NtlmPasswordAuthentication)ntlmPasswordAuthentication);
            }
            this.log.info(ntlmPasswordAuthentication, " successfully authenticated against ", ntlmSession.getDomainController());
            return new NtlmAuthInfo(ntlmPasswordAuthentication, ntlmSession, Config.getInt((String)"alivedelay", (int)15000));
        }
        catch (SmbAuthException smbAuthException) {
            this.log.info(new Object[]{ntlmPasswordAuthentication.getName(), ": 0x", Hexdump.toHexString((int)smbAuthException.getNtStatus(), (int)8), ": ", smbAuthException});
            throw smbAuthException;
        }
    }
}

