/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.Server;
import com.sibvisions.rad.server.WrappedSession;
import com.sibvisions.rad.server.http.HttpContext;
import com.sibvisions.util.type.StringUtil;
import java.io.File;
import javax.rad.server.IServer;
import javax.rad.server.ISession;
import javax.rad.server.ServerContext;
import javax.servlet.http.HttpServletRequest;

public class ServerContextImpl
extends ServerContext {
    private Server server;
    private WrappedSession session;
    private String sIdentifier;

    ServerContextImpl(Server server) {
        this.server = server;
        this.sIdentifier = this.createSystemIdentifier();
        this.setInstance(this);
    }

    ServerContextImpl(Server server, String string) {
        this.server = server;
        this.sIdentifier = string;
        this.setInstance(this);
    }

    protected void destroy() {
        this.setInstance(null);
    }

    public ISession getSession() {
        return this.session;
    }

    public String getSystemIdentifier() {
        return this.sIdentifier;
    }

    public String getServerIdentifier() {
        return this.server.getInstanceKey();
    }

    void setSession(ISession iSession) {
        if (iSession == null) {
            this.session = null;
        } else {
            Object object;
            this.session = iSession instanceof WrappedSession ? (WrappedSession)iSession : new WrappedSession((AbstractSession)iSession);
            if (StringUtil.isEmpty(this.sIdentifier) && (object = this.session.getProperties().get("server.request.systemIdentifier")) != null) {
                this.sIdentifier = object.toString();
            }
        }
    }

    public IServer getServer() {
        return this.server;
    }

    private String createSystemIdentifier() {
        String string = "";
        HttpContext httpContext = HttpContext.getCurrentInstance();
        if (httpContext != null) {
            Object object = httpContext.getRequest();
            if (object instanceof HttpServletRequest) {
                string = ((HttpServletRequest)object).getRequestURL().toString();
            }
        } else {
            File file = new File("");
            string = file.getAbsolutePath();
        }
        return string;
    }
}

