/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.server;

import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.rad.server.AbstractSession;
import com.sibvisions.rad.server.IRequest;
import com.sibvisions.rad.server.MasterSession;
import com.sibvisions.rad.server.Server;
import com.sibvisions.rad.server.ServerContextImpl;
import com.sibvisions.rad.server.SubSession;
import com.sibvisions.rad.server.http.HttpContext;
import com.sibvisions.rad.server.protocol.ProtocolFactory;
import com.sibvisions.rad.server.protocol.Record;
import com.sibvisions.rad.server.security.AbstractSecurityManager;
import com.sibvisions.rad.server.security.ISecurityManager;
import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.ChangedHashtable;
import com.sibvisions.util.GroupHashtable;
import com.sibvisions.util.Reflective;
import com.sibvisions.util.ThreadHandler;
import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.StringUtil;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.rad.remote.SessionExpiredException;
import javax.rad.server.AbstractSessionManager;
import javax.rad.server.IConfiguration;
import javax.rad.server.ISession;
import javax.rad.server.ServerContext;
import javax.rad.server.event.ISessionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSessionManager
extends AbstractSessionManager {
    private static final long CONTROLLER_INTERVAL = 10000L;
    private static final String[] USED_SYSPROPS = new String[]{"user.timezone", "user.name", "os.name", "os.version", "os.arch", "java.vendor", "java.version", "java.class.version", "java.vm.name", "file.encoding", "file.separator", "path.separator", "line.separator"};
    private Hashtable<Object, AbstractSession> htSessions = new Hashtable();
    private Hashtable<String, ISecurityManager> htApplicationSecManager = null;
    private GroupHashtable<String, Object, ISecurityManager> ghtSessionSecManager = null;
    private Hashtable<String, String> htSecManagerClass = null;
    private ArrayUtil<ISessionListener> auEvents = null;
    private Object oSync = new Object();
    private Thread thController = null;
    private ILogger log = LoggerFactory.getInstance(this.getClass());
    private static long lControllerInterval = 10000L;

    protected DefaultSessionManager(Server server) {
        super(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final AbstractSession get(Object object) {
        AbstractSession abstractSession = null;
        if (object == null) throw new SecurityException("Invalid session id '" + object + "'");
        Object object2 = this.oSync;
        synchronized (object2) {
            abstractSession = this.htSessions.get(object);
        }
        if (abstractSession == null) throw new SessionExpiredException("Session expired '" + object + "'");
        long l = System.currentTimeMillis();
        if (!abstractSession.isInactive(l) && abstractSession.isAlive(l)) return abstractSession;
        this.log.debug("Destroy invalid session: ", object, abstractSession.isInactive(l), !abstractSession.isAlive(l));
        this.destroy(object);
        throw new SessionExpiredException("Session expired '" + object + "'");
    }

    @Override
    public final void addSessionListener(ISessionListener iSessionListener) {
        if (this.auEvents == null) {
            this.auEvents = new ArrayUtil();
        }
        this.auEvents.add(iSessionListener);
    }

    @Override
    public final void removeSessionListener(ISessionListener iSessionListener) {
        if (this.auEvents != null) {
            this.auEvents.remove(iSessionListener);
        }
    }

    @Override
    public final ISessionListener[] getSessionListeners() {
        if (this.auEvents == null) {
            return new ISessionListener[0];
        }
        ISessionListener[] iSessionListenerArray = new ISessionListener[this.auEvents.size()];
        return this.auEvents.toArray(iSessionListenerArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object createSession(IRequest iRequest, ISerializer iSerializer, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        Object object;
        Record record = ProtocolFactory.openRecord("SESSION_MANAGER", "MASTER", new Object[0]);
        try {
            Object object2;
            ServerContext serverContext;
            ChangedHashtable<String, Object> changedHashtable2;
            Record record2 = ProtocolFactory.openRecord("SESSION_MANAGER", "INIT_PROPERTIES", new Object[0]);
            try {
                changedHashtable2 = this.getInitialProperties(changedHashtable, iRequest);
                serverContext = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                CommonUtil.close(record2);
                throw throwable;
            }
            CommonUtil.close(record2);
            MasterSession masterSession = new MasterSession(this, changedHashtable2);
            serverContext = ServerContext.getCurrentInstance();
            if (serverContext instanceof ServerContextImpl) {
                ((ServerContextImpl)serverContext).setSession(masterSession);
            }
            if (record != null) {
                record.addIdentifier(masterSession.getId());
                object2 = HttpContext.getCurrentInstance();
                object = null;
                if (object2 != null) {
                    try {
                        object = (String)Reflective.call(((HttpContext)object2).getRequest(), "getHeader", "User-Agent");
                    }
                    catch (Throwable throwable) {
                        this.log.debug(throwable);
                    }
                }
                record.setParameter(masterSession.getLifeCycleName(), masterSession.getUserName(), CommonUtil.nvl(object, "unknown"));
            }
            object2 = ProtocolFactory.openRecord("SESSION_MANAGER", "POST_CREATE", new Object[0]);
            try {
                masterSession.setSerializer(iSerializer);
                this.addIntern(masterSession);
                try {
                    this.postCreateSession(masterSession);
                }
                catch (Throwable throwable) {
                    this.destroy(masterSession.getId());
                    throw throwable;
                }
                object = masterSession.getId();
                Object var13_15 = null;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                CommonUtil.close(object2);
                throw throwable;
            }
            CommonUtil.close(object2);
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Object createSubSession(IRequest iRequest, AbstractSession abstractSession, ChangedHashtable<String, Object> changedHashtable) throws Throwable {
        Object object;
        Record record = ProtocolFactory.openRecord("SESSION_MANAGER", "SUB", new Object[0]);
        try {
            SubSession subSession;
            ChangedHashtable<String, Object> changedHashtable2;
            if (record != null) {
                record.addIdentifier(abstractSession.getId());
                record.addIdentifier("MASTER");
            }
            Record record2 = ProtocolFactory.openRecord("SESSION_MANAGER", "INIT_PROPERTIES", new Object[0]);
            try {
                changedHashtable2 = this.getInitialProperties(changedHashtable, iRequest);
                subSession = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                CommonUtil.close(record2);
                throw throwable;
            }
            CommonUtil.close(record2);
            MasterSession masterSession = (MasterSession)this.getMasterSession(abstractSession);
            subSession = new SubSession(masterSession, changedHashtable2);
            ServerContext serverContext = ServerContext.getCurrentInstance();
            if (serverContext instanceof ServerContextImpl) {
                ((ServerContextImpl)serverContext).setSession(subSession);
            }
            if (record != null) {
                record.addIdentifier(subSession.getId());
                record.setParameter(subSession.getLifeCycleName());
            }
            Record record3 = ProtocolFactory.openRecord("SESSION_MANAGER", "POST_CREATE", new Object[0]);
            try {
                this.addIntern(subSession);
                try {
                    this.postCreateSubSession(masterSession, subSession);
                }
                catch (Throwable throwable) {
                    this.destroy(subSession.getId());
                    throw throwable;
                }
                object = subSession.getId();
                Object var13_15 = null;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                CommonUtil.close(record3);
                throw throwable;
            }
            CommonUtil.close(record3);
            Object var15_17 = null;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            CommonUtil.close(record);
            throw throwable;
        }
        CommonUtil.close(record);
        return object;
    }

    public final void destroy(Object object) {
        Object object2 = object instanceof ISession ? ((ISession)object).getId() : object;
        this.destroy(object2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void destroy(Object var1_1, boolean var2_2) {
        if (var1_1 != null) {
            var3_3 = ProtocolFactory.openRecord("SESSION_MANAGER", "DESTROY", new Object[0]);
            try {
                if (var3_3 != null) {
                    var3_3.addIdentifier(var1_1);
                }
                var5_4 = this.oSync;
                synchronized (var5_4) {
                    var4_5 = this.htSessions.remove(var1_1);
                }
                if (var4_5 == null) {
                    if (this.ghtSessionSecManager != null) {
                        var5_4 = this.ghtSessionSecManager;
                        synchronized (var5_4) {
                            var6_7 = this.ghtSessionSecManager.removeKey(var1_1);
                            if (var6_7 != null) {
                                for (ISecurityManager var8_12 : var6_7) {
                                    this.releaseSecurityManager(var8_12);
                                }
                            }
                        }
                    }
                    throw new SessionExpiredException("Session expired '" + var1_1 + "'");
                }
                var5_4 = ServerContext.getCurrentInstance();
                if (var5_4 instanceof ServerContextImpl) {
                    ((ServerContextImpl)var5_4).setSession(var4_5);
                }
                try {
                    if (var4_5 instanceof MasterSession) {
                        var6_8 = false;
                        if (this.getCacheMode(var4_5) == CacheMode.Application) {
                            var5_4 = this.htApplicationSecManager.get(var4_5.getApplicationName());
                        } else {
                            var5_4 = this.ghtSessionSecManager.remove(var4_5.getApplicationName(), var4_5.getId());
                            var6_8 = true;
                        }
                        try {
                            try {
                                var5_4.logout(var4_5);
                            }
                            catch (Throwable var7_10) {
                                this.log.error(new Object[]{var7_10});
                            }
                            var7_11 = ((MasterSession)var4_5).removeSubSessions();
                            if (var7_11 != null) {
                                var9_15 = var7_11.size();
                                for (var8_13 = 0; var8_13 < var9_15; ++var8_13) {
                                    try {
                                        this.destroy(var7_11.get(var8_13).getId(), true);
                                        continue;
                                    }
                                    catch (Throwable var10_16) {
                                        this.log.info(new Object[]{var10_16});
                                    }
                                }
                            }
                            var12_17 = null;
                            if (!var6_8) ** GOTO lbl70
                            this.releaseSecurityManager((ISecurityManager)var5_4);
                        }
                        catch (Throwable var11_19) {
                            var12_18 = null;
                            if (var6_8) {
                                this.releaseSecurityManager((ISecurityManager)var5_4);
                            }
                            throw var11_19;
                        }
                    } else if (var4_5 instanceof SubSession) {
                        if (!var2_2 && var3_3 != null) {
                            var3_3.addIdentifier("DESTROY", 0);
                            var3_3.addIdentifier(((SubSession)var4_5).getMasterSession().getId(), 0);
                        }
                        ((SubSession)var4_5).getMasterSession().removeSubSession((SubSession)var4_5);
                    }
lbl70:
                    // 5 sources

                    var14_20 = null;
                    this.fireSessionDestroyed(var4_5);
                }
                catch (Throwable var13_22) {
                    var14_21 = null;
                    this.fireSessionDestroyed(var4_5);
                    throw var13_22;
                }
                var16_23 = null;
            }
            catch (Throwable var15_25) {
                var16_24 = null;
                CommonUtil.close(new Object[]{var3_3});
                throw var15_25;
            }
            CommonUtil.close(new Object[]{var3_3});
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIntern(AbstractSession abstractSession) {
        Object object = this.oSync;
        synchronized (object) {
            this.htSessions.put(abstractSession.getId(), abstractSession);
        }
        this.fireSessionCreated(abstractSession);
        this.startController();
    }

    final ISecurityManager getSecurityManager(ISession iSession) throws Exception {
        String string = iSession.getApplicationName();
        ISecurityManager iSecurityManager = null;
        String string2 = null;
        CacheMode cacheMode = this.getCacheMode(iSession);
        if (cacheMode == CacheMode.Application) {
            if (this.htApplicationSecManager != null) {
                iSecurityManager = this.htApplicationSecManager.get(string);
            }
            string2 = iSession.getConfig().getProperty("/application/securitymanager/class");
            if (!(iSecurityManager == null || string2 != null && string2.equals(this.htSecManagerClass.get(string)))) {
                this.htApplicationSecManager.remove(string);
                this.htSecManagerClass.remove(string);
                this.releaseSecurityManager(iSecurityManager);
                iSecurityManager = null;
            }
        } else if (this.ghtSessionSecManager != null) {
            iSecurityManager = this.ghtSessionSecManager.get(string, iSession.getId());
        }
        if (iSecurityManager == null) {
            try {
                iSecurityManager = this.createSecurityManager(iSession);
                if (cacheMode == CacheMode.Application) {
                    if (this.htApplicationSecManager == null) {
                        this.htApplicationSecManager = new Hashtable();
                        this.htSecManagerClass = new Hashtable();
                    }
                    this.htApplicationSecManager.put(string, iSecurityManager);
                    this.htSecManagerClass.put(string, string2);
                } else {
                    if (this.ghtSessionSecManager == null) {
                        this.ghtSessionSecManager = new GroupHashtable();
                    }
                    this.ghtSessionSecManager.put(string, iSession.getId(), iSecurityManager);
                }
            }
            catch (Throwable throwable) {
                throw new Exception("Error during instantiation of security manager", throwable);
            }
        }
        return iSecurityManager;
    }

    final ISecurityManager[] getSecurityManagerFromCache(String string) {
        Object object;
        ArrayUtil<Object> arrayUtil = null;
        if (this.htApplicationSecManager != null) {
            arrayUtil = new ArrayUtil<Object>();
            object = this.htApplicationSecManager.get(string);
            if (object != null) {
                arrayUtil.add(object);
            }
        }
        if (this.ghtSessionSecManager != null && (object = this.ghtSessionSecManager.get(string)) != null) {
            if (arrayUtil == null) {
                arrayUtil = new ArrayUtil();
            }
            Enumeration enumeration = ((Hashtable)object).elements();
            while (enumeration.hasMoreElements()) {
                arrayUtil.add(enumeration.nextElement());
            }
        }
        if (arrayUtil != null && !arrayUtil.isEmpty()) {
            return arrayUtil.toArray(new ISecurityManager[arrayUtil.size()]);
        }
        return null;
    }

    protected ISecurityManager createSecurityManager(ISession iSession) throws Exception {
        return this.createSecurityManager(null, iSession);
    }

    protected ISecurityManager createSecurityManager(ClassLoader classLoader, ISession iSession) throws Exception {
        return AbstractSecurityManager.createSecurityManager(classLoader, iSession);
    }

    protected void releaseSecurityManager(ISecurityManager iSecurityManager) {
        try {
            iSecurityManager.release();
        }
        catch (Throwable throwable) {
            this.log.debug(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getSessionCount() {
        Object object = this.oSync;
        synchronized (object) {
            return this.htSessions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ArrayUtil<Object> getSessionIds() {
        Object object = this.oSync;
        synchronized (object) {
            return new ArrayUtil<Object>((Collection<Object>)this.htSessions.keySet());
        }
    }

    private void fireSessionCreated(ISession iSession) {
        if (iSession == null || this.auEvents == null) {
            return;
        }
        int n = this.auEvents.size();
        for (int i = 0; i < n; ++i) {
            this.auEvents.get(i).sessionCreated(iSession);
        }
    }

    private void fireSessionDestroyed(ISession iSession) {
        if (iSession == null || this.auEvents == null) {
            return;
        }
        int n = this.auEvents.size();
        for (int i = 0; i < n; ++i) {
            this.auEvents.get(i).sessionDestroyed(iSession);
        }
    }

    private void startController() {
        if (ThreadHandler.isStopped(this.thController)) {
            this.thController = ThreadHandler.start(new Controller());
            this.log.debug("Start Controller: ", this.thController.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateSessions() {
        ArrayUtil<Object> arrayUtil = this.getSessionIds();
        long l = System.currentTimeMillis();
        ServerContext serverContext = ((Server)this.getServer()).createServerContext();
        try {
            Record record = null;
            try {
                try {
                    int n = arrayUtil.size();
                    for (int i = 0; i < n; ++i) {
                        Object object = arrayUtil.get(i);
                        ISession iSession = this.htSessions.get(object);
                        ((ServerContextImpl)serverContext).setSession(iSession);
                        if (iSession == null || !iSession.isInactive(l) && iSession.isAlive(l)) continue;
                        if (record == null && (record = ProtocolFactory.openRecord("SESSION_MANAGER", "VALIDATESESSIONS", new Object[0])) != null) {
                            record.addIdentifier("(thread)");
                        }
                        this.log.debug("Destroy invalid session: ", object, iSession.isInactive(l), !iSession.isAlive(l));
                        this.destroy(object);
                    }
                    Object var11_10 = null;
                }
                catch (RuntimeException runtimeException) {
                    if (record != null) {
                        record.setException(runtimeException);
                    }
                    throw runtimeException;
                }
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                CommonUtil.close(record);
                throw throwable;
            }
            CommonUtil.close(record);
            Object var13_13 = null;
            serverContext.release();
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            serverContext.release();
            throw throwable;
        }
    }

    private ChangedHashtable<String, Object> getInitialProperties(ChangedHashtable<String, Object> changedHashtable, IRequest iRequest) throws Exception {
        String string;
        ServerContext serverContext;
        Hashtable<String, Object> hashtable;
        ChangedHashtable<String, Object> changedHashtable2 = changedHashtable != null ? changedHashtable : new ChangedHashtable();
        InetAddress inetAddress = InetAddress.getLocalHost();
        changedHashtable2.put("server.server_version", "0.4.1");
        changedHashtable2.put("server.spec_version", "0.4.1");
        changedHashtable2.put("server.hostname", inetAddress.getHostName());
        changedHashtable2.put("server.address", inetAddress.getHostAddress());
        changedHashtable2.put("server.session.creationTime", new Date());
        if (ProtocolFactory.getInstance() != null) {
            changedHashtable2.put("server.usingProtocol", "true");
        }
        String string2 = "server.sysprop.";
        int n = USED_SYSPROPS.length;
        for (int i = 0; i < n; ++i) {
            String string3 = System.getProperty(USED_SYSPROPS[i]);
            if (string3 == null) continue;
            changedHashtable2.put(string2 + USED_SYSPROPS[i], string3);
        }
        if (iRequest != null && (hashtable = iRequest.getProperties()) != null) {
            string2 = "server.request.";
            for (Map.Entry<String, Object> entry : hashtable.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                changedHashtable2.put(string2 + entry.getKey(), (String)entry.getValue());
            }
        }
        if ((serverContext = ServerContext.getCurrentInstance()) != null && (string = serverContext.getSystemIdentifier()) != null) {
            changedHashtable2.put("server.request.systemIdentifier", new SystemIdentifier(string));
        }
        return changedHashtable2;
    }

    protected void postCreateSession(ISession iSession) {
    }

    protected void postCreateSubSession(ISession iSession, ISession iSession2) {
    }

    public boolean isAvailable(ISession iSession) {
        if (iSession != null) {
            return this.htSessions != null && this.htSessions.get(iSession.getId()) != null;
        }
        return false;
    }

    public static void setControllerInterval(long l) {
        lControllerInterval = l <= 0L ? 10000L : l;
    }

    public static long getControllerInterval() {
        return lControllerInterval;
    }

    private CacheMode getCacheMode(ISession iSession) {
        CacheMode cacheMode = (CacheMode)((Object)iSession.getProperty("server.session.cacheMode"));
        if (cacheMode != null) {
            return cacheMode;
        }
        IConfiguration iConfiguration = iSession.getConfig();
        String string = iConfiguration.getProperty("/application/securitymanager/cacheMode");
        try {
            cacheMode = CacheMode.valueOf(StringUtil.formatInitCap(string));
        }
        catch (Exception exception) {
            cacheMode = CacheMode.Application;
        }
        if (iSession instanceof SubSession) {
            ((SubSession)iSession).getMasterSession().setProperty("server.session.cacheMode", (Object)cacheMode);
        }
        iSession.setProperty("server.session.cacheMode", (Object)cacheMode);
        return cacheMode;
    }

    ISession getMasterSession(ISession iSession) {
        if (iSession instanceof SubSession) {
            return ((SubSession)iSession).getMasterSession();
        }
        return iSession;
    }

    final class SystemIdentifier {
        String systemIdentifier;

        private SystemIdentifier(String string) {
            this.systemIdentifier = string;
        }

        public String toString() {
            return this.systemIdentifier;
        }
    }

    private final class Controller
    extends Thread {
        private Controller() {
        }

        public void run() {
            try {
                while (!ThreadHandler.isStopped()) {
                    DefaultSessionManager.this.validateSessions();
                    Thread.sleep(lControllerInterval);
                }
            }
            catch (Throwable throwable) {
                DefaultSessionManager.this.log.debug(throwable);
            }
            DefaultSessionManager.this.log.error("Controller stopped: ", this.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CacheMode {
        Application,
        Session;

    }
}

