/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortSerializer
implements ITypeSerializer<Short> {
    private static final int TYPE_SHORT = 9;
    private static final int TYPE_SHORT_0 = 10;
    private static final Short SHORT_0 = 0;

    @Override
    public Class<Short> getTypeClass() {
        return Short.class;
    }

    @Override
    public int getMinValue() {
        return 9;
    }

    @Override
    public int getMaxValue() {
        return 10;
    }

    @Override
    public Short read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        if (n == 9) {
            return dataInputStream.readShort();
        }
        return SHORT_0;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, Short s, TypeCache typeCache) throws Exception {
        short s2 = s;
        if (s2 == 0) {
            dataOutputStream.writeByte(10);
        } else {
            dataOutputStream.writeByte(9);
            dataOutputStream.writeShort(s2);
        }
    }
}

