/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.AbstractSizedSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleArraySerializer
extends AbstractSizedSerializer
implements ITypeSerializer<double[]> {
    private static final int TYPE_DOUBLE_ARRAY_MIN = 59;
    private static final int TYPE_DOUBLE_ARRAY_MAX = 61;

    @Override
    public Class<double[]> getTypeClass() {
        return double[].class;
    }

    @Override
    public int getMinValue() {
        return 59;
    }

    @Override
    public int getMaxValue() {
        return 61;
    }

    @Override
    public double[] read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        int n2 = this.readSize(dataInputStream, n, 59, 61);
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = dataInputStream.readDouble();
        }
        return dArray;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, double[] dArray, TypeCache typeCache) throws Exception {
        this.writeSize(dataOutputStream, dArray.length, 59, 61);
        for (int i = 0; i < dArray.length; ++i) {
            dataOutputStream.writeDouble(dArray[i]);
        }
    }
}

