/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.AbstractSizedSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecimalSerializer
extends AbstractSizedSerializer
implements ITypeSerializer<BigDecimal> {
    private static final int TYPE_BIGDECIMAL_MIN = 79;
    private static final int TYPE_BIGDECIMAL_MAX = 88;
    private static final int TYPE_BIGDECIMAL_NOSCALE_MIN = 89;
    private static final int TYPE_BIGDECIMAL_NOSCALE_MAX = 98;
    private static BigDecimal[] bigDecimalCache = new BigDecimal[256];

    @Override
    public Class<BigDecimal> getTypeClass() {
        return BigDecimal.class;
    }

    @Override
    public int getMinValue() {
        return 79;
    }

    @Override
    public int getMaxValue() {
        return 98;
    }

    @Override
    public BigDecimal read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        int n2 = n < 89 ? this.readSize(dataInputStream, n, 79, 88) : this.readSize(dataInputStream, n, 89, 98);
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray);
        if (n < 89) {
            return new BigDecimal(new BigInteger(byArray), dataInputStream.readUnsignedByte());
        }
        if (n2 == 1) {
            int n3 = byArray[0] & 0xFF;
            BigDecimal bigDecimal = bigDecimalCache[n3];
            if (bigDecimal == null) {
                DecimalSerializer.bigDecimalCache[n3] = bigDecimal = new BigDecimal(new BigInteger(byArray));
            }
            return bigDecimal;
        }
        return new BigDecimal(new BigInteger(byArray));
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, BigDecimal bigDecimal, TypeCache typeCache) throws Exception {
        int n = bigDecimal.scale();
        byte[] byArray = bigDecimal.movePointRight(n).toBigInteger().toByteArray();
        if (n == 0) {
            this.writeSize(dataOutputStream, byArray.length, 89, 98);
            dataOutputStream.write(byArray);
        } else {
            this.writeSize(dataOutputStream, byArray.length, 79, 88);
            dataOutputStream.write(byArray);
            dataOutputStream.writeByte(n);
        }
    }
}

