/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.AbstractSizedSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharArraySerializer
extends AbstractSizedSerializer
implements ITypeSerializer<char[]> {
    private static final int TYPE_CHAR_ARRAY_MIN = 36;
    private static final int TYPE_CHAR_ARRAY_MAX = 38;

    @Override
    public Class<char[]> getTypeClass() {
        return char[].class;
    }

    @Override
    public int getMinValue() {
        return 36;
    }

    @Override
    public int getMaxValue() {
        return 38;
    }

    @Override
    public char[] read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        int n2 = this.readSize(dataInputStream, n, 36, 38);
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = dataInputStream.readChar();
        }
        return cArray;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, char[] cArray, TypeCache typeCache) throws Exception {
        this.writeSize(dataOutputStream, cArray.length, 36, 38);
        for (int i = 0; i < cArray.length; ++i) {
            dataOutputStream.writeChar(cArray[i]);
        }
    }
}

