/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.AbstractSizedSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Array;
import javax.rad.type.bean.BeanType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraySerializer
extends AbstractSizedSerializer
implements ITypeSerializer<Object[]> {
    private static final int TYPE_ARRAY_MIN = 39;
    private static final int TYPE_ARRAY_MAX = 41;

    @Override
    public Class<Object[]> getTypeClass() {
        return Object[].class;
    }

    @Override
    public int getMinValue() {
        return 39;
    }

    @Override
    public int getMaxValue() {
        return 41;
    }

    @Override
    public Object[] read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        Class<Object> clazz;
        int n2 = this.readSize(dataInputStream, n, 39, 41);
        int n3 = dataInputStream.readUnsignedByte();
        if (n3 == 0) {
            clazz = Object.class;
        } else if (n3 == 68) {
            clazz = ((BeanType)universalSerializer.read(dataInputStream, typeCache)).getTypeClass();
            if (clazz == null) {
                clazz = Object.class;
            }
        } else if (n3 == 71) {
            clazz = ((BeanType)universalSerializer.read(dataInputStream, typeCache)).getTypeClass();
            if (clazz == null) {
                clazz = Enum.class;
            }
        } else {
            clazz = universalSerializer.getTypeSerializer(n3).getTypeClass();
        }
        int n4 = dataInputStream.readUnsignedByte();
        if (n4 > 0) {
            clazz = Array.newInstance(clazz, new int[n4]).getClass();
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, n2);
        for (int i = 0; i < n2; ++i) {
            Array.set(objectArray, i, universalSerializer.read(dataInputStream, typeCache));
        }
        return objectArray;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, Object[] objectArray, TypeCache typeCache) throws Exception {
        this.writeSize(dataOutputStream, objectArray.length, 39, 41);
        int n = 0;
        Class<?> clazz = objectArray.getClass().getComponentType();
        while (clazz.isArray() && !clazz.getComponentType().isPrimitive()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        int n2 = clazz == Object.class ? 0 : universalSerializer.getTypeSerializer(clazz).getMinValue();
        if (n2 == 68 || n2 == 71) {
            dataOutputStream.writeByte(n2);
            universalSerializer.write(dataOutputStream, BeanType.getBeanType(clazz), typeCache);
        } else {
            dataOutputStream.writeByte(n2);
        }
        dataOutputStream.writeByte(n);
        for (int i = 0; i < objectArray.length; ++i) {
            universalSerializer.write(dataOutputStream, objectArray[i], typeCache);
        }
    }
}

