/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote;

import com.sibvisions.rad.remote.ISerializer;
import com.sibvisions.util.ArrayUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ChoiceFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public final class ByteSerializer
implements ISerializer {
    private static final Float FLOAT_ZERO = new Float(0.0f);
    private static final int TYPE_NULL = 0;
    private static final int TYPE_BYTE = 1;
    private static final int TYPE_CHARACTER = 2;
    private static final int TYPE_TRUE = 3;
    private static final int TYPE_FALSE = 4;
    private static final int TYPE_FLOAT = 5;
    private static final int TYPE_FLOAT_0 = 6;
    private static final int TYPE_DOUBLE = 7;
    private static final int TYPE_DOUBLE_0 = 8;
    private static final int TYPE_SHORT = 9;
    private static final int TYPE_SHORT_0 = 10;
    private static final int TYPE_INTEGER = 11;
    private static final int TYPE_INTEGER_0 = 12;
    private static final int TYPE_LONG = 13;
    private static final int TYPE_LONG_0 = 14;
    private static final int TYPE_UTIL_DATE = 15;
    private static final int TYPE_SQL_DATE = 16;
    private static final int TYPE_SQL_TIME = 17;
    private static final int TYPE_SQL_TIMESTAMP = 18;
    private static final int TYPE_SQL_TIMESTAMP_NONANOS = 19;
    private static final int TYPE_STRINGBUFFER = 20;
    private static final int TYPE_STRINGBUILDER = 21;
    private static final int TYPE_OBJECT = 22;
    private static final int TYPE_THROWABLE = 23;
    private static final int TYPE_REFLECTIVE = 24;
    private static final int TYPE_VARIABLE_MIN = 37;
    private static final int TYPE_VARIABLE_MAX = 59;
    private static final int TYPE_VAR_PRIMITIVE_BYTE = 0;
    private static final int TYPE_VAR_PRIMITIVE_CHARACTER = 1;
    private static final int TYPE_VAR_PRIMITIVE_BOOLEAN = 2;
    private static final int TYPE_VAR_PRIMITIVE_FLOAT = 3;
    private static final int TYPE_VAR_PRIMITIVE_DOUBLE = 4;
    private static final int TYPE_VAR_PRIMITIVE_SHORT = 5;
    private static final int TYPE_VAR_PRIMITIVE_INT = 6;
    private static final int TYPE_VAR_PRIMITIVE_LONG = 7;
    private static final int TYPE_VAR_INTEGER = 8;
    private static final int TYPE_VAR_LONG = 9;
    private static final int TYPE_VAR_OBJECT = 10;
    private static final int TYPE_VAR_OBJECT_2DIM = 11;
    private static final int TYPE_VAR_STRING = 12;
    private static final int TYPE_VAR_STRING_2DIM = 13;
    private static final int TYPE_VAR_ARRAYLIST = 14;
    private static final int TYPE_VAR_ARRAYUTIL = 15;
    private static final int TYPE_VAR_VECTOR = 16;
    private static final int TYPE_VAR_HASHTABLE = 17;
    private static final int TYPE_VAR_HASHMAP = 18;
    private static final int TYPE_VAR_STACKTRACEELEMENT = 19;
    private static final int TYPE_VAR_REFLECTIVE = 20;
    private static final int TYPE_VAR_PROPERTIES = 21;
    private static final int TYPE_VAR_OBJECT_3DIM = 22;
    private static final int TYPE_VAR_STRING_3DIM = 23;
    private static final int TYPE_BIGINTEGER_MIN = 59;
    private static final int TYPE_BIGINTEGER_MAX = 69;
    private static final int TYPE_BIGDECIMAL_MIN = 79;
    private static final int TYPE_BIGDECIMAL_MAX = 89;
    private static final int TYPE_BIGDECIMAL_NOSCALE_MIN = 89;
    private static final int TYPE_BIGDECIMAL_NOSCALE_MAX = 99;
    private static final int TYPE_STRING_MIN = 99;
    private static final int TYPE_STRING_MAX = 256;
    private static final DecimalFormatSymbols SYSTEM_DECSYMBOLS = new DecimalFormatSymbols();
    private static final DateFormatSymbols SYSTEM_DATESYMBOLS = new DateFormatSymbols();
    private Calendar calDate = Calendar.getInstance();
    private static HashMap<DecimalFormatSymbols, Locale> hmpDecFormatSymbols = null;
    private static HashMap<DateFormatSymbols, Locale> hmpDateFormatSymbols = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(DataOutputStream dataOutputStream, Object object) throws Exception {
        if (object == null) {
            dataOutputStream.write(0);
        } else {
            Class<?> clazz = object.getClass();
            if (clazz == String.class) {
                byte[] byArray = ((String)object).getBytes("UTF8");
                this.writeCalculatedType(dataOutputStream, byArray.length, 99, 256);
                dataOutputStream.write(byArray);
            } else if (clazz == String[].class) {
                String[] stringArray = (String[])object;
                this.writeCalculatedType(dataOutputStream, stringArray.length, 37, 59);
                dataOutputStream.write(12);
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    this.write(dataOutputStream, stringArray[i]);
                }
            } else if (clazz == String[][].class) {
                String[][] stringArray = (String[][])object;
                this.writeCalculatedType(dataOutputStream, stringArray.length, 37, 59);
                dataOutputStream.write(13);
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    this.write(dataOutputStream, stringArray[i]);
                }
            } else if (clazz == String[][][].class) {
                String[][][] stringArray = (String[][][])object;
                this.writeCalculatedType(dataOutputStream, stringArray.length, 37, 59);
                dataOutputStream.write(23);
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    this.write(dataOutputStream, stringArray[i]);
                }
            } else if (clazz == ArrayList.class) {
                ArrayList arrayList = (ArrayList)object;
                this.writeCalculatedType(dataOutputStream, arrayList.size(), 37, 59);
                dataOutputStream.write(14);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    this.write(dataOutputStream, arrayList.get(i));
                }
            } else if (clazz == ArrayUtil.class) {
                ArrayUtil arrayUtil = (ArrayUtil)object;
                this.writeCalculatedType(dataOutputStream, arrayUtil.size(), 37, 59);
                dataOutputStream.write(15);
                int n = arrayUtil.size();
                for (int i = 0; i < n; ++i) {
                    this.write(dataOutputStream, arrayUtil.get(i));
                }
            } else if (clazz == Vector.class) {
                Vector vector = (Vector)object;
                this.writeCalculatedType(dataOutputStream, vector.size(), 37, 59);
                dataOutputStream.write(16);
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    this.write(dataOutputStream, vector.get(i));
                }
            } else if (clazz == Hashtable.class) {
                Hashtable hashtable = (Hashtable)object;
                this.writeCalculatedType(dataOutputStream, hashtable.size(), 37, 59);
                dataOutputStream.write(17);
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    this.write(dataOutputStream, k);
                    this.write(dataOutputStream, hashtable.get(k));
                }
            } else if (clazz == HashMap.class) {
                HashMap hashMap = (HashMap)object;
                this.writeCalculatedType(dataOutputStream, hashMap.size(), 37, 59);
                dataOutputStream.write(18);
                for (Map.Entry entry : hashMap.entrySet()) {
                    this.write(dataOutputStream, entry.getKey());
                    this.write(dataOutputStream, entry.getValue());
                }
            } else if (clazz == Object[].class) {
                Object[] objectArray = (Object[])object;
                this.writeCalculatedType(dataOutputStream, objectArray.length, 37, 59);
                dataOutputStream.write(10);
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    this.write(dataOutputStream, objectArray[i]);
                }
            } else if (clazz == Object[][].class) {
                Object[][] objectArray = (Object[][])object;
                this.writeCalculatedType(dataOutputStream, objectArray.length, 37, 59);
                dataOutputStream.write(11);
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    this.write(dataOutputStream, objectArray[i]);
                }
            } else if (clazz == Object[][][].class) {
                Object[][][] objectArray = (Object[][][])object;
                this.writeCalculatedType(dataOutputStream, objectArray.length, 37, 59);
                dataOutputStream.write(22);
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    this.write(dataOutputStream, objectArray[i]);
                }
            } else if (clazz == Byte.class) {
                dataOutputStream.write(1);
                dataOutputStream.writeByte(((Byte)object).intValue());
            } else if (clazz == Character.class) {
                dataOutputStream.write(2);
                dataOutputStream.writeChar(((Character)object).charValue());
            } else if (clazz == Boolean.class) {
                if (((Boolean)object).booleanValue()) {
                    dataOutputStream.write(3);
                } else {
                    dataOutputStream.write(4);
                }
            } else if (clazz == Float.class) {
                if (((Float)object).floatValue() == 0.0f) {
                    dataOutputStream.write(6);
                } else {
                    dataOutputStream.write(5);
                    dataOutputStream.writeFloat(((Float)object).floatValue());
                }
            } else if (clazz == Double.class) {
                if ((Double)object == 0.0) {
                    dataOutputStream.write(8);
                } else {
                    dataOutputStream.write(7);
                    dataOutputStream.writeDouble((Double)object);
                }
            } else if (clazz == Short.class) {
                if ((Short)object == 0) {
                    dataOutputStream.write(10);
                } else {
                    dataOutputStream.write(9);
                    dataOutputStream.writeShort(((Short)object).shortValue());
                }
            } else if (clazz == Integer.class) {
                if ((Integer)object == 0) {
                    dataOutputStream.write(12);
                } else {
                    dataOutputStream.write(11);
                    dataOutputStream.writeInt((Integer)object);
                }
            } else if (clazz == Long.class) {
                if ((Long)object == 0L) {
                    dataOutputStream.write(14);
                } else {
                    dataOutputStream.write(13);
                    dataOutputStream.writeLong((Long)object);
                }
            } else if (clazz == java.util.Date.class) {
                dataOutputStream.write(15);
                dataOutputStream.writeLong(((java.util.Date)object).getTime());
            } else if (clazz == Date.class) {
                dataOutputStream.write(16);
                dataOutputStream.writeLong(((Date)object).getTime());
            } else if (clazz == Time.class) {
                dataOutputStream.write(17);
                dataOutputStream.writeLong(((Time)object).getTime());
            } else if (clazz == Timestamp.class) {
                int n = ((Timestamp)object).getNanos();
                if (n > 0) {
                    dataOutputStream.write(18);
                } else {
                    dataOutputStream.write(19);
                }
                Calendar calendar = this.calDate;
                synchronized (calendar) {
                    this.calDate.setTime((Timestamp)object);
                    dataOutputStream.write(this.calDate.get(5));
                    dataOutputStream.write(this.calDate.get(2));
                    dataOutputStream.writeShort(this.calDate.get(1));
                    dataOutputStream.write(this.calDate.get(11));
                    dataOutputStream.write(this.calDate.get(12));
                    dataOutputStream.write(this.calDate.get(13));
                    if (n > 0) {
                        dataOutputStream.writeInt(n);
                    }
                }
            } else if (clazz == StringBuffer.class) {
                dataOutputStream.write(20);
                this.write(dataOutputStream, ((StringBuffer)object).toString());
            } else if (clazz == StringBuilder.class) {
                dataOutputStream.write(21);
                this.write(dataOutputStream, ((StringBuilder)object).toString());
            } else if (clazz == BigInteger.class) {
                byte[] byArray = ((BigInteger)object).toByteArray();
                this.writeCalculatedType(dataOutputStream, byArray.length, 59, 69);
                dataOutputStream.write(byArray);
            } else if (clazz == BigDecimal.class) {
                BigDecimal bigDecimal = (BigDecimal)object;
                int n = bigDecimal.scale();
                byte[] byArray = bigDecimal.movePointRight(n).toBigInteger().toByteArray();
                if (n == 0) {
                    this.writeCalculatedType(dataOutputStream, byArray.length, 89, 99);
                    dataOutputStream.write(byArray);
                } else {
                    this.writeCalculatedType(dataOutputStream, byArray.length, 79, 89);
                    dataOutputStream.write(byArray);
                    dataOutputStream.writeShort(n);
                }
            } else if (object instanceof Throwable) {
                Throwable throwable = (Throwable)object;
                dataOutputStream.write(23);
                this.write(dataOutputStream, clazz.getName());
                this.write(dataOutputStream, throwable.getMessage());
                this.write(dataOutputStream, throwable.getStackTrace());
                this.write(dataOutputStream, throwable.getCause());
            } else if (clazz == byte[].class) {
                byte[] byArray = (byte[])object;
                this.writeCalculatedType(dataOutputStream, byArray.length, 37, 59);
                dataOutputStream.write(0);
                dataOutputStream.write(byArray);
            } else if (clazz == char[].class) {
                char[] cArray = (char[])object;
                this.writeCalculatedType(dataOutputStream, cArray.length, 37, 59);
                dataOutputStream.write(1);
                int n = cArray.length;
                for (int i = 0; i < n; ++i) {
                    dataOutputStream.writeChar(cArray[i]);
                }
            } else if (clazz == boolean[].class) {
                boolean[] blArray = (boolean[])object;
                this.writeCalculatedType(dataOutputStream, blArray.length, 37, 59);
                dataOutputStream.write(2);
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    dataOutputStream.writeBoolean(blArray[i]);
                }
            } else if (clazz == float[].class) {
                float[] fArray = (float[])object;
                this.writeCalculatedType(dataOutputStream, fArray.length, 37, 59);
                dataOutputStream.write(3);
                int n = fArray.length;
                for (int i = 0; i < n; ++i) {
                    dataOutputStream.writeFloat(fArray[i]);
                }
            } else if (clazz == double[].class) {
                double[] dArray = (double[])object;
                this.writeCalculatedType(dataOutputStream, dArray.length, 37, 59);
                dataOutputStream.write(4);
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    dataOutputStream.writeDouble(dArray[i]);
                }
            } else if (clazz == short[].class) {
                short[] sArray = (short[])object;
                this.writeCalculatedType(dataOutputStream, sArray.length, 37, 59);
                dataOutputStream.write(5);
                int n = sArray.length;
                for (int i = 0; i < n; ++i) {
                    dataOutputStream.writeShort(sArray[i]);
                }
            } else if (clazz == int[].class) {
                int[] nArray = (int[])object;
                this.writeCalculatedType(dataOutputStream, nArray.length, 37, 59);
                dataOutputStream.write(6);
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    dataOutputStream.writeInt(nArray[i]);
                }
            } else if (clazz == long[].class) {
                long[] lArray = (long[])object;
                this.writeCalculatedType(dataOutputStream, lArray.length, 37, 59);
                dataOutputStream.write(7);
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    dataOutputStream.writeLong(lArray[i]);
                }
            } else if (clazz == Integer[].class) {
                Integer[] integerArray = (Integer[])object;
                this.writeCalculatedType(dataOutputStream, integerArray.length, 37, 59);
                dataOutputStream.write(8);
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    dataOutputStream.writeInt(integerArray[i]);
                }
            } else if (clazz == Long[].class) {
                Long[] longArray = (Long[])object;
                this.writeCalculatedType(dataOutputStream, longArray.length, 37, 59);
                dataOutputStream.write(9);
                int n = longArray.length;
                for (int i = 0; i < n; ++i) {
                    dataOutputStream.writeLong(longArray[i]);
                }
            } else if (clazz == StackTraceElement[].class) {
                StackTraceElement[] stackTraceElementArray = (StackTraceElement[])object;
                this.writeCalculatedType(dataOutputStream, stackTraceElementArray.length, 37, 59);
                dataOutputStream.write(19);
                int n = stackTraceElementArray.length;
                for (int i = 0; i < n; ++i) {
                    this.write(dataOutputStream, stackTraceElementArray[i].getClassName());
                    this.write(dataOutputStream, stackTraceElementArray[i].getMethodName());
                    this.write(dataOutputStream, stackTraceElementArray[i].getFileName());
                    this.write(dataOutputStream, stackTraceElementArray[i].getLineNumber());
                }
            } else if (clazz == Properties.class) {
                Properties properties = (Properties)object;
                this.writeCalculatedType(dataOutputStream, properties.size(), 37, 59);
                dataOutputStream.write(21);
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    Object object2 = enumeration.nextElement();
                    this.write(dataOutputStream, object2);
                    this.write(dataOutputStream, properties.get(object2));
                }
            } else if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                this.writeCalculatedType(dataOutputStream, objectArray.length, 37, 59);
                dataOutputStream.write(20);
                this.write(dataOutputStream, clazz.getComponentType().getName());
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    this.write(dataOutputStream, objectArray[i]);
                }
            } else {
                Object object3;
                Object[] objectArray = null;
                if (object instanceof MessageFormat) {
                    objectArray = new Object[]{((MessageFormat)object).toPattern()};
                } else if (object instanceof ChoiceFormat) {
                    objectArray = new Object[]{((ChoiceFormat)object).toPattern()};
                } else if (object instanceof DecimalFormat) {
                    object3 = (DecimalFormat)object;
                    objectArray = new Object[]{((DecimalFormat)object3).toPattern(), ((DecimalFormat)object3).getDecimalFormatSymbols()};
                } else if (object instanceof SimpleDateFormat) {
                    object3 = (SimpleDateFormat)object;
                    objectArray = new Object[]{((SimpleDateFormat)object3).toPattern(), ((SimpleDateFormat)object3).getDateFormatSymbols()};
                } else if (clazz == DecimalFormatSymbols.class) {
                    if (hmpDecFormatSymbols == null) {
                        ByteSerializer.initFormatSymbols();
                    }
                    objectArray = new Object[]{hmpDecFormatSymbols.get((DecimalFormatSymbols)object)};
                    if (SYSTEM_DECSYMBOLS.equals((DecimalFormatSymbols)object) || objectArray[0] == null) {
                        objectArray[0] = Locale.getDefault();
                    }
                } else if (clazz == DateFormatSymbols.class) {
                    if (hmpDateFormatSymbols == null) {
                        ByteSerializer.initFormatSymbols();
                    }
                    objectArray = new Object[]{hmpDateFormatSymbols.get((DateFormatSymbols)object)};
                    if (SYSTEM_DATESYMBOLS.equals((DateFormatSymbols)object) || objectArray[0] == null) {
                        objectArray[0] = Locale.getDefault();
                    }
                }
                if (objectArray != null) {
                    dataOutputStream.write(24);
                    this.write(dataOutputStream, clazz.getName());
                    this.write(dataOutputStream, objectArray);
                } else {
                    dataOutputStream.write(22);
                    object3 = new ObjectOutputStream(dataOutputStream);
                    ((ObjectOutputStream)object3).writeObject(object);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object read(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.read();
        if (n == -1) {
            throw new IOException("Type definition was not found");
        }
        if (n >= 99 && n < 256) {
            int n2 = this.readCalculatedType(dataInputStream, n, 99, 256);
            byte[] byArray = new byte[n2];
            dataInputStream.readFully(byArray);
            return new String(byArray, "UTF8");
        }
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return dataInputStream.readByte();
        }
        if (n == 2) {
            return Character.valueOf(dataInputStream.readChar());
        }
        if (n == 3) {
            return true;
        }
        if (n == 4) {
            return false;
        }
        if (n == 6) {
            return FLOAT_ZERO;
        }
        if (n == 5) {
            return new Float(dataInputStream.readFloat());
        }
        if (n == 8) {
            return 0.0;
        }
        if (n == 7) {
            return dataInputStream.readDouble();
        }
        if (n == 10) {
            return (short)0;
        }
        if (n == 9) {
            return dataInputStream.readShort();
        }
        if (n == 12) {
            return 0;
        }
        if (n == 11) {
            return dataInputStream.readInt();
        }
        if (n == 14) {
            return 0L;
        }
        if (n == 13) {
            return dataInputStream.readLong();
        }
        if (n == 15) {
            return new java.util.Date(dataInputStream.readLong());
        }
        if (n == 16) {
            return new Date(dataInputStream.readLong());
        }
        if (n == 17) {
            return new Time(dataInputStream.readLong());
        }
        if (n == 18 || n == 19) {
            Timestamp timestamp;
            Calendar calendar = this.calDate;
            synchronized (calendar) {
                this.calDate.set(5, dataInputStream.read());
                this.calDate.set(2, dataInputStream.read());
                this.calDate.set(1, dataInputStream.readShort());
                this.calDate.set(11, dataInputStream.read());
                this.calDate.set(12, dataInputStream.read());
                this.calDate.set(13, dataInputStream.read());
                this.calDate.set(14, 0);
                timestamp = new Timestamp(this.calDate.getTime().getTime());
                if (n == 18) {
                    timestamp.setNanos(dataInputStream.readInt());
                }
            }
            return timestamp;
        }
        if (n == 20) {
            return new StringBuffer((String)this.read(dataInputStream));
        }
        if (n == 21) {
            return new StringBuilder((String)this.read(dataInputStream));
        }
        if (n >= 59 && n < 69) {
            int n3 = this.readCalculatedType(dataInputStream, n, 59, 69);
            byte[] byArray = new byte[n3];
            dataInputStream.readFully(byArray);
            return new BigInteger(byArray);
        }
        if (n >= 79 && n < 89) {
            int n4 = this.readCalculatedType(dataInputStream, n, 79, 89);
            byte[] byArray = new byte[n4];
            dataInputStream.readFully(byArray);
            return new BigDecimal(new BigInteger(byArray), dataInputStream.readShort());
        }
        if (n >= 89 && n < 99) {
            int n5 = this.readCalculatedType(dataInputStream, n, 89, 99);
            byte[] byArray = new byte[n5];
            dataInputStream.readFully(byArray);
            return new BigDecimal(new BigInteger(byArray));
        }
        if (n == 24) {
            String string = (String)this.read(dataInputStream);
            Object[] objectArray = (Object[])this.read(dataInputStream);
            Constructor<?>[] constructorArray = Class.forName(string).getConstructors();
            int n6 = constructorArray.length;
            for (int i = 0; i < n6; ++i) {
                try {
                    if (objectArray.length != constructorArray[i].getParameterTypes().length) continue;
                    return constructorArray[i].newInstance(objectArray);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw new IOException("Reflective creation of '" + string + "' failed!");
        }
        if (n == 22) {
            ObjectInputStream objectInputStream = new ObjectInputStream(dataInputStream);
            return objectInputStream.readObject();
        }
        if (n == 23) {
            String string = (String)this.read(dataInputStream);
            String string2 = (String)this.read(dataInputStream);
            StackTraceElement[] stackTraceElementArray = (StackTraceElement[])this.read(dataInputStream);
            Throwable throwable = (Throwable)this.read(dataInputStream);
            try {
                Throwable throwable2 = (Throwable)Class.forName(string).getConstructor(String.class, Throwable.class).newInstance(string2, throwable);
                throwable2.setStackTrace(stackTraceElementArray);
                return throwable2;
            }
            catch (Throwable throwable3) {
                try {
                    Throwable throwable4 = (Throwable)Class.forName(string).getConstructor(String.class).newInstance(string2);
                    throwable4.setStackTrace(stackTraceElementArray);
                    return throwable4;
                }
                catch (Throwable throwable5) {
                    Exception exception = new Exception(string + ": " + string2, throwable);
                    exception.setStackTrace(stackTraceElementArray);
                    return exception;
                }
            }
        }
        if (n >= 37 && n < 59) {
            int n7 = this.readCalculatedType(dataInputStream, n, 37, 59);
            n = dataInputStream.read();
            if (n == 12) {
                String[] stringArray = new String[n7];
                for (int i = 0; i < n7; ++i) {
                    stringArray[i] = (String)this.read(dataInputStream);
                }
                return stringArray;
            }
            if (n == 13) {
                String[][] stringArrayArray = new String[n7][];
                for (int i = 0; i < n7; ++i) {
                    stringArrayArray[i] = (String[])this.read(dataInputStream);
                }
                return stringArrayArray;
            }
            if (n == 23) {
                String[][][] stringArrayArray = new String[n7][][];
                for (int i = 0; i < n7; ++i) {
                    stringArrayArray[i] = (String[][])this.read(dataInputStream);
                }
                return stringArrayArray;
            }
            if (n == 10) {
                Object[] objectArray = new Object[n7];
                for (int i = 0; i < n7; ++i) {
                    objectArray[i] = this.read(dataInputStream);
                }
                return objectArray;
            }
            if (n == 11) {
                Object[][] objectArrayArray = new Object[n7][];
                for (int i = 0; i < n7; ++i) {
                    objectArrayArray[i] = (Object[])this.read(dataInputStream);
                }
                return objectArrayArray;
            }
            if (n == 22) {
                Object[][][] objectArrayArray = new Object[n7][][];
                for (int i = 0; i < n7; ++i) {
                    objectArrayArray[i] = (Object[][])this.read(dataInputStream);
                }
                return objectArrayArray;
            }
            if (n == 0) {
                byte[] byArray = new byte[n7];
                dataInputStream.readFully(byArray);
                return byArray;
            }
            if (n == 2) {
                boolean[] blArray = new boolean[n7];
                for (int i = 0; i < n7; ++i) {
                    blArray[i] = dataInputStream.readBoolean();
                }
                return blArray;
            }
            if (n == 1) {
                char[] cArray = new char[n7];
                for (int i = 0; i < n7; ++i) {
                    cArray[i] = dataInputStream.readChar();
                }
                return cArray;
            }
            if (n == 3) {
                float[] fArray = new float[n7];
                for (int i = 0; i < n7; ++i) {
                    fArray[i] = dataInputStream.readFloat();
                }
                return fArray;
            }
            if (n == 4) {
                double[] dArray = new double[n7];
                for (int i = 0; i < n7; ++i) {
                    dArray[i] = dataInputStream.readDouble();
                }
                return dArray;
            }
            if (n == 5) {
                short[] sArray = new short[n7];
                for (int i = 0; i < n7; ++i) {
                    sArray[i] = dataInputStream.readShort();
                }
                return sArray;
            }
            if (n == 6) {
                int[] nArray = new int[n7];
                for (int i = 0; i < n7; ++i) {
                    nArray[i] = dataInputStream.readInt();
                }
                return nArray;
            }
            if (n == 7) {
                long[] lArray = new long[n7];
                for (int i = 0; i < n7; ++i) {
                    lArray[i] = dataInputStream.readLong();
                }
                return lArray;
            }
            if (n == 8) {
                Integer[] integerArray = new Integer[n7];
                for (int i = 0; i < n7; ++i) {
                    integerArray[i] = dataInputStream.readInt();
                }
                return integerArray;
            }
            if (n == 9) {
                Long[] longArray = new Long[n7];
                for (int i = 0; i < n7; ++i) {
                    longArray[i] = dataInputStream.readLong();
                }
                return longArray;
            }
            if (n == 19) {
                StackTraceElement[] stackTraceElementArray = new StackTraceElement[n7];
                int n8 = stackTraceElementArray.length;
                for (int i = 0; i < n8; ++i) {
                    stackTraceElementArray[i] = new StackTraceElement((String)this.read(dataInputStream), (String)this.read(dataInputStream), (String)this.read(dataInputStream), (Integer)this.read(dataInputStream));
                }
                return stackTraceElementArray;
            }
            if (n == 15) {
                ArrayUtil<Object> arrayUtil = new ArrayUtil<Object>();
                for (int i = 0; i < n7; ++i) {
                    arrayUtil.add(this.read(dataInputStream));
                }
                return arrayUtil;
            }
            if (n == 14) {
                ArrayList<Object> arrayList = new ArrayList<Object>(n7);
                for (int i = 0; i < n7; ++i) {
                    arrayList.add(this.read(dataInputStream));
                }
                return arrayList;
            }
            if (n == 16) {
                Vector<Object> vector = new Vector<Object>(n7);
                for (int i = 0; i < n7; ++i) {
                    vector.add(this.read(dataInputStream));
                }
                return vector;
            }
            if (n == 17) {
                Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(n7);
                for (int i = 0; i < n7; ++i) {
                    hashtable.put(this.read(dataInputStream), this.read(dataInputStream));
                }
                return hashtable;
            }
            if (n == 18) {
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>(n7);
                for (int i = 0; i < n7; ++i) {
                    hashMap.put(this.read(dataInputStream), this.read(dataInputStream));
                }
                return hashMap;
            }
            if (n == 21) {
                Properties properties = new Properties();
                for (int i = 0; i < n7; ++i) {
                    properties.put(this.read(dataInputStream), this.read(dataInputStream));
                }
                return properties;
            }
            if (n == 20) {
                String string = (String)this.read(dataInputStream);
                Object object = Array.newInstance(Class.forName(string), n7);
                for (int i = 0; i < n7; ++i) {
                    Array.set(object, i, this.read(dataInputStream));
                }
                return object;
            }
            throw new IOException("Unknown subtype: " + n);
        }
        throw new IOException("Unknown object type: " + n);
    }

    private final void writeCalculatedType(DataOutputStream dataOutputStream, int n, int n2, int n3) throws IOException {
        int n4 = n3 - n2;
        if (n < n4 - 3) {
            dataOutputStream.write(n2 + n);
        } else if (n < 253 + n4) {
            dataOutputStream.write(n2 + n4 - 3);
            dataOutputStream.write(n - n4 + 3);
        } else if (n < 65789 + n4) {
            dataOutputStream.write(n2 + n4 - 2);
            dataOutputStream.writeShort(n - 253 - n4);
        } else {
            dataOutputStream.write(n2 + n4 - 1);
            dataOutputStream.writeInt(n);
        }
    }

    private final int readCalculatedType(DataInputStream dataInputStream, int n, int n2, int n3) throws IOException {
        int n4 = n3 - n2;
        if (n < n2 + n4 - 3) {
            return n - n2;
        }
        if (n == n2 + n4 - 3) {
            return dataInputStream.readUnsignedByte() + n4 - 3;
        }
        if (n == n2 + n4 - 2) {
            return dataInputStream.readUnsignedShort() + 253 + n4;
        }
        return dataInputStream.readInt();
    }

    private static void initFormatSymbols() {
        Locale[] localeArray = new Locale[]{Locale.KOREA, Locale.KOREAN, Locale.JAPAN, Locale.JAPANESE, Locale.CHINA, Locale.CHINESE, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE, Locale.PRC, Locale.TAIWAN, Locale.UK, Locale.US, Locale.ENGLISH, Locale.CANADA, Locale.CANADA_FRENCH, Locale.FRANCE, Locale.FRENCH, Locale.ITALIAN, Locale.ITALY, Locale.GERMANY, Locale.GERMAN};
        hmpDateFormatSymbols = new HashMap();
        hmpDecFormatSymbols = new HashMap();
        int n = localeArray.length;
        for (int i = 0; i < n; ++i) {
            hmpDateFormatSymbols.put(new DateFormatSymbols(localeArray[i]), localeArray[i]);
            hmpDecFormatSymbols.put(new DecimalFormatSymbols(localeArray[i]), localeArray[i]);
        }
    }
}

