/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 09.01.2010 - [HM] - creation
 * 24.10.2012 - [JR] - #604: added constructor
 */
package javax.rad.genui.control;

import javax.rad.genui.UIFactoryManager;
import javax.rad.model.IDataBook;
import javax.rad.model.ModelException;
import javax.rad.ui.control.IChart;

/**
 * Platform and technology independent Table.
 * It is designed for use with AWT, Swing, SWT, JSP, JSF, ... .
 * 
 * @author Martin Handsteiner
 */
public class UIChart extends AbstractControllable<IChart> 
                     implements IChart
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	  
    /**
     * Creates a new instance of <code>UIChart</code>.
     *
     * @see IChart
     */
	public UIChart()
	{
		this(UIFactoryManager.getFactory().createChart());
	}

    /**
     * Creates a new instance of <code>UIChart</code> with the given chart.
     *
     * @param pChart the chart 
     * @see IChart
     */
	protected UIChart(IChart pChart)
	{
		super(pChart);

		setMaximumSize(800, 600);
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface Implementation
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * {@inheritDoc}
	 */
    public IDataBook getDataBook()
    {
    	return uiResource.getDataBook();
    }

	/**
	 * {@inheritDoc}
	 */
    public void setDataBook(IDataBook pDataBook)
    {
    	uiResource.setDataBook(pDataBook);
    }
	
	/** 
	 * {@inheritDoc}
	 */
	public IDataBook getActiveDataBook() 
	{
		return getDataBook();
	}

	/**
	 * {@inheritDoc}
	 */
	public int getChartStyle()
	{
		return uiResource.getChartStyle();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setChartStyle(int pChartStyle)
	{
		uiResource.setChartStyle(pChartStyle);
	}
	
	/**
	 * {@inheritDoc}
	 */
	public String getTitle()
	{
		return uiResource.getTitle();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setTitle(String pTitle)
	{
		uiResource.setTitle(pTitle);
	}

	/**
	 * {@inheritDoc}
	 */
	public String getXAxisTitle()
	{
		return uiResource.getXAxisTitle();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setXAxisTitle(String pXAxisTitle)
	{
		uiResource.setXAxisTitle(pXAxisTitle);
	}

	/**
	 * {@inheritDoc}
	 */
	public String getYAxisTitle()
	{
		return uiResource.getYAxisTitle();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setYAxisTitle(String pYAxisTitle)
	{
		uiResource.setYAxisTitle(pYAxisTitle);
	}

	/**
	 * {@inheritDoc}
	 */
	public String getXColumnName()
	{
		return uiResource.getXColumnName();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setXColumnName(String pXColumnName)
	{
		uiResource.setXColumnName(pXColumnName);
	}

	/**
	 * {@inheritDoc}
	 */
	public String[] getYColumnNames()
	{
		return uiResource.getYColumnNames();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setYColumnNames(String[] pYColumnNames)
	{
		uiResource.setYColumnNames(pYColumnNames);
	}	
	
	/**
	 * {@inheritDoc}
	 */
	public void notifyRepaint() 
	{
    	uiResource.notifyRepaint();
	}

	/**
	 * {@inheritDoc}
	 */
	public void startEditing() 
	{
    	uiResource.startEditing();
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void saveEditing() throws ModelException 
	{
    	uiResource.saveEditing();
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void cancelEditing() 
	{
    	uiResource.cancelEditing();
	}

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Overwritten methods
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void updateTranslation()
	{
		boolean bChanged = isTranslationChanged();

		super.updateTranslation();
		
		if (bChanged)
		{
			uiResource.setTranslation(getCurrentTranslation());
		}
	}

}	// UITable
