/*
 * Copyright 2013 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 27.09.2013 - [HM] - creation
 */
package com.sibvisions.rad.ui.swing.ext.celleditor;

import javax.rad.ui.celleditor.IInplaceCellEditor;

/**
 * The <code>JVxInplaceCellEditor</code> provides the styling of cell editors.
 * 
 * @author Martin Handsteiner
 */
public abstract class JVxInplaceCellEditor extends JVxStyledCellEditor 
                                           implements IInplaceCellEditor
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Class members
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/** the preferred editor mode. */
	private int	preferredEditorMode = IInplaceCellEditor.DOUBLE_CLICK;
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * Creates a new instance of <code>JVxInplaceCellEditor</code>.
	 */
	public JVxInplaceCellEditor()
	{
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Interface implementation
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * {@inheritDoc}
	 */
	public int getPreferredEditorMode()
	{
		return preferredEditorMode;
	}

	/**
	 * {@inheritDoc}
	 */
	public void setPreferredEditorMode(int pPreferredEditorMode)
	{
		preferredEditorMode = pPreferredEditorMode;
	}

}	// JVxInplaceCellEditor
