/*
 * Copyright 2012 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 20.07.2012 - [JR] - creation
 */
package com.sibvisions.rad.persist.jdbc.param;

/**
 * The <code>OutParam</code> is a simple output parameter for JDBC calls.
 * 
 * @author Ren Jahn
 */
public class OutParam extends AbstractParam
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Creates a new instance of <code>OutParam</code> for the given sql type.
	 * 
	 * @param pSqlType the sql type. All {@link java.sql.Types} are supported.
	 */
	public OutParam(int pSqlType)
	{
		super(ParameterType.Out, pSqlType, null);
	}

}	// OutParam
